# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.context import Context
from ..types.create_external_task_response import CreateExternalTaskResponse
from ..types.external_task_message import ExternalTaskMessage
from ..types.list_external_tasks_response import ListExternalTasksResponse
from .raw_client import AsyncRawExternalApisClient, RawExternalApisClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class ExternalApisClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawExternalApisClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawExternalApisClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawExternalApisClient
        """
        return self._raw_client

    def get_tasks_by_user_id(
        self,
        *,
        user_id: str,
        page: typing.Optional[int] = None,
        size: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ListExternalTasksResponse:
        """
        Parameters
        ----------
        user_id : str

        page : typing.Optional[int]

        size : typing.Optional[int]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ListExternalTasksResponse
            Successful Response

        Examples
        --------
        from aui import ApolloClient

        client = ApolloClient(
            network_api_key="YOUR_NETWORK_API_KEY",
        )
        client.external_apis.get_tasks_by_user_id(
            user_id="user_id",
            page=1,
            size=1,
        )
        """
        _response = self._raw_client.get_tasks_by_user_id(
            user_id=user_id, page=page, size=size, request_options=request_options
        )
        return _response.data

    def task(
        self, *, user_id: str, request_options: typing.Optional[RequestOptions] = None
    ) -> CreateExternalTaskResponse:
        """
        Parameters
        ----------
        user_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreateExternalTaskResponse
            Successful Response

        Examples
        --------
        from aui import ApolloClient

        client = ApolloClient(
            network_api_key="YOUR_NETWORK_API_KEY",
        )
        client.external_apis.task(
            user_id="user_id",
        )
        """
        _response = self._raw_client.task(user_id=user_id, request_options=request_options)
        return _response.data

    def get_task_messages(
        self, task_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.List[ExternalTaskMessage]:
        """
        Parameters
        ----------
        task_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[ExternalTaskMessage]
            Successful Response

        Examples
        --------
        from aui import ApolloClient

        client = ApolloClient(
            network_api_key="YOUR_NETWORK_API_KEY",
        )
        client.external_apis.get_task_messages(
            task_id="task_id",
        )
        """
        _response = self._raw_client.get_task_messages(task_id, request_options=request_options)
        return _response.data

    def message(
        self,
        *,
        task_id: str,
        text: str,
        is_external_api: typing.Optional[bool] = None,
        context: typing.Optional[Context] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ExternalTaskMessage:
        """
        Parameters
        ----------
        task_id : str

        text : str

        is_external_api : typing.Optional[bool]

        context : typing.Optional[Context]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ExternalTaskMessage
            Successful Response

        Examples
        --------
        from aui import ApolloClient

        client = ApolloClient(
            network_api_key="YOUR_NETWORK_API_KEY",
        )
        client.external_apis.message(
            is_external_api=True,
            task_id="task_id",
            text="text",
        )
        """
        _response = self._raw_client.message(
            task_id=task_id,
            text=text,
            is_external_api=is_external_api,
            context=context,
            request_options=request_options,
        )
        return _response.data


class AsyncExternalApisClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawExternalApisClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawExternalApisClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawExternalApisClient
        """
        return self._raw_client

    async def get_tasks_by_user_id(
        self,
        *,
        user_id: str,
        page: typing.Optional[int] = None,
        size: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ListExternalTasksResponse:
        """
        Parameters
        ----------
        user_id : str

        page : typing.Optional[int]

        size : typing.Optional[int]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ListExternalTasksResponse
            Successful Response

        Examples
        --------
        import asyncio

        from aui import AsyncApolloClient

        client = AsyncApolloClient(
            network_api_key="YOUR_NETWORK_API_KEY",
        )


        async def main() -> None:
            await client.external_apis.get_tasks_by_user_id(
                user_id="user_id",
                page=1,
                size=1,
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_tasks_by_user_id(
            user_id=user_id, page=page, size=size, request_options=request_options
        )
        return _response.data

    async def task(
        self, *, user_id: str, request_options: typing.Optional[RequestOptions] = None
    ) -> CreateExternalTaskResponse:
        """
        Parameters
        ----------
        user_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreateExternalTaskResponse
            Successful Response

        Examples
        --------
        import asyncio

        from aui import AsyncApolloClient

        client = AsyncApolloClient(
            network_api_key="YOUR_NETWORK_API_KEY",
        )


        async def main() -> None:
            await client.external_apis.task(
                user_id="user_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.task(user_id=user_id, request_options=request_options)
        return _response.data

    async def get_task_messages(
        self, task_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.List[ExternalTaskMessage]:
        """
        Parameters
        ----------
        task_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[ExternalTaskMessage]
            Successful Response

        Examples
        --------
        import asyncio

        from aui import AsyncApolloClient

        client = AsyncApolloClient(
            network_api_key="YOUR_NETWORK_API_KEY",
        )


        async def main() -> None:
            await client.external_apis.get_task_messages(
                task_id="task_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_task_messages(task_id, request_options=request_options)
        return _response.data

    async def message(
        self,
        *,
        task_id: str,
        text: str,
        is_external_api: typing.Optional[bool] = None,
        context: typing.Optional[Context] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ExternalTaskMessage:
        """
        Parameters
        ----------
        task_id : str

        text : str

        is_external_api : typing.Optional[bool]

        context : typing.Optional[Context]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ExternalTaskMessage
            Successful Response

        Examples
        --------
        import asyncio

        from aui import AsyncApolloClient

        client = AsyncApolloClient(
            network_api_key="YOUR_NETWORK_API_KEY",
        )


        async def main() -> None:
            await client.external_apis.message(
                is_external_api=True,
                task_id="task_id",
                text="text",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.message(
            task_id=task_id,
            text=text,
            is_external_api=is_external_api,
            context=context,
            request_options=request_options,
        )
        return _response.data
