# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .product_card import ProductCard
from .ws_actor import WsActor


class FinalMessagePayload(UniversalBaseModel):
    id: str
    created_at: dt.datetime
    text: str = pydantic.Field()
    """
    Complete response text
    """

    sender: WsActor
    receiver: WsActor
    cards: typing.Optional[typing.List[ProductCard]] = pydantic.Field(default=None)
    """
    Product recommendation cards
    """

    followup_suggestions: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    Suggested follow-up questions
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
