"""
    Agilicus API

    Agilicus is API-first. Modern software is controlled by other software, is open, is available for you to use the way you want, securely, simply.  The OpenAPI Specification in YAML format is available on [www](https://www.agilicus.com/www/api/agilicus-openapi.yaml) for importing to other tools.  A rendered, online viewable and usable version of this specification is available at [api](https://www.agilicus.com/api). You may try the API inline directly in the web page. To do so, first obtain an Authentication Token (the simplest way is to install the Python SDK, and then run `agilicus-cli --issuer https://MYISSUER get-token`). You will need an org-id for most calls (and can obtain from `agilicus-cli --issuer https://MYISSUER list-orgs`). The `MYISSUER` will typically be `auth.MYDOMAIN`, and you will see it as you sign-in to the administrative UI.  This API releases on Bearer-Token authentication. To obtain a valid bearer token you will need to Authenticate to an Issuer with OpenID Connect (a superset of OAUTH2).  Your \"issuer\" will look like https://auth.MYDOMAIN. For example, when you signed-up, if you said \"use my own domain name\" and assigned a CNAME of cloud.example.com, then your issuer would be https://auth.cloud.example.com.  If you selected \"use an Agilicus supplied domain name\", your issuer would look like https://auth.myorg.agilicus.cloud.  For test purposes you can use our [Python SDK](https://pypi.org/project/agilicus/) and run `agilicus-cli --issuer https://auth.MYDOMAIN get-token`.  This API may be used in any language runtime that supports OpenAPI 3.0, or, you may use our [Python SDK](https://pypi.org/project/agilicus/), our [Typescript SDK](https://www.npmjs.com/package/@agilicus/angular), or our [Golang SDK](https://git.agilicus.com/pub/sdk-go).  100% of the activities in our system our API-driven, from our web-admin, through our progressive web applications, to all internals: there is nothing that is not accessible.  For more information, see [developer resources](https://www.agilicus.com/developer).   # noqa: E501

    The version of the OpenAPI document: 2025.10.14
    Contact: dev@agilicus.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from agilicus_api.api_client import ApiClient, Endpoint as _Endpoint
from agilicus_api.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from agilicus_api.model.clear_file_association_request import ClearFileAssociationRequest
from agilicus_api.model.clear_file_association_response import ClearFileAssociationResponse
from agilicus_api.model.error_message import ErrorMessage
from agilicus_api.model.file import File
from agilicus_api.model.file_association import FileAssociation
from agilicus_api.model.file_name import FileName
from agilicus_api.model.file_summary import FileSummary
from agilicus_api.model.file_template import FileTemplate
from agilicus_api.model.file_template_render_request import FileTemplateRenderRequest
from agilicus_api.model.file_visibility import FileVisibility
from agilicus_api.model.list_file_associations_response import ListFileAssociationsResponse
from agilicus_api.model.list_file_templates_response import ListFileTemplatesResponse
from agilicus_api.model.list_files_response import ListFilesResponse
from agilicus_api.model.list_public_file_org_links_response import ListPublicFileOrgLinksResponse
from agilicus_api.model.object_oper_status import ObjectOperStatus
from agilicus_api.model.object_type import ObjectType
from agilicus_api.model.public_file_org_link import PublicFileOrgLink
from agilicus_api.model.storage_region import StorageRegion


class FilesApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        def __add_file(
            self,
            name,
            file_zip,
            **kwargs
        ):
            """upload a file  # noqa: E501

            Upload a file  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.add_file(name, file_zip, async_req=True)
            >>> result = thread.get()

            Args:
                name (FileName):
                file_zip (file_type): The contents of the file in binary format

            Keyword Args:
                org_id (str): Unique identifier. [optional]
                tag (str): A file tag. [optional]
                label (str): A file label. [optional]
                region (StorageRegion): [optional]
                visibility (FileVisibility): [optional]
                md5_hash (str): MD5 Hash of file in base64. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                FileSummary
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['name'] = \
                name
            kwargs['file_zip'] = \
                file_zip
            return self.call_with_http_info(**kwargs)

        if self.add_file is None:
            self.add_file = _Endpoint(
                settings={
                    'response_type': (FileSummary,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/files',
                    'operation_id': 'add_file',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'name',
                        'file_zip',
                        'org_id',
                        'tag',
                        'label',
                        'region',
                        'visibility',
                        'md5_hash',
                    ],
                    'required': [
                        'name',
                        'file_zip',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'name':
                            (FileName,),
                        'file_zip':
                            (file_type,),
                        'org_id':
                            (str,),
                        'tag':
                            (str,),
                        'label':
                            (str,),
                        'region':
                            (StorageRegion,),
                        'visibility':
                            (FileVisibility,),
                        'md5_hash':
                            (str,),
                    },
                    'attribute_map': {
                        'name': 'name',
                        'file_zip': 'file_zip',
                        'org_id': 'org_id',
                        'tag': 'tag',
                        'label': 'label',
                        'region': 'region',
                        'visibility': 'visibility',
                        'md5_hash': 'md5_hash',
                    },
                    'location_map': {
                        'name': 'form',
                        'file_zip': 'form',
                        'org_id': 'form',
                        'tag': 'form',
                        'label': 'form',
                        'region': 'form',
                        'visibility': 'form',
                        'md5_hash': 'form',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'multipart/form-data'
                    ]
                },
                api_client=api_client,
                callable=__add_file
            )

        def __create_file_association(
            self,
            file_association,
            **kwargs
        ):
            """associate a file with an object  # noqa: E501

            associate a file with an objet  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_file_association(file_association, async_req=True)
            >>> result = thread.get()

            Args:
                file_association (FileAssociation): The file association

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                FileAssociation
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['file_association'] = \
                file_association
            return self.call_with_http_info(**kwargs)

        if self.create_file_association is None:
            self.create_file_association = _Endpoint(
                settings={
                    'response_type': (FileAssociation,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/file_associations',
                    'operation_id': 'create_file_association',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'file_association',
                    ],
                    'required': [
                        'file_association',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'file_association':
                            (FileAssociation,),
                    },
                    'attribute_map': {
                    },
                    'location_map': {
                        'file_association': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__create_file_association
            )

        def __create_file_association_clear_task(
            self,
            clear_file_association_request,
            **kwargs
        ):
            """Cleans up file associations  # noqa: E501

            Cleans up file associations, potentially marking files for garbage collection  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_file_association_clear_task(clear_file_association_request, async_req=True)
            >>> result = thread.get()

            Args:
                clear_file_association_request (ClearFileAssociationRequest): The description of the cleanup task

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ClearFileAssociationResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['clear_file_association_request'] = \
                clear_file_association_request
            return self.call_with_http_info(**kwargs)

        if self.create_file_association_clear_task is None:
            self.create_file_association_clear_task = _Endpoint(
                settings={
                    'response_type': (ClearFileAssociationResponse,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/file_association_clear',
                    'operation_id': 'create_file_association_clear_task',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'clear_file_association_request',
                    ],
                    'required': [
                        'clear_file_association_request',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'clear_file_association_request':
                            (ClearFileAssociationRequest,),
                    },
                    'attribute_map': {
                    },
                    'location_map': {
                        'clear_file_association_request': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__create_file_association_clear_task
            )

        def __create_file_template(
            self,
            file_template,
            **kwargs
        ):
            """Add a file template  # noqa: E501

            Adds a new file template.   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_file_template(file_template, async_req=True)
            >>> result = thread.get()

            Args:
                file_template (FileTemplate):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                FileTemplate
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['file_template'] = \
                file_template
            return self.call_with_http_info(**kwargs)

        if self.create_file_template is None:
            self.create_file_template = _Endpoint(
                settings={
                    'response_type': (FileTemplate,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/file_templates',
                    'operation_id': 'create_file_template',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'file_template',
                    ],
                    'required': [
                        'file_template',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'file_template':
                            (FileTemplate,),
                    },
                    'attribute_map': {
                    },
                    'location_map': {
                        'file_template': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__create_file_template
            )

        def __create_public_file_org_link(
            self,
            public_file_org_link,
            **kwargs
        ):
            """link public files based on org  # noqa: E501

            links public files based on organisation and tag  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_public_file_org_link(public_file_org_link, async_req=True)
            >>> result = thread.get()

            Args:
                public_file_org_link (PublicFileOrgLink): The link to create

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                PublicFileOrgLink
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['public_file_org_link'] = \
                public_file_org_link
            return self.call_with_http_info(**kwargs)

        if self.create_public_file_org_link is None:
            self.create_public_file_org_link = _Endpoint(
                settings={
                    'response_type': (PublicFileOrgLink,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/public_file_org_links',
                    'operation_id': 'create_public_file_org_link',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'public_file_org_link',
                    ],
                    'required': [
                        'public_file_org_link',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'public_file_org_link':
                            (PublicFileOrgLink,),
                    },
                    'attribute_map': {
                    },
                    'location_map': {
                        'public_file_org_link': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__create_public_file_org_link
            )

        def __delete_file(
            self,
            file_id,
            **kwargs
        ):
            """Delete a File  # noqa: E501

            Delete a File  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_file(file_id, async_req=True)
            >>> result = thread.get()

            Args:
                file_id (str): file_id path

            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['file_id'] = \
                file_id
            return self.call_with_http_info(**kwargs)

        if self.delete_file is None:
            self.delete_file = _Endpoint(
                settings={
                    'response_type': None,
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/files/{file_id}',
                    'operation_id': 'delete_file',
                    'http_method': 'DELETE',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'file_id',
                        'org_id',
                    ],
                    'required': [
                        'file_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'file_id':
                            (str,),
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'file_id': 'file_id',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'file_id': 'path',
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__delete_file
            )

        def __delete_file_association(
            self,
            file_association_id,
            **kwargs
        ):
            """Remove an association from a file  # noqa: E501

            Remove an association from a file  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_file_association(file_association_id, async_req=True)
            >>> result = thread.get()

            Args:
                file_association_id (str): file association id in path

            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['file_association_id'] = \
                file_association_id
            return self.call_with_http_info(**kwargs)

        if self.delete_file_association is None:
            self.delete_file_association = _Endpoint(
                settings={
                    'response_type': None,
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/file_associations/{file_association_id}',
                    'operation_id': 'delete_file_association',
                    'http_method': 'DELETE',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'file_association_id',
                        'org_id',
                    ],
                    'required': [
                        'file_association_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'file_association_id':
                            (str,),
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'file_association_id': 'file_association_id',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'file_association_id': 'path',
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__delete_file_association
            )

        def __delete_file_template(
            self,
            file_template_id,
            **kwargs
        ):
            """Delete a file template  # noqa: E501

            Delete a file template  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_file_template(file_template_id, async_req=True)
            >>> result = thread.get()

            Args:
                file_template_id (str): file_template_id in path

            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['file_template_id'] = \
                file_template_id
            return self.call_with_http_info(**kwargs)

        if self.delete_file_template is None:
            self.delete_file_template = _Endpoint(
                settings={
                    'response_type': None,
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/file_templates/{file_template_id}',
                    'operation_id': 'delete_file_template',
                    'http_method': 'DELETE',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'file_template_id',
                        'org_id',
                    ],
                    'required': [
                        'file_template_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'file_template_id':
                            (str,),
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'file_template_id': 'file_template_id',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'file_template_id': 'path',
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__delete_file_template
            )

        def __delete_public_file_org_link(
            self,
            public_file_org_link_id,
            **kwargs
        ):
            """Remove a link from an org  # noqa: E501

            Remove a link from an org. Note that link_org_id and org_id are alises for one another in this query.   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_public_file_org_link(public_file_org_link_id, async_req=True)
            >>> result = thread.get()

            Args:
                public_file_org_link_id (str): public file org link id in path

            Keyword Args:
                link_org_id (str): Search for the Organisation that is linked to another. [optional]
                org_id (str): Organisation Unique identifier. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['public_file_org_link_id'] = \
                public_file_org_link_id
            return self.call_with_http_info(**kwargs)

        if self.delete_public_file_org_link is None:
            self.delete_public_file_org_link = _Endpoint(
                settings={
                    'response_type': None,
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/public_file_org_links/{public_file_org_link_id}',
                    'operation_id': 'delete_public_file_org_link',
                    'http_method': 'DELETE',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'public_file_org_link_id',
                        'link_org_id',
                        'org_id',
                    ],
                    'required': [
                        'public_file_org_link_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'public_file_org_link_id':
                            (str,),
                        'link_org_id':
                            (str,),
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'public_file_org_link_id': 'public_file_org_link_id',
                        'link_org_id': 'link_org_id',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'public_file_org_link_id': 'path',
                        'link_org_id': 'query',
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__delete_public_file_org_link
            )

        def __get_download(
            self,
            file_id,
            **kwargs
        ):
            """Download File  # noqa: E501

            Download File  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_download(file_id, async_req=True)
            >>> result = thread.get()

            Args:
                file_id (str): file_id path

            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                file_type
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['file_id'] = \
                file_id
            return self.call_with_http_info(**kwargs)

        if self.get_download is None:
            self.get_download = _Endpoint(
                settings={
                    'response_type': (file_type,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/files_download/{file_id}',
                    'operation_id': 'get_download',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'file_id',
                        'org_id',
                    ],
                    'required': [
                        'file_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'file_id':
                            (str,),
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'file_id': 'file_id',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'file_id': 'path',
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/octet-stream'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__get_download
            )

        def __get_download_public(
            self,
            **kwargs
        ):
            """Download public file  # noqa: E501

            Download public file  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_download_public(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                subdomain (str): query based on organisation subdomain . [optional]
                label (str): Filters based on whether or not the items in the collection have the given label. . [optional]
                tag (str): Search files based on tag. [optional]
                file_in_zip (str): query based on file name inside a zip file . [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                file_type
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        if self.get_download_public is None:
            self.get_download_public = _Endpoint(
                settings={
                    'response_type': (file_type,),
                    'auth': [],
                    'endpoint_path': '/v1/files_public',
                    'operation_id': 'get_download_public',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'subdomain',
                        'label',
                        'tag',
                        'file_in_zip',
                    ],
                    'required': [],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'subdomain':
                            (str,),
                        'label':
                            (str,),
                        'tag':
                            (str,),
                        'file_in_zip':
                            (str,),
                    },
                    'attribute_map': {
                        'subdomain': 'subdomain',
                        'label': 'label',
                        'tag': 'tag',
                        'file_in_zip': 'file_in_zip',
                    },
                    'location_map': {
                        'subdomain': 'query',
                        'label': 'query',
                        'tag': 'query',
                        'file_in_zip': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/octet-stream',
                        'application/gzip'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__get_download_public
            )

        def __get_file(
            self,
            file_id,
            **kwargs
        ):
            """Get File metadata  # noqa: E501

            Get File metadata  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_file(file_id, async_req=True)
            >>> result = thread.get()

            Args:
                file_id (str): file_id path

            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                FileSummary
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['file_id'] = \
                file_id
            return self.call_with_http_info(**kwargs)

        if self.get_file is None:
            self.get_file = _Endpoint(
                settings={
                    'response_type': (FileSummary,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/files/{file_id}',
                    'operation_id': 'get_file',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'file_id',
                        'org_id',
                    ],
                    'required': [
                        'file_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'file_id':
                            (str,),
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'file_id': 'file_id',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'file_id': 'path',
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__get_file
            )

        def __get_file_association(
            self,
            file_association_id,
            **kwargs
        ):
            """Get a file association  # noqa: E501

            Get a file association  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_file_association(file_association_id, async_req=True)
            >>> result = thread.get()

            Args:
                file_association_id (str): file association id in path

            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                FileAssociation
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['file_association_id'] = \
                file_association_id
            return self.call_with_http_info(**kwargs)

        if self.get_file_association is None:
            self.get_file_association = _Endpoint(
                settings={
                    'response_type': (FileAssociation,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/file_associations/{file_association_id}',
                    'operation_id': 'get_file_association',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'file_association_id',
                        'org_id',
                    ],
                    'required': [
                        'file_association_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'file_association_id':
                            (str,),
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'file_association_id': 'file_association_id',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'file_association_id': 'path',
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__get_file_association
            )

        def __get_file_template(
            self,
            file_template_id,
            **kwargs
        ):
            """Get a file template  # noqa: E501

            Get a file template  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_file_template(file_template_id, async_req=True)
            >>> result = thread.get()

            Args:
                file_template_id (str): file_template_id in path

            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                FileTemplate
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['file_template_id'] = \
                file_template_id
            return self.call_with_http_info(**kwargs)

        if self.get_file_template is None:
            self.get_file_template = _Endpoint(
                settings={
                    'response_type': (FileTemplate,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/file_templates/{file_template_id}',
                    'operation_id': 'get_file_template',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'file_template_id',
                        'org_id',
                    ],
                    'required': [
                        'file_template_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'file_template_id':
                            (str,),
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'file_template_id': 'file_template_id',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'file_template_id': 'path',
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__get_file_template
            )

        def __get_public_file_org_link(
            self,
            public_file_org_link_id,
            **kwargs
        ):
            """Get a public file org link  # noqa: E501

            Get a public file org link. Note that link_org_id and org_id are alises for one another in this query.   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_public_file_org_link(public_file_org_link_id, async_req=True)
            >>> result = thread.get()

            Args:
                public_file_org_link_id (str): public file org link id in path

            Keyword Args:
                link_org_id (str): Search for the Organisation that is linked to another. [optional]
                org_id (str): Organisation Unique identifier. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                PublicFileOrgLink
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['public_file_org_link_id'] = \
                public_file_org_link_id
            return self.call_with_http_info(**kwargs)

        if self.get_public_file_org_link is None:
            self.get_public_file_org_link = _Endpoint(
                settings={
                    'response_type': (PublicFileOrgLink,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/public_file_org_links/{public_file_org_link_id}',
                    'operation_id': 'get_public_file_org_link',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'public_file_org_link_id',
                        'link_org_id',
                        'org_id',
                    ],
                    'required': [
                        'public_file_org_link_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'public_file_org_link_id':
                            (str,),
                        'link_org_id':
                            (str,),
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'public_file_org_link_id': 'public_file_org_link_id',
                        'link_org_id': 'link_org_id',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'public_file_org_link_id': 'path',
                        'link_org_id': 'query',
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__get_public_file_org_link
            )

        def __list_file_associations(
            self,
            **kwargs
        ):
            """Query File Associations  # noqa: E501

            Query File Associations  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_file_associations(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                limit (int): limit the number of rows in the response. [optional] if omitted the server will use the default value of 500
                org_id (str): Organisation Unique identifier. [optional]
                file_id (str): search by file id. [optional]
                object_id (str): search by object id. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListFileAssociationsResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        if self.list_file_associations is None:
            self.list_file_associations = _Endpoint(
                settings={
                    'response_type': (ListFileAssociationsResponse,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/file_associations',
                    'operation_id': 'list_file_associations',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'limit',
                        'org_id',
                        'file_id',
                        'object_id',
                    ],
                    'required': [],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'limit',
                    ]
                },
                root_map={
                    'validations': {
                        ('limit',): {

                            'inclusive_maximum': 500,
                            'inclusive_minimum': 1,
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'limit':
                            (int,),
                        'org_id':
                            (str,),
                        'file_id':
                            (str,),
                        'object_id':
                            (str,),
                    },
                    'attribute_map': {
                        'limit': 'limit',
                        'org_id': 'org_id',
                        'file_id': 'file_id',
                        'object_id': 'object_id',
                    },
                    'location_map': {
                        'limit': 'query',
                        'org_id': 'query',
                        'file_id': 'query',
                        'object_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__list_file_associations
            )

        def __list_file_templates(
            self,
            **kwargs
        ):
            """List all file templates  # noqa: E501

            List all file templates matching the provided query parameters. Perform keyset pagination by setting the page_at_id parameter to the id for the next page to fetch. Set it to `\"\"` to start from the beginning.   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_file_templates(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                limit (int): limit the number of rows in the response. [optional] if omitted the server will use the default value of 500
                page_at_id (str): Pagination based query with the id as the key. To get the initial entries supply an empty string. On subsequent requests, supply the `page_at_id` field from the list response. . [optional]
                org_id (str): Organisation Unique identifier. [optional]
                purpose (str): The purpose of an item. [optional]
                object_types ([ObjectType]): A list of object types. Returns all items which match at least one of the types. . [optional]
                object_ids ([str]): A list of object IDs. Returns all items which match at least one of the . . [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListFileTemplatesResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        if self.list_file_templates is None:
            self.list_file_templates = _Endpoint(
                settings={
                    'response_type': (ListFileTemplatesResponse,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/file_templates',
                    'operation_id': 'list_file_templates',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'limit',
                        'page_at_id',
                        'org_id',
                        'purpose',
                        'object_types',
                        'object_ids',
                    ],
                    'required': [],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'limit',
                    ]
                },
                root_map={
                    'validations': {
                        ('limit',): {

                            'inclusive_maximum': 500,
                            'inclusive_minimum': 1,
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'limit':
                            (int,),
                        'page_at_id':
                            (str,),
                        'org_id':
                            (str,),
                        'purpose':
                            (str,),
                        'object_types':
                            ([ObjectType],),
                        'object_ids':
                            ([str],),
                    },
                    'attribute_map': {
                        'limit': 'limit',
                        'page_at_id': 'page_at_id',
                        'org_id': 'org_id',
                        'purpose': 'purpose',
                        'object_types': 'object_types',
                        'object_ids': 'object_ids',
                    },
                    'location_map': {
                        'limit': 'query',
                        'page_at_id': 'query',
                        'org_id': 'query',
                        'purpose': 'query',
                        'object_types': 'query',
                        'object_ids': 'query',
                    },
                    'collection_format_map': {
                        'object_types': 'multi',
                        'object_ids': 'multi',
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__list_file_templates
            )

        def __list_files(
            self,
            **kwargs
        ):
            """Query Files  # noqa: E501

            Query Files  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_files(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                limit (int): limit the number of rows in the response. [optional] if omitted the server will use the default value of 500
                org_id (str): Organisation Unique identifier. [optional]
                user_id (str): Query based on user id. [optional]
                tag (str): Search files based on tag. [optional]
                file_association_id (str): search by file association's id. [optional]
                object_oper_status (ObjectOperStatus): search by object oper status. [optional]
                has_been_associated (bool): Only return object that have ever been associated. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListFilesResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        if self.list_files is None:
            self.list_files = _Endpoint(
                settings={
                    'response_type': (ListFilesResponse,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/files',
                    'operation_id': 'list_files',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'limit',
                        'org_id',
                        'user_id',
                        'tag',
                        'file_association_id',
                        'object_oper_status',
                        'has_been_associated',
                    ],
                    'required': [],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'limit',
                    ]
                },
                root_map={
                    'validations': {
                        ('limit',): {

                            'inclusive_maximum': 500,
                            'inclusive_minimum': 1,
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'limit':
                            (int,),
                        'org_id':
                            (str,),
                        'user_id':
                            (str,),
                        'tag':
                            (str,),
                        'file_association_id':
                            (str,),
                        'object_oper_status':
                            (ObjectOperStatus,),
                        'has_been_associated':
                            (bool,),
                    },
                    'attribute_map': {
                        'limit': 'limit',
                        'org_id': 'org_id',
                        'user_id': 'user_id',
                        'tag': 'tag',
                        'file_association_id': 'file_association_id',
                        'object_oper_status': 'object_oper_status',
                        'has_been_associated': 'has_been_associated',
                    },
                    'location_map': {
                        'limit': 'query',
                        'org_id': 'query',
                        'user_id': 'query',
                        'tag': 'query',
                        'file_association_id': 'query',
                        'object_oper_status': 'query',
                        'has_been_associated': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__list_files
            )

        def __list_public_file_org_links(
            self,
            **kwargs
        ):
            """Query Public File Org Links  # noqa: E501

            Query Public File Org Links. Note that link_org_id and org_id are alises for one another in this query.   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_public_file_org_links(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                limit (int): limit the number of rows in the response. [optional] if omitted the server will use the default value of 500
                link_org_id (str): Search for the Organisation that is linked to another. [optional]
                org_id (str): Organisation Unique identifier. [optional]
                tag (str): Search files based on tag. [optional]
                page_at_id (str): Pagination based query with the id as the key. To get the initial entries supply an empty string. On subsequent requests, supply the `page_at_id` field from the list response. . [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListPublicFileOrgLinksResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        if self.list_public_file_org_links is None:
            self.list_public_file_org_links = _Endpoint(
                settings={
                    'response_type': (ListPublicFileOrgLinksResponse,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/public_file_org_links',
                    'operation_id': 'list_public_file_org_links',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'limit',
                        'link_org_id',
                        'org_id',
                        'tag',
                        'page_at_id',
                    ],
                    'required': [],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'limit',
                    ]
                },
                root_map={
                    'validations': {
                        ('limit',): {

                            'inclusive_maximum': 500,
                            'inclusive_minimum': 1,
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'limit':
                            (int,),
                        'link_org_id':
                            (str,),
                        'org_id':
                            (str,),
                        'tag':
                            (str,),
                        'page_at_id':
                            (str,),
                    },
                    'attribute_map': {
                        'limit': 'limit',
                        'link_org_id': 'link_org_id',
                        'org_id': 'org_id',
                        'tag': 'tag',
                        'page_at_id': 'page_at_id',
                    },
                    'location_map': {
                        'limit': 'query',
                        'link_org_id': 'query',
                        'org_id': 'query',
                        'tag': 'query',
                        'page_at_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__list_public_file_org_links
            )

        def __render_file_template(
            self,
            file_template_id,
            file_template_render_request,
            **kwargs
        ):
            """Render a file template  # noqa: E501

            Renders a file template, applying the static and request arguments to the contents of the template. If the backing file does not exist, this will return a 404 indicating so. If the input is missing a required parameter, this will return a 400.   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.render_file_template(file_template_id, file_template_render_request, async_req=True)
            >>> result = thread.get()

            Args:
                file_template_id (str): file_template_id in path
                file_template_render_request (FileTemplateRenderRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                file_type
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['file_template_id'] = \
                file_template_id
            kwargs['file_template_render_request'] = \
                file_template_render_request
            return self.call_with_http_info(**kwargs)

        if self.render_file_template is None:
            self.render_file_template = _Endpoint(
                settings={
                    'response_type': (file_type,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/file_templates/{file_template_id}/render',
                    'operation_id': 'render_file_template',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'file_template_id',
                        'file_template_render_request',
                    ],
                    'required': [
                        'file_template_id',
                        'file_template_render_request',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'file_template_id':
                            (str,),
                        'file_template_render_request':
                            (FileTemplateRenderRequest,),
                    },
                    'attribute_map': {
                        'file_template_id': 'file_template_id',
                    },
                    'location_map': {
                        'file_template_id': 'path',
                        'file_template_render_request': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        '*/*',
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__render_file_template
            )

        def __replace_file(
            self,
            file_id,
            file,
            **kwargs
        ):
            """Update a file  # noqa: E501

            Update a file  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.replace_file(file_id, file, async_req=True)
            >>> result = thread.get()

            Args:
                file_id (str): file_id path
                file (File): Upload file request

            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                FileSummary
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['file_id'] = \
                file_id
            kwargs['file'] = \
                file
            return self.call_with_http_info(**kwargs)

        if self.replace_file is None:
            self.replace_file = _Endpoint(
                settings={
                    'response_type': (FileSummary,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/files/{file_id}',
                    'operation_id': 'replace_file',
                    'http_method': 'PUT',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'file_id',
                        'file',
                        'org_id',
                    ],
                    'required': [
                        'file_id',
                        'file',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'file_id':
                            (str,),
                        'file':
                            (File,),
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'file_id': 'file_id',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'file_id': 'path',
                        'file': 'body',
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__replace_file
            )

        def __replace_file_template(
            self,
            file_template_id,
            **kwargs
        ):
            """update a file template  # noqa: E501

            update a file template  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.replace_file_template(file_template_id, async_req=True)
            >>> result = thread.get()

            Args:
                file_template_id (str): file_template_id in path

            Keyword Args:
                file_template (FileTemplate): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                FileTemplate
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['file_template_id'] = \
                file_template_id
            return self.call_with_http_info(**kwargs)

        if self.replace_file_template is None:
            self.replace_file_template = _Endpoint(
                settings={
                    'response_type': (FileTemplate,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/file_templates/{file_template_id}',
                    'operation_id': 'replace_file_template',
                    'http_method': 'PUT',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'file_template_id',
                        'file_template',
                    ],
                    'required': [
                        'file_template_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'file_template_id':
                            (str,),
                        'file_template':
                            (FileTemplate,),
                    },
                    'attribute_map': {
                        'file_template_id': 'file_template_id',
                    },
                    'location_map': {
                        'file_template_id': 'path',
                        'file_template': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__replace_file_template
            )

        def __replace_public_file_org_link(
            self,
            public_file_org_link_id,
            public_file_org_link,
            **kwargs
        ):
            """Replace a public file org link  # noqa: E501

            Replace a public file org link  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.replace_public_file_org_link(public_file_org_link_id, public_file_org_link, async_req=True)
            >>> result = thread.get()

            Args:
                public_file_org_link_id (str): public file org link id in path
                public_file_org_link (PublicFileOrgLink): The link to update

            Keyword Args:
                link_org_id (str): Search for the Organisation that is linked to another. [optional]
                org_id (str): Organisation Unique identifier. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                PublicFileOrgLink
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['public_file_org_link_id'] = \
                public_file_org_link_id
            kwargs['public_file_org_link'] = \
                public_file_org_link
            return self.call_with_http_info(**kwargs)

        if self.replace_public_file_org_link is None:
            self.replace_public_file_org_link = _Endpoint(
                settings={
                    'response_type': (PublicFileOrgLink,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/public_file_org_links/{public_file_org_link_id}',
                    'operation_id': 'replace_public_file_org_link',
                    'http_method': 'PUT',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'public_file_org_link_id',
                        'public_file_org_link',
                        'link_org_id',
                        'org_id',
                    ],
                    'required': [
                        'public_file_org_link_id',
                        'public_file_org_link',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'public_file_org_link_id':
                            (str,),
                        'public_file_org_link':
                            (PublicFileOrgLink,),
                        'link_org_id':
                            (str,),
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'public_file_org_link_id': 'public_file_org_link_id',
                        'link_org_id': 'link_org_id',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'public_file_org_link_id': 'path',
                        'public_file_org_link': 'body',
                        'link_org_id': 'query',
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__replace_public_file_org_link
            )

        def __reupload_file(
            self,
            file_id,
            org_id,
            file_zip,
            **kwargs
        ):
            """Upload a new version of a file  # noqa: E501

            Replace a file entirely by uploading new contents  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.reupload_file(file_id, org_id, file_zip, async_req=True)
            >>> result = thread.get()

            Args:
                file_id (str): file_id path
                org_id (str): Unique identifier
                file_zip (file_type): The contents of the file in binary format

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                FileSummary
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['file_id'] = \
                file_id
            kwargs['org_id'] = \
                org_id
            kwargs['file_zip'] = \
                file_zip
            return self.call_with_http_info(**kwargs)

        if self.reupload_file is None:
            self.reupload_file = _Endpoint(
                settings={
                    'response_type': (FileSummary,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/files/{file_id}/upload',
                    'operation_id': 'reupload_file',
                    'http_method': 'PUT',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'file_id',
                        'org_id',
                        'file_zip',
                    ],
                    'required': [
                        'file_id',
                        'org_id',
                        'file_zip',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'file_id':
                            (str,),
                        'org_id':
                            (str,),
                        'file_zip':
                            (file_type,),
                    },
                    'attribute_map': {
                        'file_id': 'file_id',
                        'org_id': 'org_id',
                        'file_zip': 'file_zip',
                    },
                    'location_map': {
                        'file_id': 'path',
                        'org_id': 'form',
                        'file_zip': 'form',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'multipart/form-data'
                    ]
                },
                api_client=api_client,
                callable=__reupload_file
            )

    add_file = None 
    create_file_association = None 
    create_file_association_clear_task = None 
    create_file_template = None 
    create_public_file_org_link = None 
    delete_file = None 
    delete_file_association = None 
    delete_file_template = None 
    delete_public_file_org_link = None 
    get_download = None 
    get_download_public = None 
    get_file = None 
    get_file_association = None 
    get_file_template = None 
    get_public_file_org_link = None 
    list_file_associations = None 
    list_file_templates = None 
    list_files = None 
    list_public_file_org_links = None 
    render_file_template = None 
    replace_file = None 
    replace_file_template = None 
    replace_public_file_org_link = None 
    reupload_file = None 
