"""
    Agilicus API

    Agilicus is API-first. Modern software is controlled by other software, is open, is available for you to use the way you want, securely, simply.  The OpenAPI Specification in YAML format is available on [www](https://www.agilicus.com/www/api/agilicus-openapi.yaml) for importing to other tools.  A rendered, online viewable and usable version of this specification is available at [api](https://www.agilicus.com/api). You may try the API inline directly in the web page. To do so, first obtain an Authentication Token (the simplest way is to install the Python SDK, and then run `agilicus-cli --issuer https://MYISSUER get-token`). You will need an org-id for most calls (and can obtain from `agilicus-cli --issuer https://MYISSUER list-orgs`). The `MYISSUER` will typically be `auth.MYDOMAIN`, and you will see it as you sign-in to the administrative UI.  This API releases on Bearer-Token authentication. To obtain a valid bearer token you will need to Authenticate to an Issuer with OpenID Connect (a superset of OAUTH2).  Your \"issuer\" will look like https://auth.MYDOMAIN. For example, when you signed-up, if you said \"use my own domain name\" and assigned a CNAME of cloud.example.com, then your issuer would be https://auth.cloud.example.com.  If you selected \"use an Agilicus supplied domain name\", your issuer would look like https://auth.myorg.agilicus.cloud.  For test purposes you can use our [Python SDK](https://pypi.org/project/agilicus/) and run `agilicus-cli --issuer https://auth.MYDOMAIN get-token`.  This API may be used in any language runtime that supports OpenAPI 3.0, or, you may use our [Python SDK](https://pypi.org/project/agilicus/), our [Typescript SDK](https://www.npmjs.com/package/@agilicus/angular), or our [Golang SDK](https://git.agilicus.com/pub/sdk-go).  100% of the activities in our system our API-driven, from our web-admin, through our progressive web applications, to all internals: there is nothing that is not accessible.  For more information, see [developer resources](https://www.agilicus.com/developer).   # noqa: E501

    The version of the OpenAPI document: 2025.10.14
    Contact: dev@agilicus.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from agilicus_api.api_client import ApiClient, Endpoint as _Endpoint
from agilicus_api.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from agilicus_api.model.list_combined_resource_rules_response import ListCombinedResourceRulesResponse
from agilicus_api.model.list_guid_metadata_response import ListGuidMetadataResponse
from agilicus_api.model.list_resource_groups_response import ListResourceGroupsResponse
from agilicus_api.model.list_resources_response import ListResourcesResponse
from agilicus_api.model.resource import Resource
from agilicus_api.model.resource_type_enum import ResourceTypeEnum
from agilicus_api.model.rule_scope_enum import RuleScopeEnum


class ResourcesApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        def __add_resource(
            self,
            resource,
            **kwargs
        ):
            """Add a resource  # noqa: E501

            Add a new resource of a specific type. This API is used specifically for resource_type=group, where there is no derived type resource for this object.   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.add_resource(resource, async_req=True)
            >>> result = thread.get()

            Args:
                resource (Resource):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                Resource
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['resource'] = \
                resource
            return self.call_with_http_info(**kwargs)

        if self.add_resource is None:
            self.add_resource = _Endpoint(
                settings={
                    'response_type': (Resource,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/resources',
                    'operation_id': 'add_resource',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'resource',
                    ],
                    'required': [
                        'resource',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'resource':
                            (Resource,),
                    },
                    'attribute_map': {
                    },
                    'location_map': {
                        'resource': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__add_resource
            )

        def __delete_resource(
            self,
            resource_id,
            **kwargs
        ):
            """Delete a resource  # noqa: E501

            Delete a resource  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_resource(resource_id, async_req=True)
            >>> result = thread.get()

            Args:
                resource_id (str): The id of the resource to access

            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['resource_id'] = \
                resource_id
            return self.call_with_http_info(**kwargs)

        if self.delete_resource is None:
            self.delete_resource = _Endpoint(
                settings={
                    'response_type': None,
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/resources/{resource_id}',
                    'operation_id': 'delete_resource',
                    'http_method': 'DELETE',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'resource_id',
                        'org_id',
                    ],
                    'required': [
                        'resource_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'resource_id':
                            (str,),
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'resource_id': 'resource_id',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'resource_id': 'path',
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__delete_resource
            )

        def __get_resource(
            self,
            resource_id,
            **kwargs
        ):
            """Get a resource  # noqa: E501

            Get a resource  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_resource(resource_id, async_req=True)
            >>> result = thread.get()

            Args:
                resource_id (str): The id of the resource to access

            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                expand_resource_members (bool): On resource requests, when True will populate member_resources with its full Resource object. . [optional] if omitted the server will use the default value of False
                include_legacy_icon_info (bool): Instructs resources to fetch legacy (e.g. non-ResourceConfig) icon info. . [optional] if omitted the server will use the default value of False
                resource_urls (bool): Retrieve associated resource urls in request. . [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                Resource
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['resource_id'] = \
                resource_id
            return self.call_with_http_info(**kwargs)

        if self.get_resource is None:
            self.get_resource = _Endpoint(
                settings={
                    'response_type': (Resource,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/resources/{resource_id}',
                    'operation_id': 'get_resource',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'resource_id',
                        'org_id',
                        'expand_resource_members',
                        'include_legacy_icon_info',
                        'resource_urls',
                    ],
                    'required': [
                        'resource_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'resource_id':
                            (str,),
                        'org_id':
                            (str,),
                        'expand_resource_members':
                            (bool,),
                        'include_legacy_icon_info':
                            (bool,),
                        'resource_urls':
                            (bool,),
                    },
                    'attribute_map': {
                        'resource_id': 'resource_id',
                        'org_id': 'org_id',
                        'expand_resource_members': 'expand_resource_members',
                        'include_legacy_icon_info': 'include_legacy_icon_info',
                        'resource_urls': 'resource_urls',
                    },
                    'location_map': {
                        'resource_id': 'path',
                        'org_id': 'query',
                        'expand_resource_members': 'query',
                        'include_legacy_icon_info': 'query',
                        'resource_urls': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__get_resource
            )

        def __list_combined_resource_rules(
            self,
            **kwargs
        ):
            """List rules combined by scope or role  # noqa: E501

            Retrieve all role_to_rule_entries for resources. If assigned is true, this will list all role_to_rule_entries for applications assigned to the given org_id   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_combined_resource_rules(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                scopes ([RuleScopeEnum]): The scopes of the rules to search for. Multiple values are ORed together.. [optional]
                resource_id (str): The id of the resource to query for. [optional]
                limit (int): limit the number of rows in the response. [optional] if omitted the server will use the default value of 500
                assigned (bool): Query for Applications assigned to the `org_id`. These are Applications with at least one Environment assigned to the `org_id`. . [optional]
                resource_type (ResourceTypeEnum): The type of resource to query for. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListCombinedResourceRulesResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        if self.list_combined_resource_rules is None:
            self.list_combined_resource_rules = _Endpoint(
                settings={
                    'response_type': (ListCombinedResourceRulesResponse,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/combined_resource_rules',
                    'operation_id': 'list_combined_resource_rules',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'org_id',
                        'scopes',
                        'resource_id',
                        'limit',
                        'assigned',
                        'resource_type',
                    ],
                    'required': [],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'limit',
                    ]
                },
                root_map={
                    'validations': {
                        ('limit',): {

                            'inclusive_maximum': 500,
                            'inclusive_minimum': 1,
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'org_id':
                            (str,),
                        'scopes':
                            ([RuleScopeEnum],),
                        'resource_id':
                            (str,),
                        'limit':
                            (int,),
                        'assigned':
                            (bool,),
                        'resource_type':
                            (ResourceTypeEnum,),
                    },
                    'attribute_map': {
                        'org_id': 'org_id',
                        'scopes': 'scopes',
                        'resource_id': 'resource_id',
                        'limit': 'limit',
                        'assigned': 'assigned',
                        'resource_type': 'resource_type',
                    },
                    'location_map': {
                        'org_id': 'query',
                        'scopes': 'query',
                        'resource_id': 'query',
                        'limit': 'query',
                        'assigned': 'query',
                        'resource_type': 'query',
                    },
                    'collection_format_map': {
                        'scopes': 'multi',
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__list_combined_resource_rules
            )

        def __list_resource_groups(
            self,
            **kwargs
        ):
            """List resource groups and their children.  # noqa: E501

            List all resource groups and their children. This is an optimized query that minimizes the returned result to guids only.   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_resource_groups(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                org_ids ([str]): The list of org ids to search for. Each org will be searched for independently.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListResourceGroupsResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        if self.list_resource_groups is None:
            self.list_resource_groups = _Endpoint(
                settings={
                    'response_type': (ListResourceGroupsResponse,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/resources/groups',
                    'operation_id': 'list_resource_groups',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'org_ids',
                    ],
                    'required': [],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'org_ids':
                            ([str],),
                    },
                    'attribute_map': {
                        'org_ids': 'org_ids',
                    },
                    'location_map': {
                        'org_ids': 'query',
                    },
                    'collection_format_map': {
                        'org_ids': 'multi',
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__list_resource_groups
            )

        def __list_resource_guid_mapping(
            self,
            **kwargs
        ):
            """Get all resource guids and a unique name mapping  # noqa: E501

            Get all resource guids and a unique name mapping  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_resource_guid_mapping(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                resource_id (str): The id of the resource to query for. [optional]
                limit (int): limit the number of rows in the response. [optional] if omitted the server will use the default value of 500
                previous_guid (str): Pagination based query with the guid as the key. To get the initial entries supply an empty string.. [optional]
                updated_since (datetime): query since updated. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListGuidMetadataResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        if self.list_resource_guid_mapping is None:
            self.list_resource_guid_mapping = _Endpoint(
                settings={
                    'response_type': (ListGuidMetadataResponse,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/resources/guids',
                    'operation_id': 'list_resource_guid_mapping',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'org_id',
                        'resource_id',
                        'limit',
                        'previous_guid',
                        'updated_since',
                    ],
                    'required': [],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'limit',
                    ]
                },
                root_map={
                    'validations': {
                        ('limit',): {

                            'inclusive_maximum': 500,
                            'inclusive_minimum': 1,
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'org_id':
                            (str,),
                        'resource_id':
                            (str,),
                        'limit':
                            (int,),
                        'previous_guid':
                            (str,),
                        'updated_since':
                            (datetime,),
                    },
                    'attribute_map': {
                        'org_id': 'org_id',
                        'resource_id': 'resource_id',
                        'limit': 'limit',
                        'previous_guid': 'previous_guid',
                        'updated_since': 'updated_since',
                    },
                    'location_map': {
                        'org_id': 'query',
                        'resource_id': 'query',
                        'limit': 'query',
                        'previous_guid': 'query',
                        'updated_since': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__list_resource_guid_mapping
            )

        def __list_resources(
            self,
            **kwargs
        ):
            """List all Resources  # noqa: E501

            List all Resources matching the provided query parameters. Perform keyset pagination by setting the page_at_id parameter to the id for the next page to fetch. Set it to `\"\"` to start from the beginning.   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_resources(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                limit (int): limit the number of rows in the response. [optional] if omitted the server will use the default value of 500
                org_id (str): Organisation Unique identifier. [optional]
                resource_type (ResourceTypeEnum): The type of resource to query for. [optional]
                exclude_resource_type ([str]): Resource types to exclude. [optional]
                name_slug (str): The slug of the resource to query for. [optional]
                name (str): The name of the resource to query for. [optional]
                resource_id (str): The id of the resource to query for. [optional]
                page_at_id (str): Pagination based query with the id as the key. To get the initial entries supply an empty string. On subsequent requests, supply the `page_at_id` field from the list response. . [optional]
                org_ids ([str]): The list of org ids to search for. Each org will be searched for independently.. [optional]
                expand_resource_members (bool): On resource requests, when True will populate member_resources with its full Resource object. . [optional] if omitted the server will use the default value of False
                include_legacy_icon_info (bool): Instructs resources to fetch legacy (e.g. non-ResourceConfig) icon info. . [optional] if omitted the server will use the default value of False
                resource_urls (bool): Retrieve associated resource urls in request. . [optional]
                show_stats (bool): Whether the return value should include the stats for included objects. If false the query may run faster but will not include statistics. If not present, defaults to false. . [optional] if omitted the server will use the default value of False
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListResourcesResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        if self.list_resources is None:
            self.list_resources = _Endpoint(
                settings={
                    'response_type': (ListResourcesResponse,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/resources',
                    'operation_id': 'list_resources',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'limit',
                        'org_id',
                        'resource_type',
                        'exclude_resource_type',
                        'name_slug',
                        'name',
                        'resource_id',
                        'page_at_id',
                        'org_ids',
                        'expand_resource_members',
                        'include_legacy_icon_info',
                        'resource_urls',
                        'show_stats',
                    ],
                    'required': [],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'limit',
                        'name',
                    ]
                },
                root_map={
                    'validations': {
                        ('limit',): {

                            'inclusive_maximum': 500,
                            'inclusive_minimum': 1,
                        },
                        ('name',): {
                            'max_length': 100,
                            'regex': {
                                'pattern': r'^[a-zA-Z0-9-_.:]+$',  # noqa: E501
                            },
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'limit':
                            (int,),
                        'org_id':
                            (str,),
                        'resource_type':
                            (ResourceTypeEnum,),
                        'exclude_resource_type':
                            ([str],),
                        'name_slug':
                            (str,),
                        'name':
                            (str,),
                        'resource_id':
                            (str,),
                        'page_at_id':
                            (str,),
                        'org_ids':
                            ([str],),
                        'expand_resource_members':
                            (bool,),
                        'include_legacy_icon_info':
                            (bool,),
                        'resource_urls':
                            (bool,),
                        'show_stats':
                            (bool,),
                    },
                    'attribute_map': {
                        'limit': 'limit',
                        'org_id': 'org_id',
                        'resource_type': 'resource_type',
                        'exclude_resource_type': 'exclude_resource_type',
                        'name_slug': 'name_slug',
                        'name': 'name',
                        'resource_id': 'resource_id',
                        'page_at_id': 'page_at_id',
                        'org_ids': 'org_ids',
                        'expand_resource_members': 'expand_resource_members',
                        'include_legacy_icon_info': 'include_legacy_icon_info',
                        'resource_urls': 'resource_urls',
                        'show_stats': 'show_stats',
                    },
                    'location_map': {
                        'limit': 'query',
                        'org_id': 'query',
                        'resource_type': 'query',
                        'exclude_resource_type': 'query',
                        'name_slug': 'query',
                        'name': 'query',
                        'resource_id': 'query',
                        'page_at_id': 'query',
                        'org_ids': 'query',
                        'expand_resource_members': 'query',
                        'include_legacy_icon_info': 'query',
                        'resource_urls': 'query',
                        'show_stats': 'query',
                    },
                    'collection_format_map': {
                        'exclude_resource_type': 'multi',
                        'org_ids': 'multi',
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__list_resources
            )

        def __reconcile_default_policy(
            self,
            resource_id,
            **kwargs
        ):
            """Reconciles the default policy for a resource  # noqa: E501

            Reconciles the default policy for a resource  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.reconcile_default_policy(resource_id, async_req=True)
            >>> result = thread.get()

            Args:
                resource_id (str): The id of the resource to access

            Keyword Args:
                resource (Resource): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                Resource
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['resource_id'] = \
                resource_id
            return self.call_with_http_info(**kwargs)

        if self.reconcile_default_policy is None:
            self.reconcile_default_policy = _Endpoint(
                settings={
                    'response_type': (Resource,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/resources/{resource_id}/reconcile_default_policy',
                    'operation_id': 'reconcile_default_policy',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'resource_id',
                        'resource',
                    ],
                    'required': [
                        'resource_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'resource_id':
                            (str,),
                        'resource':
                            (Resource,),
                    },
                    'attribute_map': {
                        'resource_id': 'resource_id',
                    },
                    'location_map': {
                        'resource_id': 'path',
                        'resource': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__reconcile_default_policy
            )

        def __replace_resource(
            self,
            resource_id,
            **kwargs
        ):
            """update a resource  # noqa: E501

            update a resource  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.replace_resource(resource_id, async_req=True)
            >>> result = thread.get()

            Args:
                resource_id (str): The id of the resource to access

            Keyword Args:
                resource (Resource): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                Resource
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['resource_id'] = \
                resource_id
            return self.call_with_http_info(**kwargs)

        if self.replace_resource is None:
            self.replace_resource = _Endpoint(
                settings={
                    'response_type': (Resource,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/resources/{resource_id}',
                    'operation_id': 'replace_resource',
                    'http_method': 'PUT',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'resource_id',
                        'resource',
                    ],
                    'required': [
                        'resource_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'resource_id':
                            (str,),
                        'resource':
                            (Resource,),
                    },
                    'attribute_map': {
                        'resource_id': 'resource_id',
                    },
                    'location_map': {
                        'resource_id': 'path',
                        'resource': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__replace_resource
            )

    add_resource = None 
    delete_resource = None 
    get_resource = None 
    list_combined_resource_rules = None 
    list_resource_groups = None 
    list_resource_guid_mapping = None 
    list_resources = None 
    reconcile_default_policy = None 
    replace_resource = None 
