"""
    Agilicus API

    Agilicus is API-first. Modern software is controlled by other software, is open, is available for you to use the way you want, securely, simply.  The OpenAPI Specification in YAML format is available on [www](https://www.agilicus.com/www/api/agilicus-openapi.yaml) for importing to other tools.  A rendered, online viewable and usable version of this specification is available at [api](https://www.agilicus.com/api). You may try the API inline directly in the web page. To do so, first obtain an Authentication Token (the simplest way is to install the Python SDK, and then run `agilicus-cli --issuer https://MYISSUER get-token`). You will need an org-id for most calls (and can obtain from `agilicus-cli --issuer https://MYISSUER list-orgs`). The `MYISSUER` will typically be `auth.MYDOMAIN`, and you will see it as you sign-in to the administrative UI.  This API releases on Bearer-Token authentication. To obtain a valid bearer token you will need to Authenticate to an Issuer with OpenID Connect (a superset of OAUTH2).  Your \"issuer\" will look like https://auth.MYDOMAIN. For example, when you signed-up, if you said \"use my own domain name\" and assigned a CNAME of cloud.example.com, then your issuer would be https://auth.cloud.example.com.  If you selected \"use an Agilicus supplied domain name\", your issuer would look like https://auth.myorg.agilicus.cloud.  For test purposes you can use our [Python SDK](https://pypi.org/project/agilicus/) and run `agilicus-cli --issuer https://auth.MYDOMAIN get-token`.  This API may be used in any language runtime that supports OpenAPI 3.0, or, you may use our [Python SDK](https://pypi.org/project/agilicus/), our [Typescript SDK](https://www.npmjs.com/package/@agilicus/angular), or our [Golang SDK](https://git.agilicus.com/pub/sdk-go).  100% of the activities in our system our API-driven, from our web-admin, through our progressive web applications, to all internals: there is nothing that is not accessible.  For more information, see [developer resources](https://www.agilicus.com/developer).   # noqa: E501

    The version of the OpenAPI document: 2025.10.14
    Contact: dev@agilicus.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from agilicus_api.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
)
from ..model_utils import OpenApiModel
from agilicus_api.exceptions import ApiAttributeError



class TrustedCertificateStatus(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
    }

    validations = {
    }

    @property
    def not_before(self):
       return self.get("not_before")

    @not_before.setter
    def not_before(self, new_value):
       self.not_before = new_value

    @property
    def not_after(self):
       return self.get("not_after")

    @not_after.setter
    def not_after(self, new_value):
       self.not_after = new_value

    @property
    def serial_number(self):
       return self.get("serial_number")

    @serial_number.setter
    def serial_number(self, new_value):
       self.serial_number = new_value

    @property
    def issuer(self):
       return self.get("issuer")

    @issuer.setter
    def issuer(self, new_value):
       self.issuer = new_value

    @property
    def subject(self):
       return self.get("subject")

    @subject.setter
    def subject(self, new_value):
       self.subject = new_value

    @property
    def subject_sha1(self):
       return self.get("subject_sha1")

    @subject_sha1.setter
    def subject_sha1(self, new_value):
       self.subject_sha1 = new_value

    @property
    def subject_sha256(self):
       return self.get("subject_sha256")

    @subject_sha256.setter
    def subject_sha256(self, new_value):
       self.subject_sha256 = new_value

    @property
    def public_key_sha1(self):
       return self.get("public_key_sha1")

    @public_key_sha1.setter
    def public_key_sha1(self, new_value):
       self.public_key_sha1 = new_value

    @property
    def public_key_sha256(self):
       return self.get("public_key_sha256")

    @public_key_sha256.setter
    def public_key_sha256(self, new_value):
       self.public_key_sha256 = new_value

    @property
    def skid(self):
       return self.get("skid")

    @skid.setter
    def skid(self, new_value):
       self.skid = new_value

    @property
    def akid(self):
       return self.get("akid")

    @akid.setter
    def akid(self, new_value):
       self.akid = new_value

    @property
    def ca(self):
       return self.get("ca")

    @ca.setter
    def ca(self, new_value):
       self.ca = new_value

    @property
    def key_usage_extension(self):
       return self.get("key_usage_extension")

    @key_usage_extension.setter
    def key_usage_extension(self, new_value):
       self.key_usage_extension = new_value

    @property
    def digital_signature(self):
       return self.get("digital_signature")

    @digital_signature.setter
    def digital_signature(self, new_value):
       self.digital_signature = new_value

    @property
    def content_commitment(self):
       return self.get("content_commitment")

    @content_commitment.setter
    def content_commitment(self, new_value):
       self.content_commitment = new_value

    @property
    def key_encipherment(self):
       return self.get("key_encipherment")

    @key_encipherment.setter
    def key_encipherment(self, new_value):
       self.key_encipherment = new_value

    @property
    def data_encipherment(self):
       return self.get("data_encipherment")

    @data_encipherment.setter
    def data_encipherment(self, new_value):
       self.data_encipherment = new_value

    @property
    def key_agreement(self):
       return self.get("key_agreement")

    @key_agreement.setter
    def key_agreement(self, new_value):
       self.key_agreement = new_value

    @property
    def key_cert_sign(self):
       return self.get("key_cert_sign")

    @key_cert_sign.setter
    def key_cert_sign(self, new_value):
       self.key_cert_sign = new_value

    @property
    def crl_sign(self):
       return self.get("crl_sign")

    @crl_sign.setter
    def crl_sign(self, new_value):
       self.crl_sign = new_value

    @property
    def encipher_only(self):
       return self.get("encipher_only")

    @encipher_only.setter
    def encipher_only(self, new_value):
       self.encipher_only = new_value

    @property
    def decipher_only(self):
       return self.get("decipher_only")

    @decipher_only.setter
    def decipher_only(self, new_value):
       self.decipher_only = new_value

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        return {
            'not_before': (datetime,),  # noqa: E501
            'not_after': (datetime,),  # noqa: E501
            'serial_number': (str,),  # noqa: E501
            'issuer': (str,),  # noqa: E501
            'subject': (str,),  # noqa: E501
            'subject_sha1': (str,),  # noqa: E501
            'subject_sha256': (str,),  # noqa: E501
            'public_key_sha1': (str,),  # noqa: E501
            'public_key_sha256': (str,),  # noqa: E501
            'skid': (str,),  # noqa: E501
            'akid': (str,),  # noqa: E501
            'ca': (bool,),  # noqa: E501
            'key_usage_extension': (str,),  # noqa: E501
            'digital_signature': (bool,),  # noqa: E501
            'content_commitment': (bool,),  # noqa: E501
            'key_encipherment': (bool,),  # noqa: E501
            'data_encipherment': (bool,),  # noqa: E501
            'key_agreement': (bool,),  # noqa: E501
            'key_cert_sign': (bool,),  # noqa: E501
            'crl_sign': (bool,),  # noqa: E501
            'encipher_only': (bool,),  # noqa: E501
            'decipher_only': (bool,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None



    attribute_map = {
        'not_before': 'not_before',  # noqa: E501
        'not_after': 'not_after',  # noqa: E501
        'serial_number': 'serial_number',  # noqa: E501
        'issuer': 'issuer',  # noqa: E501
        'subject': 'subject',  # noqa: E501
        'subject_sha1': 'subject_sha1',  # noqa: E501
        'subject_sha256': 'subject_sha256',  # noqa: E501
        'public_key_sha1': 'public_key_sha1',  # noqa: E501
        'public_key_sha256': 'public_key_sha256',  # noqa: E501
        'skid': 'skid',  # noqa: E501
        'akid': 'akid',  # noqa: E501
        'ca': 'ca',  # noqa: E501
        'key_usage_extension': 'key_usage_extension',  # noqa: E501
        'digital_signature': 'digital_signature',  # noqa: E501
        'content_commitment': 'content_commitment',  # noqa: E501
        'key_encipherment': 'key_encipherment',  # noqa: E501
        'data_encipherment': 'data_encipherment',  # noqa: E501
        'key_agreement': 'key_agreement',  # noqa: E501
        'key_cert_sign': 'key_cert_sign',  # noqa: E501
        'crl_sign': 'crl_sign',  # noqa: E501
        'encipher_only': 'encipher_only',  # noqa: E501
        'decipher_only': 'decipher_only',  # noqa: E501
    }

    read_only_vars = {
        'not_before',  # noqa: E501
        'not_after',  # noqa: E501
        'serial_number',  # noqa: E501
        'issuer',  # noqa: E501
        'subject',  # noqa: E501
        'subject_sha1',  # noqa: E501
        'subject_sha256',  # noqa: E501
        'public_key_sha1',  # noqa: E501
        'public_key_sha256',  # noqa: E501
        'skid',  # noqa: E501
        'akid',  # noqa: E501
        'ca',  # noqa: E501
        'key_usage_extension',  # noqa: E501
        'digital_signature',  # noqa: E501
        'content_commitment',  # noqa: E501
        'key_encipherment',  # noqa: E501
        'data_encipherment',  # noqa: E501
        'key_agreement',  # noqa: E501
        'key_cert_sign',  # noqa: E501
        'crl_sign',  # noqa: E501
        'encipher_only',  # noqa: E501
        'decipher_only',  # noqa: E501
    }

    _composed_schemas = {}

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, *args, **kwargs):  # noqa: E501
        """TrustedCertificateStatus - a model defined in OpenAPI

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            not_before (datetime): date/time for which certificate is valid. [optional]  # noqa: E501
            not_after (datetime): date/time of certificate expiry. [optional]  # noqa: E501
            serial_number (str): the certificate serial number. [optional]  # noqa: E501
            issuer (str): the certificate issuer. [optional]  # noqa: E501
            subject (str): certificate subject. [optional]  # noqa: E501
            subject_sha1 (str): certificate subject sha128 hash. [optional]  # noqa: E501
            subject_sha256 (str): certificate subject sha256 hash. [optional]  # noqa: E501
            public_key_sha1 (str): public key DER sha128 hash. [optional]  # noqa: E501
            public_key_sha256 (str): public key DER sha256 hash. [optional]  # noqa: E501
            skid (str): The Subject Key Identifier. [optional]  # noqa: E501
            akid (str): The Authority Key Identifier. [optional]  # noqa: E501
            ca (bool): true if the certificate is a certificate authority, otherwise false. [optional]  # noqa: E501
            key_usage_extension (str): the certificate key usage extension. [optional]  # noqa: E501
            digital_signature (bool): This purpose is set to true when the subject public key is used for verifying digital signatures, other than signatures on certificates (key_cert_sign) and CRLs (crl_sign). . [optional]  # noqa: E501
            content_commitment (bool): This purpose is set to true when the subject public key is used for verifying digital signatures, other than signatures on certificates (key_cert_sign) and CRLs (crl_sign). It is used to provide a non-repudiation service that protects against the signing entity falsely denying some action. In the case of later conflict, a reliable third party may determine the authenticity of the signed data. This was called non_repudiation in older revisions of the X.509 specification. . [optional]  # noqa: E501
            key_encipherment (bool): This purpose is set to true when the subject public key is used for enciphering private or secret keys. . [optional]  # noqa: E501
            data_encipherment (bool): This purpose is set to true when the subject public key is used for directly enciphering raw user data without the use of an intermediate symmetric cipher. . [optional]  # noqa: E501
            key_agreement (bool): This purpose is set to true when the subject public key is used for key agreement. For example, when a Diffie-Hellman key is to be used for key management, then this purpose is set to true. . [optional]  # noqa: E501
            key_cert_sign (bool): This purpose is set to true when the subject public key is used for verifying signatures on public key certificates. If this purpose is set to true then ca must be true in the BasicConstraints extension. . [optional]  # noqa: E501
            crl_sign (bool): This purpose is set to true when the subject public key is used for verifying signatures on certificate revocation lists. . [optional]  # noqa: E501
            encipher_only (bool): When this purposes is set to true and the key_agreement purpose is also set, the subject public key may be used only for enciphering data while performing key agreement. . [optional]  # noqa: E501
            decipher_only (bool): When this purposes is set to true and the key_agreement purpose is also set, the subject public key may be used only for deciphering data while performing key agreement. . [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
        return self

    def __python_set(val):
        return set(val)
 
    required_properties = __python_set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, *args, **kwargs):  # noqa: E501
        """TrustedCertificateStatus - a model defined in OpenAPI

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            not_before (datetime): date/time for which certificate is valid. [optional]  # noqa: E501
            not_after (datetime): date/time of certificate expiry. [optional]  # noqa: E501
            serial_number (str): the certificate serial number. [optional]  # noqa: E501
            issuer (str): the certificate issuer. [optional]  # noqa: E501
            subject (str): certificate subject. [optional]  # noqa: E501
            subject_sha1 (str): certificate subject sha128 hash. [optional]  # noqa: E501
            subject_sha256 (str): certificate subject sha256 hash. [optional]  # noqa: E501
            public_key_sha1 (str): public key DER sha128 hash. [optional]  # noqa: E501
            public_key_sha256 (str): public key DER sha256 hash. [optional]  # noqa: E501
            skid (str): The Subject Key Identifier. [optional]  # noqa: E501
            akid (str): The Authority Key Identifier. [optional]  # noqa: E501
            ca (bool): true if the certificate is a certificate authority, otherwise false. [optional]  # noqa: E501
            key_usage_extension (str): the certificate key usage extension. [optional]  # noqa: E501
            digital_signature (bool): This purpose is set to true when the subject public key is used for verifying digital signatures, other than signatures on certificates (key_cert_sign) and CRLs (crl_sign). . [optional]  # noqa: E501
            content_commitment (bool): This purpose is set to true when the subject public key is used for verifying digital signatures, other than signatures on certificates (key_cert_sign) and CRLs (crl_sign). It is used to provide a non-repudiation service that protects against the signing entity falsely denying some action. In the case of later conflict, a reliable third party may determine the authenticity of the signed data. This was called non_repudiation in older revisions of the X.509 specification. . [optional]  # noqa: E501
            key_encipherment (bool): This purpose is set to true when the subject public key is used for enciphering private or secret keys. . [optional]  # noqa: E501
            data_encipherment (bool): This purpose is set to true when the subject public key is used for directly enciphering raw user data without the use of an intermediate symmetric cipher. . [optional]  # noqa: E501
            key_agreement (bool): This purpose is set to true when the subject public key is used for key agreement. For example, when a Diffie-Hellman key is to be used for key management, then this purpose is set to true. . [optional]  # noqa: E501
            key_cert_sign (bool): This purpose is set to true when the subject public key is used for verifying signatures on public key certificates. If this purpose is set to true then ca must be true in the BasicConstraints extension. . [optional]  # noqa: E501
            crl_sign (bool): This purpose is set to true when the subject public key is used for verifying signatures on certificate revocation lists. . [optional]  # noqa: E501
            encipher_only (bool): When this purposes is set to true and the key_agreement purpose is also set, the subject public key may be used only for enciphering data while performing key agreement. . [optional]  # noqa: E501
            decipher_only (bool): When this purposes is set to true and the key_agreement purpose is also set, the subject public key may be used only for deciphering data while performing key agreement. . [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
            if var_name in self.read_only_vars:
                raise ApiAttributeError(f"`{var_name}` is a read-only attribute. Use `from_openapi_data` to instantiate "
                                     f"class with read only attributes.")

