# pulp_deb-client
Fetch, Upload, Organize, and Distribute Software Packages

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: v3
- Package version: 3.7.0
- Generator version: 7.10.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen
For more information, please visit [https://pulpproject.org](https://pulpproject.org)

## Requirements.

Python 3.8+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import pulpcore.client.pulp_deb
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import pulpcore.client.pulp_deb
```

### Tests

Execute `pytest` to run the tests.

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import pulpcore.client.pulp_deb
from pulpcore.client.pulp_deb.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost:24817
# See configuration.py for a list of all supported configuration parameters.
configuration = pulpcore.client.pulp_deb.Configuration(
    host = "http://localhost:24817"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure HTTP basic authorization: basicAuth
configuration = pulpcore.client.pulp_deb.Configuration(
    username = os.environ["USERNAME"],
    password = os.environ["PASSWORD"]
)

# Configure API key authorization: cookieAuth
configuration.api_key['cookieAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['cookieAuth'] = 'Bearer'


# Enter a context with an instance of the API client
with pulpcore.client.pulp_deb.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = pulpcore.client.pulp_deb.ContentGenericContentsApi(api_client)
    relative_path = 'relative_path_example' # str | Path where the artifact is located relative to distributions base_path
    x_task_diagnostics = ['x_task_diagnostics_example'] # List[str] | List of profilers to use on tasks. (optional)
    repository = 'repository_example' # str | A URI of a repository the new content unit should be associated with. (optional)
    pulp_labels = None # Dict[str, Optional[str]] | A dictionary of arbitrary key/value pairs used to describe a specific Content instance. (optional)
    artifact = 'artifact_example' # str | Artifact file representing the physical content (optional)
    file = None # bytearray | An uploaded file that may be turned into the content unit. (optional)
    upload = 'upload_example' # str | An uncommitted upload that may be turned into the content unit. (optional)
    file_url = 'file_url_example' # str | A url that Pulp can download and turn into the content unit. (optional)

    try:
        # Create a generic content
        api_response = api_instance.create(relative_path, x_task_diagnostics=x_task_diagnostics, repository=repository, pulp_labels=pulp_labels, artifact=artifact, file=file, upload=upload, file_url=file_url)
        print("The response of ContentGenericContentsApi->create:\n")
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling ContentGenericContentsApi->create: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *http://localhost:24817*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*ContentGenericContentsApi* | [**create**](docs/ContentGenericContentsApi.md#create) | **POST** /pulp/api/v3/content/deb/generic_contents/ | Create a generic content
*ContentGenericContentsApi* | [**list**](docs/ContentGenericContentsApi.md#list) | **GET** /pulp/api/v3/content/deb/generic_contents/ | List generic contents
*ContentGenericContentsApi* | [**read**](docs/ContentGenericContentsApi.md#read) | **GET** {deb_generic_content_href} | Inspect a generic content
*ContentGenericContentsApi* | [**set_label**](docs/ContentGenericContentsApi.md#set_label) | **POST** {deb_generic_content_href}set_label/ | Set a label
*ContentGenericContentsApi* | [**unset_label**](docs/ContentGenericContentsApi.md#unset_label) | **POST** {deb_generic_content_href}unset_label/ | Unset a label
*ContentInstallerFileIndicesApi* | [**create**](docs/ContentInstallerFileIndicesApi.md#create) | **POST** /pulp/api/v3/content/deb/installer_file_indices/ | Create an installer file index
*ContentInstallerFileIndicesApi* | [**list**](docs/ContentInstallerFileIndicesApi.md#list) | **GET** /pulp/api/v3/content/deb/installer_file_indices/ | List InstallerFileIndices
*ContentInstallerFileIndicesApi* | [**read**](docs/ContentInstallerFileIndicesApi.md#read) | **GET** {deb_installer_file_index_href} | Inspect an installer file index
*ContentInstallerFileIndicesApi* | [**set_label**](docs/ContentInstallerFileIndicesApi.md#set_label) | **POST** {deb_installer_file_index_href}set_label/ | Set a label
*ContentInstallerFileIndicesApi* | [**unset_label**](docs/ContentInstallerFileIndicesApi.md#unset_label) | **POST** {deb_installer_file_index_href}unset_label/ | Unset a label
*ContentInstallerPackagesApi* | [**create**](docs/ContentInstallerPackagesApi.md#create) | **POST** /pulp/api/v3/content/deb/installer_packages/ | Create an installer package
*ContentInstallerPackagesApi* | [**list**](docs/ContentInstallerPackagesApi.md#list) | **GET** /pulp/api/v3/content/deb/installer_packages/ | List installer packages
*ContentInstallerPackagesApi* | [**read**](docs/ContentInstallerPackagesApi.md#read) | **GET** {deb_installer_package_href} | Inspect an installer package
*ContentInstallerPackagesApi* | [**set_label**](docs/ContentInstallerPackagesApi.md#set_label) | **POST** {deb_installer_package_href}set_label/ | Set a label
*ContentInstallerPackagesApi* | [**unset_label**](docs/ContentInstallerPackagesApi.md#unset_label) | **POST** {deb_installer_package_href}unset_label/ | Unset a label
*ContentPackageIndicesApi* | [**create**](docs/ContentPackageIndicesApi.md#create) | **POST** /pulp/api/v3/content/deb/package_indices/ | Create a package index
*ContentPackageIndicesApi* | [**list**](docs/ContentPackageIndicesApi.md#list) | **GET** /pulp/api/v3/content/deb/package_indices/ | List PackageIndices
*ContentPackageIndicesApi* | [**read**](docs/ContentPackageIndicesApi.md#read) | **GET** {deb_package_index_href} | Inspect a package index
*ContentPackageIndicesApi* | [**set_label**](docs/ContentPackageIndicesApi.md#set_label) | **POST** {deb_package_index_href}set_label/ | Set a label
*ContentPackageIndicesApi* | [**unset_label**](docs/ContentPackageIndicesApi.md#unset_label) | **POST** {deb_package_index_href}unset_label/ | Unset a label
*ContentPackageReleaseComponentsApi* | [**create**](docs/ContentPackageReleaseComponentsApi.md#create) | **POST** /pulp/api/v3/content/deb/package_release_components/ | Create a package release component
*ContentPackageReleaseComponentsApi* | [**list**](docs/ContentPackageReleaseComponentsApi.md#list) | **GET** /pulp/api/v3/content/deb/package_release_components/ | List package release components
*ContentPackageReleaseComponentsApi* | [**read**](docs/ContentPackageReleaseComponentsApi.md#read) | **GET** {deb_package_release_component_href} | Inspect a package release component
*ContentPackageReleaseComponentsApi* | [**set_label**](docs/ContentPackageReleaseComponentsApi.md#set_label) | **POST** {deb_package_release_component_href}set_label/ | Set a label
*ContentPackageReleaseComponentsApi* | [**unset_label**](docs/ContentPackageReleaseComponentsApi.md#unset_label) | **POST** {deb_package_release_component_href}unset_label/ | Unset a label
*ContentPackagesApi* | [**create**](docs/ContentPackagesApi.md#create) | **POST** /pulp/api/v3/content/deb/packages/ | Create a package
*ContentPackagesApi* | [**list**](docs/ContentPackagesApi.md#list) | **GET** /pulp/api/v3/content/deb/packages/ | List packages
*ContentPackagesApi* | [**read**](docs/ContentPackagesApi.md#read) | **GET** {deb_package_href} | Inspect a package
*ContentPackagesApi* | [**set_label**](docs/ContentPackagesApi.md#set_label) | **POST** {deb_package_href}set_label/ | Set a label
*ContentPackagesApi* | [**unset_label**](docs/ContentPackagesApi.md#unset_label) | **POST** {deb_package_href}unset_label/ | Unset a label
*ContentReleaseArchitecturesApi* | [**create**](docs/ContentReleaseArchitecturesApi.md#create) | **POST** /pulp/api/v3/content/deb/release_architectures/ | Create a release architecture
*ContentReleaseArchitecturesApi* | [**list**](docs/ContentReleaseArchitecturesApi.md#list) | **GET** /pulp/api/v3/content/deb/release_architectures/ | List release architectures
*ContentReleaseArchitecturesApi* | [**read**](docs/ContentReleaseArchitecturesApi.md#read) | **GET** {deb_release_architecture_href} | Inspect a release architecture
*ContentReleaseArchitecturesApi* | [**set_label**](docs/ContentReleaseArchitecturesApi.md#set_label) | **POST** {deb_release_architecture_href}set_label/ | Set a label
*ContentReleaseArchitecturesApi* | [**unset_label**](docs/ContentReleaseArchitecturesApi.md#unset_label) | **POST** {deb_release_architecture_href}unset_label/ | Unset a label
*ContentReleaseComponentsApi* | [**create**](docs/ContentReleaseComponentsApi.md#create) | **POST** /pulp/api/v3/content/deb/release_components/ | Create a release component
*ContentReleaseComponentsApi* | [**list**](docs/ContentReleaseComponentsApi.md#list) | **GET** /pulp/api/v3/content/deb/release_components/ | List release components
*ContentReleaseComponentsApi* | [**read**](docs/ContentReleaseComponentsApi.md#read) | **GET** {deb_release_component_href} | Inspect a release component
*ContentReleaseComponentsApi* | [**set_label**](docs/ContentReleaseComponentsApi.md#set_label) | **POST** {deb_release_component_href}set_label/ | Set a label
*ContentReleaseComponentsApi* | [**unset_label**](docs/ContentReleaseComponentsApi.md#unset_label) | **POST** {deb_release_component_href}unset_label/ | Unset a label
*ContentReleaseFilesApi* | [**create**](docs/ContentReleaseFilesApi.md#create) | **POST** /pulp/api/v3/content/deb/release_files/ | Create a release file
*ContentReleaseFilesApi* | [**list**](docs/ContentReleaseFilesApi.md#list) | **GET** /pulp/api/v3/content/deb/release_files/ | List release files
*ContentReleaseFilesApi* | [**read**](docs/ContentReleaseFilesApi.md#read) | **GET** {deb_release_file_href} | Inspect a release file
*ContentReleaseFilesApi* | [**set_label**](docs/ContentReleaseFilesApi.md#set_label) | **POST** {deb_release_file_href}set_label/ | Set a label
*ContentReleaseFilesApi* | [**unset_label**](docs/ContentReleaseFilesApi.md#unset_label) | **POST** {deb_release_file_href}unset_label/ | Unset a label
*ContentReleasesApi* | [**create**](docs/ContentReleasesApi.md#create) | **POST** /pulp/api/v3/content/deb/releases/ | Create a release
*ContentReleasesApi* | [**list**](docs/ContentReleasesApi.md#list) | **GET** /pulp/api/v3/content/deb/releases/ | List releases
*ContentReleasesApi* | [**read**](docs/ContentReleasesApi.md#read) | **GET** {deb_release_href} | Inspect a release
*ContentReleasesApi* | [**set_label**](docs/ContentReleasesApi.md#set_label) | **POST** {deb_release_href}set_label/ | Set a label
*ContentReleasesApi* | [**unset_label**](docs/ContentReleasesApi.md#unset_label) | **POST** {deb_release_href}unset_label/ | Unset a label
*ContentSourceIndicesApi* | [**create**](docs/ContentSourceIndicesApi.md#create) | **POST** /pulp/api/v3/content/deb/source_indices/ | Create a source index
*ContentSourceIndicesApi* | [**list**](docs/ContentSourceIndicesApi.md#list) | **GET** /pulp/api/v3/content/deb/source_indices/ | List SourceIndices
*ContentSourceIndicesApi* | [**read**](docs/ContentSourceIndicesApi.md#read) | **GET** {deb_source_index_href} | Inspect a source index
*ContentSourceIndicesApi* | [**set_label**](docs/ContentSourceIndicesApi.md#set_label) | **POST** {deb_source_index_href}set_label/ | Set a label
*ContentSourceIndicesApi* | [**unset_label**](docs/ContentSourceIndicesApi.md#unset_label) | **POST** {deb_source_index_href}unset_label/ | Unset a label
*ContentSourcePackagesApi* | [**create**](docs/ContentSourcePackagesApi.md#create) | **POST** /pulp/api/v3/content/deb/source_packages/ | Create a source package
*ContentSourcePackagesApi* | [**list**](docs/ContentSourcePackagesApi.md#list) | **GET** /pulp/api/v3/content/deb/source_packages/ | List source packages
*ContentSourcePackagesApi* | [**read**](docs/ContentSourcePackagesApi.md#read) | **GET** {deb_source_package_href} | Inspect a source package
*ContentSourcePackagesApi* | [**set_label**](docs/ContentSourcePackagesApi.md#set_label) | **POST** {deb_source_package_href}set_label/ | Set a label
*ContentSourcePackagesApi* | [**unset_label**](docs/ContentSourcePackagesApi.md#unset_label) | **POST** {deb_source_package_href}unset_label/ | Unset a label
*ContentSourceReleaseComponentsApi* | [**create**](docs/ContentSourceReleaseComponentsApi.md#create) | **POST** /pulp/api/v3/content/deb/source_release_components/ | Create a source package release component
*ContentSourceReleaseComponentsApi* | [**list**](docs/ContentSourceReleaseComponentsApi.md#list) | **GET** /pulp/api/v3/content/deb/source_release_components/ | List source package release components
*ContentSourceReleaseComponentsApi* | [**read**](docs/ContentSourceReleaseComponentsApi.md#read) | **GET** {deb_source_package_release_component_href} | Inspect a source package release component
*ContentSourceReleaseComponentsApi* | [**set_label**](docs/ContentSourceReleaseComponentsApi.md#set_label) | **POST** {deb_source_package_release_component_href}set_label/ | Set a label
*ContentSourceReleaseComponentsApi* | [**unset_label**](docs/ContentSourceReleaseComponentsApi.md#unset_label) | **POST** {deb_source_package_release_component_href}unset_label/ | Unset a label
*DebCopyApi* | [**copy_content**](docs/DebCopyApi.md#copy_content) | **POST** /pulp/api/v3/deb/copy/ | Copy content
*DistributionsAptApi* | [**add_role**](docs/DistributionsAptApi.md#add_role) | **POST** {deb_apt_distribution_href}add_role/ | Add a role
*DistributionsAptApi* | [**create**](docs/DistributionsAptApi.md#create) | **POST** /pulp/api/v3/distributions/deb/apt/ | Create an apt distribution
*DistributionsAptApi* | [**delete**](docs/DistributionsAptApi.md#delete) | **DELETE** {deb_apt_distribution_href} | Delete an apt distribution
*DistributionsAptApi* | [**list**](docs/DistributionsAptApi.md#list) | **GET** /pulp/api/v3/distributions/deb/apt/ | List apt distributions
*DistributionsAptApi* | [**list_roles**](docs/DistributionsAptApi.md#list_roles) | **GET** {deb_apt_distribution_href}list_roles/ | List roles
*DistributionsAptApi* | [**my_permissions**](docs/DistributionsAptApi.md#my_permissions) | **GET** {deb_apt_distribution_href}my_permissions/ | List user permissions
*DistributionsAptApi* | [**partial_update**](docs/DistributionsAptApi.md#partial_update) | **PATCH** {deb_apt_distribution_href} | Update an apt distribution
*DistributionsAptApi* | [**read**](docs/DistributionsAptApi.md#read) | **GET** {deb_apt_distribution_href} | Inspect an apt distribution
*DistributionsAptApi* | [**remove_role**](docs/DistributionsAptApi.md#remove_role) | **POST** {deb_apt_distribution_href}remove_role/ | Remove a role
*DistributionsAptApi* | [**set_label**](docs/DistributionsAptApi.md#set_label) | **POST** {deb_apt_distribution_href}set_label/ | Set a label
*DistributionsAptApi* | [**unset_label**](docs/DistributionsAptApi.md#unset_label) | **POST** {deb_apt_distribution_href}unset_label/ | Unset a label
*DistributionsAptApi* | [**update**](docs/DistributionsAptApi.md#update) | **PUT** {deb_apt_distribution_href} | Update an apt distribution
*PublicationsAptApi* | [**add_role**](docs/PublicationsAptApi.md#add_role) | **POST** {deb_apt_publication_href}add_role/ | Add a role
*PublicationsAptApi* | [**create**](docs/PublicationsAptApi.md#create) | **POST** /pulp/api/v3/publications/deb/apt/ | Create an apt publication
*PublicationsAptApi* | [**delete**](docs/PublicationsAptApi.md#delete) | **DELETE** {deb_apt_publication_href} | Delete an apt publication
*PublicationsAptApi* | [**list**](docs/PublicationsAptApi.md#list) | **GET** /pulp/api/v3/publications/deb/apt/ | List apt publications
*PublicationsAptApi* | [**list_roles**](docs/PublicationsAptApi.md#list_roles) | **GET** {deb_apt_publication_href}list_roles/ | List roles
*PublicationsAptApi* | [**my_permissions**](docs/PublicationsAptApi.md#my_permissions) | **GET** {deb_apt_publication_href}my_permissions/ | List user permissions
*PublicationsAptApi* | [**read**](docs/PublicationsAptApi.md#read) | **GET** {deb_apt_publication_href} | Inspect an apt publication
*PublicationsAptApi* | [**remove_role**](docs/PublicationsAptApi.md#remove_role) | **POST** {deb_apt_publication_href}remove_role/ | Remove a role
*PublicationsVerbatimApi* | [**add_role**](docs/PublicationsVerbatimApi.md#add_role) | **POST** {deb_verbatim_publication_href}add_role/ | Add a role
*PublicationsVerbatimApi* | [**create**](docs/PublicationsVerbatimApi.md#create) | **POST** /pulp/api/v3/publications/deb/verbatim/ | Create a verbatim publication
*PublicationsVerbatimApi* | [**delete**](docs/PublicationsVerbatimApi.md#delete) | **DELETE** {deb_verbatim_publication_href} | Delete a verbatim publication
*PublicationsVerbatimApi* | [**list**](docs/PublicationsVerbatimApi.md#list) | **GET** /pulp/api/v3/publications/deb/verbatim/ | List verbatim publications
*PublicationsVerbatimApi* | [**list_roles**](docs/PublicationsVerbatimApi.md#list_roles) | **GET** {deb_verbatim_publication_href}list_roles/ | List roles
*PublicationsVerbatimApi* | [**my_permissions**](docs/PublicationsVerbatimApi.md#my_permissions) | **GET** {deb_verbatim_publication_href}my_permissions/ | List user permissions
*PublicationsVerbatimApi* | [**read**](docs/PublicationsVerbatimApi.md#read) | **GET** {deb_verbatim_publication_href} | Inspect a verbatim publication
*PublicationsVerbatimApi* | [**remove_role**](docs/PublicationsVerbatimApi.md#remove_role) | **POST** {deb_verbatim_publication_href}remove_role/ | Remove a role
*RemotesAptApi* | [**add_role**](docs/RemotesAptApi.md#add_role) | **POST** {deb_apt_remote_href}add_role/ | Add a role
*RemotesAptApi* | [**create**](docs/RemotesAptApi.md#create) | **POST** /pulp/api/v3/remotes/deb/apt/ | Create an apt remote
*RemotesAptApi* | [**delete**](docs/RemotesAptApi.md#delete) | **DELETE** {deb_apt_remote_href} | Delete an apt remote
*RemotesAptApi* | [**list**](docs/RemotesAptApi.md#list) | **GET** /pulp/api/v3/remotes/deb/apt/ | List apt remotes
*RemotesAptApi* | [**list_roles**](docs/RemotesAptApi.md#list_roles) | **GET** {deb_apt_remote_href}list_roles/ | List roles
*RemotesAptApi* | [**my_permissions**](docs/RemotesAptApi.md#my_permissions) | **GET** {deb_apt_remote_href}my_permissions/ | List user permissions
*RemotesAptApi* | [**partial_update**](docs/RemotesAptApi.md#partial_update) | **PATCH** {deb_apt_remote_href} | Update an apt remote
*RemotesAptApi* | [**read**](docs/RemotesAptApi.md#read) | **GET** {deb_apt_remote_href} | Inspect an apt remote
*RemotesAptApi* | [**remove_role**](docs/RemotesAptApi.md#remove_role) | **POST** {deb_apt_remote_href}remove_role/ | Remove a role
*RemotesAptApi* | [**set_label**](docs/RemotesAptApi.md#set_label) | **POST** {deb_apt_remote_href}set_label/ | Set a label
*RemotesAptApi* | [**unset_label**](docs/RemotesAptApi.md#unset_label) | **POST** {deb_apt_remote_href}unset_label/ | Unset a label
*RemotesAptApi* | [**update**](docs/RemotesAptApi.md#update) | **PUT** {deb_apt_remote_href} | Update an apt remote
*RepositoriesAptApi* | [**add_role**](docs/RepositoriesAptApi.md#add_role) | **POST** {deb_apt_repository_href}add_role/ | Add a role
*RepositoriesAptApi* | [**create**](docs/RepositoriesAptApi.md#create) | **POST** /pulp/api/v3/repositories/deb/apt/ | Create an apt repository
*RepositoriesAptApi* | [**delete**](docs/RepositoriesAptApi.md#delete) | **DELETE** {deb_apt_repository_href} | Delete an apt repository
*RepositoriesAptApi* | [**list**](docs/RepositoriesAptApi.md#list) | **GET** /pulp/api/v3/repositories/deb/apt/ | List apt repositorys
*RepositoriesAptApi* | [**list_roles**](docs/RepositoriesAptApi.md#list_roles) | **GET** {deb_apt_repository_href}list_roles/ | List roles
*RepositoriesAptApi* | [**modify**](docs/RepositoriesAptApi.md#modify) | **POST** {deb_apt_repository_href}modify/ | Modify Repository Content
*RepositoriesAptApi* | [**my_permissions**](docs/RepositoriesAptApi.md#my_permissions) | **GET** {deb_apt_repository_href}my_permissions/ | List user permissions
*RepositoriesAptApi* | [**partial_update**](docs/RepositoriesAptApi.md#partial_update) | **PATCH** {deb_apt_repository_href} | Update an apt repository
*RepositoriesAptApi* | [**read**](docs/RepositoriesAptApi.md#read) | **GET** {deb_apt_repository_href} | Inspect an apt repository
*RepositoriesAptApi* | [**remove_role**](docs/RepositoriesAptApi.md#remove_role) | **POST** {deb_apt_repository_href}remove_role/ | Remove a role
*RepositoriesAptApi* | [**set_label**](docs/RepositoriesAptApi.md#set_label) | **POST** {deb_apt_repository_href}set_label/ | Set a label
*RepositoriesAptApi* | [**sync**](docs/RepositoriesAptApi.md#sync) | **POST** {deb_apt_repository_href}sync/ | Sync from remote
*RepositoriesAptApi* | [**unset_label**](docs/RepositoriesAptApi.md#unset_label) | **POST** {deb_apt_repository_href}unset_label/ | Unset a label
*RepositoriesAptApi* | [**update**](docs/RepositoriesAptApi.md#update) | **PUT** {deb_apt_repository_href} | Update an apt repository
*RepositoriesAptVersionsApi* | [**delete**](docs/RepositoriesAptVersionsApi.md#delete) | **DELETE** {deb_apt_repository_version_href} | Delete a repository version
*RepositoriesAptVersionsApi* | [**list**](docs/RepositoriesAptVersionsApi.md#list) | **GET** {deb_apt_repository_href}versions/ | List repository versions
*RepositoriesAptVersionsApi* | [**read**](docs/RepositoriesAptVersionsApi.md#read) | **GET** {deb_apt_repository_version_href} | Inspect a repository version
*RepositoriesAptVersionsApi* | [**repair**](docs/RepositoriesAptVersionsApi.md#repair) | **POST** {deb_apt_repository_version_href}repair/ | 


## Documentation For Models

 - [AptRepositorySyncURL](docs/AptRepositorySyncURL.md)
 - [AsyncOperationResponse](docs/AsyncOperationResponse.md)
 - [ContentSummaryResponse](docs/ContentSummaryResponse.md)
 - [Copy](docs/Copy.md)
 - [DebAptDistribution](docs/DebAptDistribution.md)
 - [DebAptDistributionResponse](docs/DebAptDistributionResponse.md)
 - [DebAptPublication](docs/DebAptPublication.md)
 - [DebAptPublicationResponse](docs/DebAptPublicationResponse.md)
 - [DebAptRemote](docs/DebAptRemote.md)
 - [DebAptRemoteResponse](docs/DebAptRemoteResponse.md)
 - [DebAptRemoteResponseHiddenFieldsInner](docs/DebAptRemoteResponseHiddenFieldsInner.md)
 - [DebAptRepository](docs/DebAptRepository.md)
 - [DebAptRepositoryResponse](docs/DebAptRepositoryResponse.md)
 - [DebGenericContentResponse](docs/DebGenericContentResponse.md)
 - [DebInstallerFileIndex](docs/DebInstallerFileIndex.md)
 - [DebInstallerFileIndexResponse](docs/DebInstallerFileIndexResponse.md)
 - [DebInstallerPackageResponse](docs/DebInstallerPackageResponse.md)
 - [DebPackageIndex](docs/DebPackageIndex.md)
 - [DebPackageIndexResponse](docs/DebPackageIndexResponse.md)
 - [DebPackageReleaseComponent](docs/DebPackageReleaseComponent.md)
 - [DebPackageReleaseComponentResponse](docs/DebPackageReleaseComponentResponse.md)
 - [DebPackageResponse](docs/DebPackageResponse.md)
 - [DebRelease](docs/DebRelease.md)
 - [DebReleaseArchitecture](docs/DebReleaseArchitecture.md)
 - [DebReleaseArchitectureResponse](docs/DebReleaseArchitectureResponse.md)
 - [DebReleaseComponent](docs/DebReleaseComponent.md)
 - [DebReleaseComponentResponse](docs/DebReleaseComponentResponse.md)
 - [DebReleaseFile](docs/DebReleaseFile.md)
 - [DebReleaseFileResponse](docs/DebReleaseFileResponse.md)
 - [DebReleaseResponse](docs/DebReleaseResponse.md)
 - [DebSourceIndex](docs/DebSourceIndex.md)
 - [DebSourceIndexResponse](docs/DebSourceIndexResponse.md)
 - [DebSourcePackage](docs/DebSourcePackage.md)
 - [DebSourcePackageReleaseComponent](docs/DebSourcePackageReleaseComponent.md)
 - [DebSourcePackageReleaseComponentResponse](docs/DebSourcePackageReleaseComponentResponse.md)
 - [DebSourcePackageResponse](docs/DebSourcePackageResponse.md)
 - [DebVerbatimPublication](docs/DebVerbatimPublication.md)
 - [DebVerbatimPublicationResponse](docs/DebVerbatimPublicationResponse.md)
 - [MyPermissionsResponse](docs/MyPermissionsResponse.md)
 - [NestedRole](docs/NestedRole.md)
 - [NestedRoleResponse](docs/NestedRoleResponse.md)
 - [ObjectRolesResponse](docs/ObjectRolesResponse.md)
 - [PaginatedRepositoryVersionResponseList](docs/PaginatedRepositoryVersionResponseList.md)
 - [PaginateddebAptDistributionResponseList](docs/PaginateddebAptDistributionResponseList.md)
 - [PaginateddebAptPublicationResponseList](docs/PaginateddebAptPublicationResponseList.md)
 - [PaginateddebAptRemoteResponseList](docs/PaginateddebAptRemoteResponseList.md)
 - [PaginateddebAptRepositoryResponseList](docs/PaginateddebAptRepositoryResponseList.md)
 - [PaginateddebGenericContentResponseList](docs/PaginateddebGenericContentResponseList.md)
 - [PaginateddebInstallerFileIndexResponseList](docs/PaginateddebInstallerFileIndexResponseList.md)
 - [PaginateddebInstallerPackageResponseList](docs/PaginateddebInstallerPackageResponseList.md)
 - [PaginateddebPackageIndexResponseList](docs/PaginateddebPackageIndexResponseList.md)
 - [PaginateddebPackageReleaseComponentResponseList](docs/PaginateddebPackageReleaseComponentResponseList.md)
 - [PaginateddebPackageResponseList](docs/PaginateddebPackageResponseList.md)
 - [PaginateddebReleaseArchitectureResponseList](docs/PaginateddebReleaseArchitectureResponseList.md)
 - [PaginateddebReleaseComponentResponseList](docs/PaginateddebReleaseComponentResponseList.md)
 - [PaginateddebReleaseFileResponseList](docs/PaginateddebReleaseFileResponseList.md)
 - [PaginateddebReleaseResponseList](docs/PaginateddebReleaseResponseList.md)
 - [PaginateddebSourceIndexResponseList](docs/PaginateddebSourceIndexResponseList.md)
 - [PaginateddebSourcePackageReleaseComponentResponseList](docs/PaginateddebSourcePackageReleaseComponentResponseList.md)
 - [PaginateddebSourcePackageResponseList](docs/PaginateddebSourcePackageResponseList.md)
 - [PaginateddebVerbatimPublicationResponseList](docs/PaginateddebVerbatimPublicationResponseList.md)
 - [PatcheddebAptDistribution](docs/PatcheddebAptDistribution.md)
 - [PatcheddebAptRemote](docs/PatcheddebAptRemote.md)
 - [PatcheddebAptRepository](docs/PatcheddebAptRepository.md)
 - [PolicyEnum](docs/PolicyEnum.md)
 - [Repair](docs/Repair.md)
 - [RepositoryAddRemoveContent](docs/RepositoryAddRemoveContent.md)
 - [RepositoryVersionResponse](docs/RepositoryVersionResponse.md)
 - [SetLabel](docs/SetLabel.md)
 - [SetLabelResponse](docs/SetLabelResponse.md)
 - [UnsetLabel](docs/UnsetLabel.md)
 - [UnsetLabelResponse](docs/UnsetLabelResponse.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization


Authentication schemes defined for the API:
<a id="basicAuth"></a>
### basicAuth

- **Type**: HTTP basic authentication

<a id="cookieAuth"></a>
### cookieAuth

- **Type**: API key
- **API key parameter name**: sessionid
- **Location**: 


## Author

pulp-list@redhat.com


