# coding: utf-8

"""
    Pulp 3 API

    Fetch, Upload, Organize, and Distribute Software Packages

    The version of the OpenAPI document: v3
    Contact: pulp-list@redhat.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictFloat, StrictInt, StrictStr, field_validator
from typing import List, Optional, Union
from typing_extensions import Annotated
from pulpcore.client.pulp_deb.models.async_operation_response import AsyncOperationResponse
from pulpcore.client.pulp_deb.models.deb_source_package import DebSourcePackage
from pulpcore.client.pulp_deb.models.deb_source_package_response import DebSourcePackageResponse
from pulpcore.client.pulp_deb.models.paginateddeb_source_package_response_list import PaginateddebSourcePackageResponseList
from pulpcore.client.pulp_deb.models.set_label import SetLabel
from pulpcore.client.pulp_deb.models.set_label_response import SetLabelResponse
from pulpcore.client.pulp_deb.models.unset_label import UnsetLabel
from pulpcore.client.pulp_deb.models.unset_label_response import UnsetLabelResponse

from pulpcore.client.pulp_deb.api_client import ApiClient, RequestSerialized
from pulpcore.client.pulp_deb.api_response import ApiResponse
from pulpcore.client.pulp_deb.rest import RESTResponseType


class ContentSourcePackagesApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def create(
        self,
        deb_source_package: DebSourcePackage,
        x_task_diagnostics: Annotated[Optional[List[StrictStr]], Field(description="List of profilers to use on tasks.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> AsyncOperationResponse:
        """Create a source package

        Trigger an asynchronous task to create content,optionally create new repository version.

        :param deb_source_package: (required)
        :type deb_source_package: DebSourcePackage
        :param x_task_diagnostics: List of profilers to use on tasks.
        :type x_task_diagnostics: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_serialize(
            deb_source_package=deb_source_package,
            x_task_diagnostics=x_task_diagnostics,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '202': "AsyncOperationResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def create_with_http_info(
        self,
        deb_source_package: DebSourcePackage,
        x_task_diagnostics: Annotated[Optional[List[StrictStr]], Field(description="List of profilers to use on tasks.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[AsyncOperationResponse]:
        """Create a source package

        Trigger an asynchronous task to create content,optionally create new repository version.

        :param deb_source_package: (required)
        :type deb_source_package: DebSourcePackage
        :param x_task_diagnostics: List of profilers to use on tasks.
        :type x_task_diagnostics: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_serialize(
            deb_source_package=deb_source_package,
            x_task_diagnostics=x_task_diagnostics,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '202': "AsyncOperationResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def create_without_preload_content(
        self,
        deb_source_package: DebSourcePackage,
        x_task_diagnostics: Annotated[Optional[List[StrictStr]], Field(description="List of profilers to use on tasks.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Create a source package

        Trigger an asynchronous task to create content,optionally create new repository version.

        :param deb_source_package: (required)
        :type deb_source_package: DebSourcePackage
        :param x_task_diagnostics: List of profilers to use on tasks.
        :type x_task_diagnostics: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_serialize(
            deb_source_package=deb_source_package,
            x_task_diagnostics=x_task_diagnostics,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '202': "AsyncOperationResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _create_serialize(
        self,
        deb_source_package,
        x_task_diagnostics,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'X-Task-Diagnostics': 'csv',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        if x_task_diagnostics is not None:
            _header_params['X-Task-Diagnostics'] = x_task_diagnostics
        # process the form parameters
        # process the body parameter
        if deb_source_package is not None:
            _body_params = deb_source_package


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'basicAuth', 
            'cookieAuth'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/pulp/api/v3/content/deb/source_packages/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def list(
        self,
        x_task_diagnostics: Annotated[Optional[List[StrictStr]], Field(description="List of profilers to use on tasks.")] = None,
        architecture: Annotated[Optional[StrictStr], Field(description="Filter results where architecture matches value")] = None,
        binary: Annotated[Optional[StrictStr], Field(description="Filter results where binary matches value")] = None,
        build_conflicts: Annotated[Optional[StrictStr], Field(description="Filter results where build_conflicts matches value")] = None,
        build_conflicts_arch: Annotated[Optional[StrictStr], Field(description="Filter results where build_conflicts_arch matches value")] = None,
        build_conflicts_indep: Annotated[Optional[StrictStr], Field(description="Filter results where build_conflicts_indep matches value")] = None,
        build_depends: Annotated[Optional[StrictStr], Field(description="Filter results where build_depends matches value")] = None,
        build_depends_arch: Annotated[Optional[StrictStr], Field(description="Filter results where build_depends_arch matches value")] = None,
        build_depends_indep: Annotated[Optional[StrictStr], Field(description="Filter results where build_depends_indep matches value")] = None,
        dgit: Annotated[Optional[StrictStr], Field(description="Filter results where dgit matches value")] = None,
        format: Annotated[Optional[StrictStr], Field(description="Filter results where format matches value")] = None,
        homepage: Annotated[Optional[StrictStr], Field(description="Filter results where homepage matches value")] = None,
        limit: Annotated[Optional[StrictInt], Field(description="Number of results to return per page.")] = None,
        maintainer: Annotated[Optional[StrictStr], Field(description="Filter results where maintainer matches value")] = None,
        offset: Annotated[Optional[StrictInt], Field(description="The initial index from which to return the results.")] = None,
        ordering: Annotated[Optional[List[StrictStr]], Field(description="Ordering  * `pulp_id` - Pulp id * `-pulp_id` - Pulp id (descending) * `pulp_created` - Pulp created * `-pulp_created` - Pulp created (descending) * `pulp_last_updated` - Pulp last updated * `-pulp_last_updated` - Pulp last updated (descending) * `pulp_type` - Pulp type * `-pulp_type` - Pulp type (descending) * `upstream_id` - Upstream id * `-upstream_id` - Upstream id (descending) * `pulp_labels` - Pulp labels * `-pulp_labels` - Pulp labels (descending) * `timestamp_of_interest` - Timestamp of interest * `-timestamp_of_interest` - Timestamp of interest (descending) * `relative_path` - Relative path * `-relative_path` - Relative path (descending) * `format` - Format * `-format` - Format (descending) * `source` - Source * `-source` - Source (descending) * `binary` - Binary * `-binary` - Binary (descending) * `architecture` - Architecture * `-architecture` - Architecture (descending) * `version` - Version * `-version` - Version (descending) * `maintainer` - Maintainer * `-maintainer` - Maintainer (descending) * `uploaders` - Uploaders * `-uploaders` - Uploaders (descending) * `homepage` - Homepage * `-homepage` - Homepage (descending) * `vcs_browser` - Vcs browser * `-vcs_browser` - Vcs browser (descending) * `vcs_arch` - Vcs arch * `-vcs_arch` - Vcs arch (descending) * `vcs_bzr` - Vcs bzr * `-vcs_bzr` - Vcs bzr (descending) * `vcs_cvs` - Vcs cvs * `-vcs_cvs` - Vcs cvs (descending) * `vcs_darcs` - Vcs darcs * `-vcs_darcs` - Vcs darcs (descending) * `vcs_git` - Vcs git * `-vcs_git` - Vcs git (descending) * `vcs_hg` - Vcs hg * `-vcs_hg` - Vcs hg (descending) * `vcs_mtn` - Vcs mtn * `-vcs_mtn` - Vcs mtn (descending) * `vcs_snv` - Vcs snv * `-vcs_snv` - Vcs snv (descending) * `testsuite` - Testsuite * `-testsuite` - Testsuite (descending) * `dgit` - Dgit * `-dgit` - Dgit (descending) * `standards_version` - Standards version * `-standards_version` - Standards version (descending) * `build_depends` - Build depends * `-build_depends` - Build depends (descending) * `build_depends_indep` - Build depends indep * `-build_depends_indep` - Build depends indep (descending) * `build_depends_arch` - Build depends arch * `-build_depends_arch` - Build depends arch (descending) * `build_conflicts` - Build conflicts * `-build_conflicts` - Build conflicts (descending) * `build_conflicts_indep` - Build conflicts indep * `-build_conflicts_indep` - Build conflicts indep (descending) * `build_conflicts_arch` - Build conflicts arch * `-build_conflicts_arch` - Build conflicts arch (descending) * `package_list` - Package list * `-package_list` - Package list (descending) * `pk` - Pk * `-pk` - Pk (descending)")] = None,
        orphaned_for: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Minutes Content has been orphaned for. -1 uses ORPHAN_PROTECTION_TIME.")] = None,
        package_list: Annotated[Optional[StrictStr], Field(description="Filter results where package_list matches value")] = None,
        prn__in: Annotated[Optional[List[StrictStr]], Field(description="Multiple values may be separated by commas.")] = None,
        pulp_href__in: Annotated[Optional[List[StrictStr]], Field(description="Multiple values may be separated by commas.")] = None,
        pulp_id__in: Annotated[Optional[List[StrictStr]], Field(description="Multiple values may be separated by commas.")] = None,
        pulp_label_select: Annotated[Optional[StrictStr], Field(description="Filter labels by search string")] = None,
        q: Annotated[Optional[StrictStr], Field(description="Filter results by using NOT, AND and OR operations on other filters")] = None,
        relative_path: Annotated[Optional[StrictStr], Field(description="Filter results where relative_path matches value")] = None,
        release: Annotated[Optional[StrictStr], Field(description="     Must be a comma-separated string: \"release_href,repository_or_repository_version_href\"     release_href: Filter results where SourcePackage in Release     repository_or_repository_version_href: The RepositoryVersion href to filter by, or Repository         href (assume latest version)     ")] = None,
        release_component: Annotated[Optional[StrictStr], Field(description="     Must be a comma-separated string: \"release_component_href,repository_or_repository_version_href\"     release_component_href: Filter results where SourcePackage in ReleaseComponent     repository_or_repository_version_href: The RepositoryVersion href to filter by, or Repository         href (assume latest version)     ")] = None,
        repository_version: Annotated[Optional[StrictStr], Field(description="Repository Version referenced by HREF/PRN")] = None,
        repository_version_added: Annotated[Optional[StrictStr], Field(description="Repository Version referenced by HREF/PRN")] = None,
        repository_version_removed: Annotated[Optional[StrictStr], Field(description="Repository Version referenced by HREF/PRN")] = None,
        source: Annotated[Optional[StrictStr], Field(description="Filter results where source matches value")] = None,
        standards_version: Annotated[Optional[StrictStr], Field(description="Filter results where standards_version matches value")] = None,
        testsuite: Annotated[Optional[StrictStr], Field(description="Filter results where testsuite matches value")] = None,
        uploaders: Annotated[Optional[StrictStr], Field(description="Filter results where uploaders matches value")] = None,
        vcs_arch: Annotated[Optional[StrictStr], Field(description="Filter results where vcs_arch matches value")] = None,
        vcs_browser: Annotated[Optional[StrictStr], Field(description="Filter results where vcs_browser matches value")] = None,
        vcs_bzr: Annotated[Optional[StrictStr], Field(description="Filter results where vcs_bzr matches value")] = None,
        vcs_cvs: Annotated[Optional[StrictStr], Field(description="Filter results where vcs_cvs matches value")] = None,
        vcs_darcs: Annotated[Optional[StrictStr], Field(description="Filter results where vcs_darcs matches value")] = None,
        vcs_git: Annotated[Optional[StrictStr], Field(description="Filter results where vcs_git matches value")] = None,
        vcs_hg: Annotated[Optional[StrictStr], Field(description="Filter results where vcs_hg matches value")] = None,
        vcs_mtn: Annotated[Optional[StrictStr], Field(description="Filter results where vcs_mtn matches value")] = None,
        vcs_snv: Annotated[Optional[StrictStr], Field(description="Filter results where vcs_snv matches value")] = None,
        version: Annotated[Optional[StrictStr], Field(description="Filter results where version matches value")] = None,
        fields: Annotated[Optional[List[StrictStr]], Field(description="A list of fields to include in the response.")] = None,
        exclude_fields: Annotated[Optional[List[StrictStr]], Field(description="A list of fields to exclude from the response.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> PaginateddebSourcePackageResponseList:
        """List source packages

        A Debian Source Package file represents a '.dsc' file along with its associated artifacts such as orig.tar.gz, debian.tar.gz...  Associated artifacts: Exactly one '.dsc' file.

        :param x_task_diagnostics: List of profilers to use on tasks.
        :type x_task_diagnostics: List[str]
        :param architecture: Filter results where architecture matches value
        :type architecture: str
        :param binary: Filter results where binary matches value
        :type binary: str
        :param build_conflicts: Filter results where build_conflicts matches value
        :type build_conflicts: str
        :param build_conflicts_arch: Filter results where build_conflicts_arch matches value
        :type build_conflicts_arch: str
        :param build_conflicts_indep: Filter results where build_conflicts_indep matches value
        :type build_conflicts_indep: str
        :param build_depends: Filter results where build_depends matches value
        :type build_depends: str
        :param build_depends_arch: Filter results where build_depends_arch matches value
        :type build_depends_arch: str
        :param build_depends_indep: Filter results where build_depends_indep matches value
        :type build_depends_indep: str
        :param dgit: Filter results where dgit matches value
        :type dgit: str
        :param format: Filter results where format matches value
        :type format: str
        :param homepage: Filter results where homepage matches value
        :type homepage: str
        :param limit: Number of results to return per page.
        :type limit: int
        :param maintainer: Filter results where maintainer matches value
        :type maintainer: str
        :param offset: The initial index from which to return the results.
        :type offset: int
        :param ordering: Ordering  * `pulp_id` - Pulp id * `-pulp_id` - Pulp id (descending) * `pulp_created` - Pulp created * `-pulp_created` - Pulp created (descending) * `pulp_last_updated` - Pulp last updated * `-pulp_last_updated` - Pulp last updated (descending) * `pulp_type` - Pulp type * `-pulp_type` - Pulp type (descending) * `upstream_id` - Upstream id * `-upstream_id` - Upstream id (descending) * `pulp_labels` - Pulp labels * `-pulp_labels` - Pulp labels (descending) * `timestamp_of_interest` - Timestamp of interest * `-timestamp_of_interest` - Timestamp of interest (descending) * `relative_path` - Relative path * `-relative_path` - Relative path (descending) * `format` - Format * `-format` - Format (descending) * `source` - Source * `-source` - Source (descending) * `binary` - Binary * `-binary` - Binary (descending) * `architecture` - Architecture * `-architecture` - Architecture (descending) * `version` - Version * `-version` - Version (descending) * `maintainer` - Maintainer * `-maintainer` - Maintainer (descending) * `uploaders` - Uploaders * `-uploaders` - Uploaders (descending) * `homepage` - Homepage * `-homepage` - Homepage (descending) * `vcs_browser` - Vcs browser * `-vcs_browser` - Vcs browser (descending) * `vcs_arch` - Vcs arch * `-vcs_arch` - Vcs arch (descending) * `vcs_bzr` - Vcs bzr * `-vcs_bzr` - Vcs bzr (descending) * `vcs_cvs` - Vcs cvs * `-vcs_cvs` - Vcs cvs (descending) * `vcs_darcs` - Vcs darcs * `-vcs_darcs` - Vcs darcs (descending) * `vcs_git` - Vcs git * `-vcs_git` - Vcs git (descending) * `vcs_hg` - Vcs hg * `-vcs_hg` - Vcs hg (descending) * `vcs_mtn` - Vcs mtn * `-vcs_mtn` - Vcs mtn (descending) * `vcs_snv` - Vcs snv * `-vcs_snv` - Vcs snv (descending) * `testsuite` - Testsuite * `-testsuite` - Testsuite (descending) * `dgit` - Dgit * `-dgit` - Dgit (descending) * `standards_version` - Standards version * `-standards_version` - Standards version (descending) * `build_depends` - Build depends * `-build_depends` - Build depends (descending) * `build_depends_indep` - Build depends indep * `-build_depends_indep` - Build depends indep (descending) * `build_depends_arch` - Build depends arch * `-build_depends_arch` - Build depends arch (descending) * `build_conflicts` - Build conflicts * `-build_conflicts` - Build conflicts (descending) * `build_conflicts_indep` - Build conflicts indep * `-build_conflicts_indep` - Build conflicts indep (descending) * `build_conflicts_arch` - Build conflicts arch * `-build_conflicts_arch` - Build conflicts arch (descending) * `package_list` - Package list * `-package_list` - Package list (descending) * `pk` - Pk * `-pk` - Pk (descending)
        :type ordering: List[str]
        :param orphaned_for: Minutes Content has been orphaned for. -1 uses ORPHAN_PROTECTION_TIME.
        :type orphaned_for: float
        :param package_list: Filter results where package_list matches value
        :type package_list: str
        :param prn__in: Multiple values may be separated by commas.
        :type prn__in: List[str]
        :param pulp_href__in: Multiple values may be separated by commas.
        :type pulp_href__in: List[str]
        :param pulp_id__in: Multiple values may be separated by commas.
        :type pulp_id__in: List[str]
        :param pulp_label_select: Filter labels by search string
        :type pulp_label_select: str
        :param q: Filter results by using NOT, AND and OR operations on other filters
        :type q: str
        :param relative_path: Filter results where relative_path matches value
        :type relative_path: str
        :param release:      Must be a comma-separated string: \"release_href,repository_or_repository_version_href\"     release_href: Filter results where SourcePackage in Release     repository_or_repository_version_href: The RepositoryVersion href to filter by, or Repository         href (assume latest version)     
        :type release: str
        :param release_component:      Must be a comma-separated string: \"release_component_href,repository_or_repository_version_href\"     release_component_href: Filter results where SourcePackage in ReleaseComponent     repository_or_repository_version_href: The RepositoryVersion href to filter by, or Repository         href (assume latest version)     
        :type release_component: str
        :param repository_version: Repository Version referenced by HREF/PRN
        :type repository_version: str
        :param repository_version_added: Repository Version referenced by HREF/PRN
        :type repository_version_added: str
        :param repository_version_removed: Repository Version referenced by HREF/PRN
        :type repository_version_removed: str
        :param source: Filter results where source matches value
        :type source: str
        :param standards_version: Filter results where standards_version matches value
        :type standards_version: str
        :param testsuite: Filter results where testsuite matches value
        :type testsuite: str
        :param uploaders: Filter results where uploaders matches value
        :type uploaders: str
        :param vcs_arch: Filter results where vcs_arch matches value
        :type vcs_arch: str
        :param vcs_browser: Filter results where vcs_browser matches value
        :type vcs_browser: str
        :param vcs_bzr: Filter results where vcs_bzr matches value
        :type vcs_bzr: str
        :param vcs_cvs: Filter results where vcs_cvs matches value
        :type vcs_cvs: str
        :param vcs_darcs: Filter results where vcs_darcs matches value
        :type vcs_darcs: str
        :param vcs_git: Filter results where vcs_git matches value
        :type vcs_git: str
        :param vcs_hg: Filter results where vcs_hg matches value
        :type vcs_hg: str
        :param vcs_mtn: Filter results where vcs_mtn matches value
        :type vcs_mtn: str
        :param vcs_snv: Filter results where vcs_snv matches value
        :type vcs_snv: str
        :param version: Filter results where version matches value
        :type version: str
        :param fields: A list of fields to include in the response.
        :type fields: List[str]
        :param exclude_fields: A list of fields to exclude from the response.
        :type exclude_fields: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_serialize(
            x_task_diagnostics=x_task_diagnostics,
            architecture=architecture,
            binary=binary,
            build_conflicts=build_conflicts,
            build_conflicts_arch=build_conflicts_arch,
            build_conflicts_indep=build_conflicts_indep,
            build_depends=build_depends,
            build_depends_arch=build_depends_arch,
            build_depends_indep=build_depends_indep,
            dgit=dgit,
            format=format,
            homepage=homepage,
            limit=limit,
            maintainer=maintainer,
            offset=offset,
            ordering=ordering,
            orphaned_for=orphaned_for,
            package_list=package_list,
            prn__in=prn__in,
            pulp_href__in=pulp_href__in,
            pulp_id__in=pulp_id__in,
            pulp_label_select=pulp_label_select,
            q=q,
            relative_path=relative_path,
            release=release,
            release_component=release_component,
            repository_version=repository_version,
            repository_version_added=repository_version_added,
            repository_version_removed=repository_version_removed,
            source=source,
            standards_version=standards_version,
            testsuite=testsuite,
            uploaders=uploaders,
            vcs_arch=vcs_arch,
            vcs_browser=vcs_browser,
            vcs_bzr=vcs_bzr,
            vcs_cvs=vcs_cvs,
            vcs_darcs=vcs_darcs,
            vcs_git=vcs_git,
            vcs_hg=vcs_hg,
            vcs_mtn=vcs_mtn,
            vcs_snv=vcs_snv,
            version=version,
            fields=fields,
            exclude_fields=exclude_fields,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PaginateddebSourcePackageResponseList",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def list_with_http_info(
        self,
        x_task_diagnostics: Annotated[Optional[List[StrictStr]], Field(description="List of profilers to use on tasks.")] = None,
        architecture: Annotated[Optional[StrictStr], Field(description="Filter results where architecture matches value")] = None,
        binary: Annotated[Optional[StrictStr], Field(description="Filter results where binary matches value")] = None,
        build_conflicts: Annotated[Optional[StrictStr], Field(description="Filter results where build_conflicts matches value")] = None,
        build_conflicts_arch: Annotated[Optional[StrictStr], Field(description="Filter results where build_conflicts_arch matches value")] = None,
        build_conflicts_indep: Annotated[Optional[StrictStr], Field(description="Filter results where build_conflicts_indep matches value")] = None,
        build_depends: Annotated[Optional[StrictStr], Field(description="Filter results where build_depends matches value")] = None,
        build_depends_arch: Annotated[Optional[StrictStr], Field(description="Filter results where build_depends_arch matches value")] = None,
        build_depends_indep: Annotated[Optional[StrictStr], Field(description="Filter results where build_depends_indep matches value")] = None,
        dgit: Annotated[Optional[StrictStr], Field(description="Filter results where dgit matches value")] = None,
        format: Annotated[Optional[StrictStr], Field(description="Filter results where format matches value")] = None,
        homepage: Annotated[Optional[StrictStr], Field(description="Filter results where homepage matches value")] = None,
        limit: Annotated[Optional[StrictInt], Field(description="Number of results to return per page.")] = None,
        maintainer: Annotated[Optional[StrictStr], Field(description="Filter results where maintainer matches value")] = None,
        offset: Annotated[Optional[StrictInt], Field(description="The initial index from which to return the results.")] = None,
        ordering: Annotated[Optional[List[StrictStr]], Field(description="Ordering  * `pulp_id` - Pulp id * `-pulp_id` - Pulp id (descending) * `pulp_created` - Pulp created * `-pulp_created` - Pulp created (descending) * `pulp_last_updated` - Pulp last updated * `-pulp_last_updated` - Pulp last updated (descending) * `pulp_type` - Pulp type * `-pulp_type` - Pulp type (descending) * `upstream_id` - Upstream id * `-upstream_id` - Upstream id (descending) * `pulp_labels` - Pulp labels * `-pulp_labels` - Pulp labels (descending) * `timestamp_of_interest` - Timestamp of interest * `-timestamp_of_interest` - Timestamp of interest (descending) * `relative_path` - Relative path * `-relative_path` - Relative path (descending) * `format` - Format * `-format` - Format (descending) * `source` - Source * `-source` - Source (descending) * `binary` - Binary * `-binary` - Binary (descending) * `architecture` - Architecture * `-architecture` - Architecture (descending) * `version` - Version * `-version` - Version (descending) * `maintainer` - Maintainer * `-maintainer` - Maintainer (descending) * `uploaders` - Uploaders * `-uploaders` - Uploaders (descending) * `homepage` - Homepage * `-homepage` - Homepage (descending) * `vcs_browser` - Vcs browser * `-vcs_browser` - Vcs browser (descending) * `vcs_arch` - Vcs arch * `-vcs_arch` - Vcs arch (descending) * `vcs_bzr` - Vcs bzr * `-vcs_bzr` - Vcs bzr (descending) * `vcs_cvs` - Vcs cvs * `-vcs_cvs` - Vcs cvs (descending) * `vcs_darcs` - Vcs darcs * `-vcs_darcs` - Vcs darcs (descending) * `vcs_git` - Vcs git * `-vcs_git` - Vcs git (descending) * `vcs_hg` - Vcs hg * `-vcs_hg` - Vcs hg (descending) * `vcs_mtn` - Vcs mtn * `-vcs_mtn` - Vcs mtn (descending) * `vcs_snv` - Vcs snv * `-vcs_snv` - Vcs snv (descending) * `testsuite` - Testsuite * `-testsuite` - Testsuite (descending) * `dgit` - Dgit * `-dgit` - Dgit (descending) * `standards_version` - Standards version * `-standards_version` - Standards version (descending) * `build_depends` - Build depends * `-build_depends` - Build depends (descending) * `build_depends_indep` - Build depends indep * `-build_depends_indep` - Build depends indep (descending) * `build_depends_arch` - Build depends arch * `-build_depends_arch` - Build depends arch (descending) * `build_conflicts` - Build conflicts * `-build_conflicts` - Build conflicts (descending) * `build_conflicts_indep` - Build conflicts indep * `-build_conflicts_indep` - Build conflicts indep (descending) * `build_conflicts_arch` - Build conflicts arch * `-build_conflicts_arch` - Build conflicts arch (descending) * `package_list` - Package list * `-package_list` - Package list (descending) * `pk` - Pk * `-pk` - Pk (descending)")] = None,
        orphaned_for: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Minutes Content has been orphaned for. -1 uses ORPHAN_PROTECTION_TIME.")] = None,
        package_list: Annotated[Optional[StrictStr], Field(description="Filter results where package_list matches value")] = None,
        prn__in: Annotated[Optional[List[StrictStr]], Field(description="Multiple values may be separated by commas.")] = None,
        pulp_href__in: Annotated[Optional[List[StrictStr]], Field(description="Multiple values may be separated by commas.")] = None,
        pulp_id__in: Annotated[Optional[List[StrictStr]], Field(description="Multiple values may be separated by commas.")] = None,
        pulp_label_select: Annotated[Optional[StrictStr], Field(description="Filter labels by search string")] = None,
        q: Annotated[Optional[StrictStr], Field(description="Filter results by using NOT, AND and OR operations on other filters")] = None,
        relative_path: Annotated[Optional[StrictStr], Field(description="Filter results where relative_path matches value")] = None,
        release: Annotated[Optional[StrictStr], Field(description="     Must be a comma-separated string: \"release_href,repository_or_repository_version_href\"     release_href: Filter results where SourcePackage in Release     repository_or_repository_version_href: The RepositoryVersion href to filter by, or Repository         href (assume latest version)     ")] = None,
        release_component: Annotated[Optional[StrictStr], Field(description="     Must be a comma-separated string: \"release_component_href,repository_or_repository_version_href\"     release_component_href: Filter results where SourcePackage in ReleaseComponent     repository_or_repository_version_href: The RepositoryVersion href to filter by, or Repository         href (assume latest version)     ")] = None,
        repository_version: Annotated[Optional[StrictStr], Field(description="Repository Version referenced by HREF/PRN")] = None,
        repository_version_added: Annotated[Optional[StrictStr], Field(description="Repository Version referenced by HREF/PRN")] = None,
        repository_version_removed: Annotated[Optional[StrictStr], Field(description="Repository Version referenced by HREF/PRN")] = None,
        source: Annotated[Optional[StrictStr], Field(description="Filter results where source matches value")] = None,
        standards_version: Annotated[Optional[StrictStr], Field(description="Filter results where standards_version matches value")] = None,
        testsuite: Annotated[Optional[StrictStr], Field(description="Filter results where testsuite matches value")] = None,
        uploaders: Annotated[Optional[StrictStr], Field(description="Filter results where uploaders matches value")] = None,
        vcs_arch: Annotated[Optional[StrictStr], Field(description="Filter results where vcs_arch matches value")] = None,
        vcs_browser: Annotated[Optional[StrictStr], Field(description="Filter results where vcs_browser matches value")] = None,
        vcs_bzr: Annotated[Optional[StrictStr], Field(description="Filter results where vcs_bzr matches value")] = None,
        vcs_cvs: Annotated[Optional[StrictStr], Field(description="Filter results where vcs_cvs matches value")] = None,
        vcs_darcs: Annotated[Optional[StrictStr], Field(description="Filter results where vcs_darcs matches value")] = None,
        vcs_git: Annotated[Optional[StrictStr], Field(description="Filter results where vcs_git matches value")] = None,
        vcs_hg: Annotated[Optional[StrictStr], Field(description="Filter results where vcs_hg matches value")] = None,
        vcs_mtn: Annotated[Optional[StrictStr], Field(description="Filter results where vcs_mtn matches value")] = None,
        vcs_snv: Annotated[Optional[StrictStr], Field(description="Filter results where vcs_snv matches value")] = None,
        version: Annotated[Optional[StrictStr], Field(description="Filter results where version matches value")] = None,
        fields: Annotated[Optional[List[StrictStr]], Field(description="A list of fields to include in the response.")] = None,
        exclude_fields: Annotated[Optional[List[StrictStr]], Field(description="A list of fields to exclude from the response.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[PaginateddebSourcePackageResponseList]:
        """List source packages

        A Debian Source Package file represents a '.dsc' file along with its associated artifacts such as orig.tar.gz, debian.tar.gz...  Associated artifacts: Exactly one '.dsc' file.

        :param x_task_diagnostics: List of profilers to use on tasks.
        :type x_task_diagnostics: List[str]
        :param architecture: Filter results where architecture matches value
        :type architecture: str
        :param binary: Filter results where binary matches value
        :type binary: str
        :param build_conflicts: Filter results where build_conflicts matches value
        :type build_conflicts: str
        :param build_conflicts_arch: Filter results where build_conflicts_arch matches value
        :type build_conflicts_arch: str
        :param build_conflicts_indep: Filter results where build_conflicts_indep matches value
        :type build_conflicts_indep: str
        :param build_depends: Filter results where build_depends matches value
        :type build_depends: str
        :param build_depends_arch: Filter results where build_depends_arch matches value
        :type build_depends_arch: str
        :param build_depends_indep: Filter results where build_depends_indep matches value
        :type build_depends_indep: str
        :param dgit: Filter results where dgit matches value
        :type dgit: str
        :param format: Filter results where format matches value
        :type format: str
        :param homepage: Filter results where homepage matches value
        :type homepage: str
        :param limit: Number of results to return per page.
        :type limit: int
        :param maintainer: Filter results where maintainer matches value
        :type maintainer: str
        :param offset: The initial index from which to return the results.
        :type offset: int
        :param ordering: Ordering  * `pulp_id` - Pulp id * `-pulp_id` - Pulp id (descending) * `pulp_created` - Pulp created * `-pulp_created` - Pulp created (descending) * `pulp_last_updated` - Pulp last updated * `-pulp_last_updated` - Pulp last updated (descending) * `pulp_type` - Pulp type * `-pulp_type` - Pulp type (descending) * `upstream_id` - Upstream id * `-upstream_id` - Upstream id (descending) * `pulp_labels` - Pulp labels * `-pulp_labels` - Pulp labels (descending) * `timestamp_of_interest` - Timestamp of interest * `-timestamp_of_interest` - Timestamp of interest (descending) * `relative_path` - Relative path * `-relative_path` - Relative path (descending) * `format` - Format * `-format` - Format (descending) * `source` - Source * `-source` - Source (descending) * `binary` - Binary * `-binary` - Binary (descending) * `architecture` - Architecture * `-architecture` - Architecture (descending) * `version` - Version * `-version` - Version (descending) * `maintainer` - Maintainer * `-maintainer` - Maintainer (descending) * `uploaders` - Uploaders * `-uploaders` - Uploaders (descending) * `homepage` - Homepage * `-homepage` - Homepage (descending) * `vcs_browser` - Vcs browser * `-vcs_browser` - Vcs browser (descending) * `vcs_arch` - Vcs arch * `-vcs_arch` - Vcs arch (descending) * `vcs_bzr` - Vcs bzr * `-vcs_bzr` - Vcs bzr (descending) * `vcs_cvs` - Vcs cvs * `-vcs_cvs` - Vcs cvs (descending) * `vcs_darcs` - Vcs darcs * `-vcs_darcs` - Vcs darcs (descending) * `vcs_git` - Vcs git * `-vcs_git` - Vcs git (descending) * `vcs_hg` - Vcs hg * `-vcs_hg` - Vcs hg (descending) * `vcs_mtn` - Vcs mtn * `-vcs_mtn` - Vcs mtn (descending) * `vcs_snv` - Vcs snv * `-vcs_snv` - Vcs snv (descending) * `testsuite` - Testsuite * `-testsuite` - Testsuite (descending) * `dgit` - Dgit * `-dgit` - Dgit (descending) * `standards_version` - Standards version * `-standards_version` - Standards version (descending) * `build_depends` - Build depends * `-build_depends` - Build depends (descending) * `build_depends_indep` - Build depends indep * `-build_depends_indep` - Build depends indep (descending) * `build_depends_arch` - Build depends arch * `-build_depends_arch` - Build depends arch (descending) * `build_conflicts` - Build conflicts * `-build_conflicts` - Build conflicts (descending) * `build_conflicts_indep` - Build conflicts indep * `-build_conflicts_indep` - Build conflicts indep (descending) * `build_conflicts_arch` - Build conflicts arch * `-build_conflicts_arch` - Build conflicts arch (descending) * `package_list` - Package list * `-package_list` - Package list (descending) * `pk` - Pk * `-pk` - Pk (descending)
        :type ordering: List[str]
        :param orphaned_for: Minutes Content has been orphaned for. -1 uses ORPHAN_PROTECTION_TIME.
        :type orphaned_for: float
        :param package_list: Filter results where package_list matches value
        :type package_list: str
        :param prn__in: Multiple values may be separated by commas.
        :type prn__in: List[str]
        :param pulp_href__in: Multiple values may be separated by commas.
        :type pulp_href__in: List[str]
        :param pulp_id__in: Multiple values may be separated by commas.
        :type pulp_id__in: List[str]
        :param pulp_label_select: Filter labels by search string
        :type pulp_label_select: str
        :param q: Filter results by using NOT, AND and OR operations on other filters
        :type q: str
        :param relative_path: Filter results where relative_path matches value
        :type relative_path: str
        :param release:      Must be a comma-separated string: \"release_href,repository_or_repository_version_href\"     release_href: Filter results where SourcePackage in Release     repository_or_repository_version_href: The RepositoryVersion href to filter by, or Repository         href (assume latest version)     
        :type release: str
        :param release_component:      Must be a comma-separated string: \"release_component_href,repository_or_repository_version_href\"     release_component_href: Filter results where SourcePackage in ReleaseComponent     repository_or_repository_version_href: The RepositoryVersion href to filter by, or Repository         href (assume latest version)     
        :type release_component: str
        :param repository_version: Repository Version referenced by HREF/PRN
        :type repository_version: str
        :param repository_version_added: Repository Version referenced by HREF/PRN
        :type repository_version_added: str
        :param repository_version_removed: Repository Version referenced by HREF/PRN
        :type repository_version_removed: str
        :param source: Filter results where source matches value
        :type source: str
        :param standards_version: Filter results where standards_version matches value
        :type standards_version: str
        :param testsuite: Filter results where testsuite matches value
        :type testsuite: str
        :param uploaders: Filter results where uploaders matches value
        :type uploaders: str
        :param vcs_arch: Filter results where vcs_arch matches value
        :type vcs_arch: str
        :param vcs_browser: Filter results where vcs_browser matches value
        :type vcs_browser: str
        :param vcs_bzr: Filter results where vcs_bzr matches value
        :type vcs_bzr: str
        :param vcs_cvs: Filter results where vcs_cvs matches value
        :type vcs_cvs: str
        :param vcs_darcs: Filter results where vcs_darcs matches value
        :type vcs_darcs: str
        :param vcs_git: Filter results where vcs_git matches value
        :type vcs_git: str
        :param vcs_hg: Filter results where vcs_hg matches value
        :type vcs_hg: str
        :param vcs_mtn: Filter results where vcs_mtn matches value
        :type vcs_mtn: str
        :param vcs_snv: Filter results where vcs_snv matches value
        :type vcs_snv: str
        :param version: Filter results where version matches value
        :type version: str
        :param fields: A list of fields to include in the response.
        :type fields: List[str]
        :param exclude_fields: A list of fields to exclude from the response.
        :type exclude_fields: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_serialize(
            x_task_diagnostics=x_task_diagnostics,
            architecture=architecture,
            binary=binary,
            build_conflicts=build_conflicts,
            build_conflicts_arch=build_conflicts_arch,
            build_conflicts_indep=build_conflicts_indep,
            build_depends=build_depends,
            build_depends_arch=build_depends_arch,
            build_depends_indep=build_depends_indep,
            dgit=dgit,
            format=format,
            homepage=homepage,
            limit=limit,
            maintainer=maintainer,
            offset=offset,
            ordering=ordering,
            orphaned_for=orphaned_for,
            package_list=package_list,
            prn__in=prn__in,
            pulp_href__in=pulp_href__in,
            pulp_id__in=pulp_id__in,
            pulp_label_select=pulp_label_select,
            q=q,
            relative_path=relative_path,
            release=release,
            release_component=release_component,
            repository_version=repository_version,
            repository_version_added=repository_version_added,
            repository_version_removed=repository_version_removed,
            source=source,
            standards_version=standards_version,
            testsuite=testsuite,
            uploaders=uploaders,
            vcs_arch=vcs_arch,
            vcs_browser=vcs_browser,
            vcs_bzr=vcs_bzr,
            vcs_cvs=vcs_cvs,
            vcs_darcs=vcs_darcs,
            vcs_git=vcs_git,
            vcs_hg=vcs_hg,
            vcs_mtn=vcs_mtn,
            vcs_snv=vcs_snv,
            version=version,
            fields=fields,
            exclude_fields=exclude_fields,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PaginateddebSourcePackageResponseList",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def list_without_preload_content(
        self,
        x_task_diagnostics: Annotated[Optional[List[StrictStr]], Field(description="List of profilers to use on tasks.")] = None,
        architecture: Annotated[Optional[StrictStr], Field(description="Filter results where architecture matches value")] = None,
        binary: Annotated[Optional[StrictStr], Field(description="Filter results where binary matches value")] = None,
        build_conflicts: Annotated[Optional[StrictStr], Field(description="Filter results where build_conflicts matches value")] = None,
        build_conflicts_arch: Annotated[Optional[StrictStr], Field(description="Filter results where build_conflicts_arch matches value")] = None,
        build_conflicts_indep: Annotated[Optional[StrictStr], Field(description="Filter results where build_conflicts_indep matches value")] = None,
        build_depends: Annotated[Optional[StrictStr], Field(description="Filter results where build_depends matches value")] = None,
        build_depends_arch: Annotated[Optional[StrictStr], Field(description="Filter results where build_depends_arch matches value")] = None,
        build_depends_indep: Annotated[Optional[StrictStr], Field(description="Filter results where build_depends_indep matches value")] = None,
        dgit: Annotated[Optional[StrictStr], Field(description="Filter results where dgit matches value")] = None,
        format: Annotated[Optional[StrictStr], Field(description="Filter results where format matches value")] = None,
        homepage: Annotated[Optional[StrictStr], Field(description="Filter results where homepage matches value")] = None,
        limit: Annotated[Optional[StrictInt], Field(description="Number of results to return per page.")] = None,
        maintainer: Annotated[Optional[StrictStr], Field(description="Filter results where maintainer matches value")] = None,
        offset: Annotated[Optional[StrictInt], Field(description="The initial index from which to return the results.")] = None,
        ordering: Annotated[Optional[List[StrictStr]], Field(description="Ordering  * `pulp_id` - Pulp id * `-pulp_id` - Pulp id (descending) * `pulp_created` - Pulp created * `-pulp_created` - Pulp created (descending) * `pulp_last_updated` - Pulp last updated * `-pulp_last_updated` - Pulp last updated (descending) * `pulp_type` - Pulp type * `-pulp_type` - Pulp type (descending) * `upstream_id` - Upstream id * `-upstream_id` - Upstream id (descending) * `pulp_labels` - Pulp labels * `-pulp_labels` - Pulp labels (descending) * `timestamp_of_interest` - Timestamp of interest * `-timestamp_of_interest` - Timestamp of interest (descending) * `relative_path` - Relative path * `-relative_path` - Relative path (descending) * `format` - Format * `-format` - Format (descending) * `source` - Source * `-source` - Source (descending) * `binary` - Binary * `-binary` - Binary (descending) * `architecture` - Architecture * `-architecture` - Architecture (descending) * `version` - Version * `-version` - Version (descending) * `maintainer` - Maintainer * `-maintainer` - Maintainer (descending) * `uploaders` - Uploaders * `-uploaders` - Uploaders (descending) * `homepage` - Homepage * `-homepage` - Homepage (descending) * `vcs_browser` - Vcs browser * `-vcs_browser` - Vcs browser (descending) * `vcs_arch` - Vcs arch * `-vcs_arch` - Vcs arch (descending) * `vcs_bzr` - Vcs bzr * `-vcs_bzr` - Vcs bzr (descending) * `vcs_cvs` - Vcs cvs * `-vcs_cvs` - Vcs cvs (descending) * `vcs_darcs` - Vcs darcs * `-vcs_darcs` - Vcs darcs (descending) * `vcs_git` - Vcs git * `-vcs_git` - Vcs git (descending) * `vcs_hg` - Vcs hg * `-vcs_hg` - Vcs hg (descending) * `vcs_mtn` - Vcs mtn * `-vcs_mtn` - Vcs mtn (descending) * `vcs_snv` - Vcs snv * `-vcs_snv` - Vcs snv (descending) * `testsuite` - Testsuite * `-testsuite` - Testsuite (descending) * `dgit` - Dgit * `-dgit` - Dgit (descending) * `standards_version` - Standards version * `-standards_version` - Standards version (descending) * `build_depends` - Build depends * `-build_depends` - Build depends (descending) * `build_depends_indep` - Build depends indep * `-build_depends_indep` - Build depends indep (descending) * `build_depends_arch` - Build depends arch * `-build_depends_arch` - Build depends arch (descending) * `build_conflicts` - Build conflicts * `-build_conflicts` - Build conflicts (descending) * `build_conflicts_indep` - Build conflicts indep * `-build_conflicts_indep` - Build conflicts indep (descending) * `build_conflicts_arch` - Build conflicts arch * `-build_conflicts_arch` - Build conflicts arch (descending) * `package_list` - Package list * `-package_list` - Package list (descending) * `pk` - Pk * `-pk` - Pk (descending)")] = None,
        orphaned_for: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Minutes Content has been orphaned for. -1 uses ORPHAN_PROTECTION_TIME.")] = None,
        package_list: Annotated[Optional[StrictStr], Field(description="Filter results where package_list matches value")] = None,
        prn__in: Annotated[Optional[List[StrictStr]], Field(description="Multiple values may be separated by commas.")] = None,
        pulp_href__in: Annotated[Optional[List[StrictStr]], Field(description="Multiple values may be separated by commas.")] = None,
        pulp_id__in: Annotated[Optional[List[StrictStr]], Field(description="Multiple values may be separated by commas.")] = None,
        pulp_label_select: Annotated[Optional[StrictStr], Field(description="Filter labels by search string")] = None,
        q: Annotated[Optional[StrictStr], Field(description="Filter results by using NOT, AND and OR operations on other filters")] = None,
        relative_path: Annotated[Optional[StrictStr], Field(description="Filter results where relative_path matches value")] = None,
        release: Annotated[Optional[StrictStr], Field(description="     Must be a comma-separated string: \"release_href,repository_or_repository_version_href\"     release_href: Filter results where SourcePackage in Release     repository_or_repository_version_href: The RepositoryVersion href to filter by, or Repository         href (assume latest version)     ")] = None,
        release_component: Annotated[Optional[StrictStr], Field(description="     Must be a comma-separated string: \"release_component_href,repository_or_repository_version_href\"     release_component_href: Filter results where SourcePackage in ReleaseComponent     repository_or_repository_version_href: The RepositoryVersion href to filter by, or Repository         href (assume latest version)     ")] = None,
        repository_version: Annotated[Optional[StrictStr], Field(description="Repository Version referenced by HREF/PRN")] = None,
        repository_version_added: Annotated[Optional[StrictStr], Field(description="Repository Version referenced by HREF/PRN")] = None,
        repository_version_removed: Annotated[Optional[StrictStr], Field(description="Repository Version referenced by HREF/PRN")] = None,
        source: Annotated[Optional[StrictStr], Field(description="Filter results where source matches value")] = None,
        standards_version: Annotated[Optional[StrictStr], Field(description="Filter results where standards_version matches value")] = None,
        testsuite: Annotated[Optional[StrictStr], Field(description="Filter results where testsuite matches value")] = None,
        uploaders: Annotated[Optional[StrictStr], Field(description="Filter results where uploaders matches value")] = None,
        vcs_arch: Annotated[Optional[StrictStr], Field(description="Filter results where vcs_arch matches value")] = None,
        vcs_browser: Annotated[Optional[StrictStr], Field(description="Filter results where vcs_browser matches value")] = None,
        vcs_bzr: Annotated[Optional[StrictStr], Field(description="Filter results where vcs_bzr matches value")] = None,
        vcs_cvs: Annotated[Optional[StrictStr], Field(description="Filter results where vcs_cvs matches value")] = None,
        vcs_darcs: Annotated[Optional[StrictStr], Field(description="Filter results where vcs_darcs matches value")] = None,
        vcs_git: Annotated[Optional[StrictStr], Field(description="Filter results where vcs_git matches value")] = None,
        vcs_hg: Annotated[Optional[StrictStr], Field(description="Filter results where vcs_hg matches value")] = None,
        vcs_mtn: Annotated[Optional[StrictStr], Field(description="Filter results where vcs_mtn matches value")] = None,
        vcs_snv: Annotated[Optional[StrictStr], Field(description="Filter results where vcs_snv matches value")] = None,
        version: Annotated[Optional[StrictStr], Field(description="Filter results where version matches value")] = None,
        fields: Annotated[Optional[List[StrictStr]], Field(description="A list of fields to include in the response.")] = None,
        exclude_fields: Annotated[Optional[List[StrictStr]], Field(description="A list of fields to exclude from the response.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """List source packages

        A Debian Source Package file represents a '.dsc' file along with its associated artifacts such as orig.tar.gz, debian.tar.gz...  Associated artifacts: Exactly one '.dsc' file.

        :param x_task_diagnostics: List of profilers to use on tasks.
        :type x_task_diagnostics: List[str]
        :param architecture: Filter results where architecture matches value
        :type architecture: str
        :param binary: Filter results where binary matches value
        :type binary: str
        :param build_conflicts: Filter results where build_conflicts matches value
        :type build_conflicts: str
        :param build_conflicts_arch: Filter results where build_conflicts_arch matches value
        :type build_conflicts_arch: str
        :param build_conflicts_indep: Filter results where build_conflicts_indep matches value
        :type build_conflicts_indep: str
        :param build_depends: Filter results where build_depends matches value
        :type build_depends: str
        :param build_depends_arch: Filter results where build_depends_arch matches value
        :type build_depends_arch: str
        :param build_depends_indep: Filter results where build_depends_indep matches value
        :type build_depends_indep: str
        :param dgit: Filter results where dgit matches value
        :type dgit: str
        :param format: Filter results where format matches value
        :type format: str
        :param homepage: Filter results where homepage matches value
        :type homepage: str
        :param limit: Number of results to return per page.
        :type limit: int
        :param maintainer: Filter results where maintainer matches value
        :type maintainer: str
        :param offset: The initial index from which to return the results.
        :type offset: int
        :param ordering: Ordering  * `pulp_id` - Pulp id * `-pulp_id` - Pulp id (descending) * `pulp_created` - Pulp created * `-pulp_created` - Pulp created (descending) * `pulp_last_updated` - Pulp last updated * `-pulp_last_updated` - Pulp last updated (descending) * `pulp_type` - Pulp type * `-pulp_type` - Pulp type (descending) * `upstream_id` - Upstream id * `-upstream_id` - Upstream id (descending) * `pulp_labels` - Pulp labels * `-pulp_labels` - Pulp labels (descending) * `timestamp_of_interest` - Timestamp of interest * `-timestamp_of_interest` - Timestamp of interest (descending) * `relative_path` - Relative path * `-relative_path` - Relative path (descending) * `format` - Format * `-format` - Format (descending) * `source` - Source * `-source` - Source (descending) * `binary` - Binary * `-binary` - Binary (descending) * `architecture` - Architecture * `-architecture` - Architecture (descending) * `version` - Version * `-version` - Version (descending) * `maintainer` - Maintainer * `-maintainer` - Maintainer (descending) * `uploaders` - Uploaders * `-uploaders` - Uploaders (descending) * `homepage` - Homepage * `-homepage` - Homepage (descending) * `vcs_browser` - Vcs browser * `-vcs_browser` - Vcs browser (descending) * `vcs_arch` - Vcs arch * `-vcs_arch` - Vcs arch (descending) * `vcs_bzr` - Vcs bzr * `-vcs_bzr` - Vcs bzr (descending) * `vcs_cvs` - Vcs cvs * `-vcs_cvs` - Vcs cvs (descending) * `vcs_darcs` - Vcs darcs * `-vcs_darcs` - Vcs darcs (descending) * `vcs_git` - Vcs git * `-vcs_git` - Vcs git (descending) * `vcs_hg` - Vcs hg * `-vcs_hg` - Vcs hg (descending) * `vcs_mtn` - Vcs mtn * `-vcs_mtn` - Vcs mtn (descending) * `vcs_snv` - Vcs snv * `-vcs_snv` - Vcs snv (descending) * `testsuite` - Testsuite * `-testsuite` - Testsuite (descending) * `dgit` - Dgit * `-dgit` - Dgit (descending) * `standards_version` - Standards version * `-standards_version` - Standards version (descending) * `build_depends` - Build depends * `-build_depends` - Build depends (descending) * `build_depends_indep` - Build depends indep * `-build_depends_indep` - Build depends indep (descending) * `build_depends_arch` - Build depends arch * `-build_depends_arch` - Build depends arch (descending) * `build_conflicts` - Build conflicts * `-build_conflicts` - Build conflicts (descending) * `build_conflicts_indep` - Build conflicts indep * `-build_conflicts_indep` - Build conflicts indep (descending) * `build_conflicts_arch` - Build conflicts arch * `-build_conflicts_arch` - Build conflicts arch (descending) * `package_list` - Package list * `-package_list` - Package list (descending) * `pk` - Pk * `-pk` - Pk (descending)
        :type ordering: List[str]
        :param orphaned_for: Minutes Content has been orphaned for. -1 uses ORPHAN_PROTECTION_TIME.
        :type orphaned_for: float
        :param package_list: Filter results where package_list matches value
        :type package_list: str
        :param prn__in: Multiple values may be separated by commas.
        :type prn__in: List[str]
        :param pulp_href__in: Multiple values may be separated by commas.
        :type pulp_href__in: List[str]
        :param pulp_id__in: Multiple values may be separated by commas.
        :type pulp_id__in: List[str]
        :param pulp_label_select: Filter labels by search string
        :type pulp_label_select: str
        :param q: Filter results by using NOT, AND and OR operations on other filters
        :type q: str
        :param relative_path: Filter results where relative_path matches value
        :type relative_path: str
        :param release:      Must be a comma-separated string: \"release_href,repository_or_repository_version_href\"     release_href: Filter results where SourcePackage in Release     repository_or_repository_version_href: The RepositoryVersion href to filter by, or Repository         href (assume latest version)     
        :type release: str
        :param release_component:      Must be a comma-separated string: \"release_component_href,repository_or_repository_version_href\"     release_component_href: Filter results where SourcePackage in ReleaseComponent     repository_or_repository_version_href: The RepositoryVersion href to filter by, or Repository         href (assume latest version)     
        :type release_component: str
        :param repository_version: Repository Version referenced by HREF/PRN
        :type repository_version: str
        :param repository_version_added: Repository Version referenced by HREF/PRN
        :type repository_version_added: str
        :param repository_version_removed: Repository Version referenced by HREF/PRN
        :type repository_version_removed: str
        :param source: Filter results where source matches value
        :type source: str
        :param standards_version: Filter results where standards_version matches value
        :type standards_version: str
        :param testsuite: Filter results where testsuite matches value
        :type testsuite: str
        :param uploaders: Filter results where uploaders matches value
        :type uploaders: str
        :param vcs_arch: Filter results where vcs_arch matches value
        :type vcs_arch: str
        :param vcs_browser: Filter results where vcs_browser matches value
        :type vcs_browser: str
        :param vcs_bzr: Filter results where vcs_bzr matches value
        :type vcs_bzr: str
        :param vcs_cvs: Filter results where vcs_cvs matches value
        :type vcs_cvs: str
        :param vcs_darcs: Filter results where vcs_darcs matches value
        :type vcs_darcs: str
        :param vcs_git: Filter results where vcs_git matches value
        :type vcs_git: str
        :param vcs_hg: Filter results where vcs_hg matches value
        :type vcs_hg: str
        :param vcs_mtn: Filter results where vcs_mtn matches value
        :type vcs_mtn: str
        :param vcs_snv: Filter results where vcs_snv matches value
        :type vcs_snv: str
        :param version: Filter results where version matches value
        :type version: str
        :param fields: A list of fields to include in the response.
        :type fields: List[str]
        :param exclude_fields: A list of fields to exclude from the response.
        :type exclude_fields: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_serialize(
            x_task_diagnostics=x_task_diagnostics,
            architecture=architecture,
            binary=binary,
            build_conflicts=build_conflicts,
            build_conflicts_arch=build_conflicts_arch,
            build_conflicts_indep=build_conflicts_indep,
            build_depends=build_depends,
            build_depends_arch=build_depends_arch,
            build_depends_indep=build_depends_indep,
            dgit=dgit,
            format=format,
            homepage=homepage,
            limit=limit,
            maintainer=maintainer,
            offset=offset,
            ordering=ordering,
            orphaned_for=orphaned_for,
            package_list=package_list,
            prn__in=prn__in,
            pulp_href__in=pulp_href__in,
            pulp_id__in=pulp_id__in,
            pulp_label_select=pulp_label_select,
            q=q,
            relative_path=relative_path,
            release=release,
            release_component=release_component,
            repository_version=repository_version,
            repository_version_added=repository_version_added,
            repository_version_removed=repository_version_removed,
            source=source,
            standards_version=standards_version,
            testsuite=testsuite,
            uploaders=uploaders,
            vcs_arch=vcs_arch,
            vcs_browser=vcs_browser,
            vcs_bzr=vcs_bzr,
            vcs_cvs=vcs_cvs,
            vcs_darcs=vcs_darcs,
            vcs_git=vcs_git,
            vcs_hg=vcs_hg,
            vcs_mtn=vcs_mtn,
            vcs_snv=vcs_snv,
            version=version,
            fields=fields,
            exclude_fields=exclude_fields,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PaginateddebSourcePackageResponseList",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _list_serialize(
        self,
        x_task_diagnostics,
        architecture,
        binary,
        build_conflicts,
        build_conflicts_arch,
        build_conflicts_indep,
        build_depends,
        build_depends_arch,
        build_depends_indep,
        dgit,
        format,
        homepage,
        limit,
        maintainer,
        offset,
        ordering,
        orphaned_for,
        package_list,
        prn__in,
        pulp_href__in,
        pulp_id__in,
        pulp_label_select,
        q,
        relative_path,
        release,
        release_component,
        repository_version,
        repository_version_added,
        repository_version_removed,
        source,
        standards_version,
        testsuite,
        uploaders,
        vcs_arch,
        vcs_browser,
        vcs_bzr,
        vcs_cvs,
        vcs_darcs,
        vcs_git,
        vcs_hg,
        vcs_mtn,
        vcs_snv,
        version,
        fields,
        exclude_fields,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'X-Task-Diagnostics': 'csv',
            'ordering': 'csv',
            'prn__in': 'csv',
            'pulp_href__in': 'csv',
            'pulp_id__in': 'csv',
            'fields': 'multi',
            'exclude_fields': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if architecture is not None:
            
            _query_params.append(('architecture', architecture))
            
        if binary is not None:
            
            _query_params.append(('binary', binary))
            
        if build_conflicts is not None:
            
            _query_params.append(('build_conflicts', build_conflicts))
            
        if build_conflicts_arch is not None:
            
            _query_params.append(('build_conflicts_arch', build_conflicts_arch))
            
        if build_conflicts_indep is not None:
            
            _query_params.append(('build_conflicts_indep', build_conflicts_indep))
            
        if build_depends is not None:
            
            _query_params.append(('build_depends', build_depends))
            
        if build_depends_arch is not None:
            
            _query_params.append(('build_depends_arch', build_depends_arch))
            
        if build_depends_indep is not None:
            
            _query_params.append(('build_depends_indep', build_depends_indep))
            
        if dgit is not None:
            
            _query_params.append(('dgit', dgit))
            
        if format is not None:
            
            _query_params.append(('format', format))
            
        if homepage is not None:
            
            _query_params.append(('homepage', homepage))
            
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        if maintainer is not None:
            
            _query_params.append(('maintainer', maintainer))
            
        if offset is not None:
            
            _query_params.append(('offset', offset))
            
        if ordering is not None:
            
            _query_params.append(('ordering', ordering))
            
        if orphaned_for is not None:
            
            _query_params.append(('orphaned_for', orphaned_for))
            
        if package_list is not None:
            
            _query_params.append(('package_list', package_list))
            
        if prn__in is not None:
            
            _query_params.append(('prn__in', prn__in))
            
        if pulp_href__in is not None:
            
            _query_params.append(('pulp_href__in', pulp_href__in))
            
        if pulp_id__in is not None:
            
            _query_params.append(('pulp_id__in', pulp_id__in))
            
        if pulp_label_select is not None:
            
            _query_params.append(('pulp_label_select', pulp_label_select))
            
        if q is not None:
            
            _query_params.append(('q', q))
            
        if relative_path is not None:
            
            _query_params.append(('relative_path', relative_path))
            
        if release is not None:
            
            _query_params.append(('release', release))
            
        if release_component is not None:
            
            _query_params.append(('release_component', release_component))
            
        if repository_version is not None:
            
            _query_params.append(('repository_version', repository_version))
            
        if repository_version_added is not None:
            
            _query_params.append(('repository_version_added', repository_version_added))
            
        if repository_version_removed is not None:
            
            _query_params.append(('repository_version_removed', repository_version_removed))
            
        if source is not None:
            
            _query_params.append(('source', source))
            
        if standards_version is not None:
            
            _query_params.append(('standards_version', standards_version))
            
        if testsuite is not None:
            
            _query_params.append(('testsuite', testsuite))
            
        if uploaders is not None:
            
            _query_params.append(('uploaders', uploaders))
            
        if vcs_arch is not None:
            
            _query_params.append(('vcs_arch', vcs_arch))
            
        if vcs_browser is not None:
            
            _query_params.append(('vcs_browser', vcs_browser))
            
        if vcs_bzr is not None:
            
            _query_params.append(('vcs_bzr', vcs_bzr))
            
        if vcs_cvs is not None:
            
            _query_params.append(('vcs_cvs', vcs_cvs))
            
        if vcs_darcs is not None:
            
            _query_params.append(('vcs_darcs', vcs_darcs))
            
        if vcs_git is not None:
            
            _query_params.append(('vcs_git', vcs_git))
            
        if vcs_hg is not None:
            
            _query_params.append(('vcs_hg', vcs_hg))
            
        if vcs_mtn is not None:
            
            _query_params.append(('vcs_mtn', vcs_mtn))
            
        if vcs_snv is not None:
            
            _query_params.append(('vcs_snv', vcs_snv))
            
        if version is not None:
            
            _query_params.append(('version', version))
            
        if fields is not None:
            
            _query_params.append(('fields', fields))
            
        if exclude_fields is not None:
            
            _query_params.append(('exclude_fields', exclude_fields))
            
        # process the header parameters
        if x_task_diagnostics is not None:
            _header_params['X-Task-Diagnostics'] = x_task_diagnostics
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'basicAuth', 
            'cookieAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/pulp/api/v3/content/deb/source_packages/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def read(
        self,
        deb_source_package_href: StrictStr,
        x_task_diagnostics: Annotated[Optional[List[StrictStr]], Field(description="List of profilers to use on tasks.")] = None,
        fields: Annotated[Optional[List[StrictStr]], Field(description="A list of fields to include in the response.")] = None,
        exclude_fields: Annotated[Optional[List[StrictStr]], Field(description="A list of fields to exclude from the response.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> DebSourcePackageResponse:
        """Inspect a source package

        A Debian Source Package file represents a '.dsc' file along with its associated artifacts such as orig.tar.gz, debian.tar.gz...  Associated artifacts: Exactly one '.dsc' file.

        :param deb_source_package_href: (required)
        :type deb_source_package_href: str
        :param x_task_diagnostics: List of profilers to use on tasks.
        :type x_task_diagnostics: List[str]
        :param fields: A list of fields to include in the response.
        :type fields: List[str]
        :param exclude_fields: A list of fields to exclude from the response.
        :type exclude_fields: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._read_serialize(
            deb_source_package_href=deb_source_package_href,
            x_task_diagnostics=x_task_diagnostics,
            fields=fields,
            exclude_fields=exclude_fields,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DebSourcePackageResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def read_with_http_info(
        self,
        deb_source_package_href: StrictStr,
        x_task_diagnostics: Annotated[Optional[List[StrictStr]], Field(description="List of profilers to use on tasks.")] = None,
        fields: Annotated[Optional[List[StrictStr]], Field(description="A list of fields to include in the response.")] = None,
        exclude_fields: Annotated[Optional[List[StrictStr]], Field(description="A list of fields to exclude from the response.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[DebSourcePackageResponse]:
        """Inspect a source package

        A Debian Source Package file represents a '.dsc' file along with its associated artifacts such as orig.tar.gz, debian.tar.gz...  Associated artifacts: Exactly one '.dsc' file.

        :param deb_source_package_href: (required)
        :type deb_source_package_href: str
        :param x_task_diagnostics: List of profilers to use on tasks.
        :type x_task_diagnostics: List[str]
        :param fields: A list of fields to include in the response.
        :type fields: List[str]
        :param exclude_fields: A list of fields to exclude from the response.
        :type exclude_fields: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._read_serialize(
            deb_source_package_href=deb_source_package_href,
            x_task_diagnostics=x_task_diagnostics,
            fields=fields,
            exclude_fields=exclude_fields,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DebSourcePackageResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def read_without_preload_content(
        self,
        deb_source_package_href: StrictStr,
        x_task_diagnostics: Annotated[Optional[List[StrictStr]], Field(description="List of profilers to use on tasks.")] = None,
        fields: Annotated[Optional[List[StrictStr]], Field(description="A list of fields to include in the response.")] = None,
        exclude_fields: Annotated[Optional[List[StrictStr]], Field(description="A list of fields to exclude from the response.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Inspect a source package

        A Debian Source Package file represents a '.dsc' file along with its associated artifacts such as orig.tar.gz, debian.tar.gz...  Associated artifacts: Exactly one '.dsc' file.

        :param deb_source_package_href: (required)
        :type deb_source_package_href: str
        :param x_task_diagnostics: List of profilers to use on tasks.
        :type x_task_diagnostics: List[str]
        :param fields: A list of fields to include in the response.
        :type fields: List[str]
        :param exclude_fields: A list of fields to exclude from the response.
        :type exclude_fields: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._read_serialize(
            deb_source_package_href=deb_source_package_href,
            x_task_diagnostics=x_task_diagnostics,
            fields=fields,
            exclude_fields=exclude_fields,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DebSourcePackageResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _read_serialize(
        self,
        deb_source_package_href,
        x_task_diagnostics,
        fields,
        exclude_fields,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'X-Task-Diagnostics': 'csv',
            'fields': 'multi',
            'exclude_fields': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if deb_source_package_href is not None:
            _path_params['deb_source_package_href'] = deb_source_package_href
        # process the query parameters
        if fields is not None:
            
            _query_params.append(('fields', fields))
            
        if exclude_fields is not None:
            
            _query_params.append(('exclude_fields', exclude_fields))
            
        # process the header parameters
        if x_task_diagnostics is not None:
            _header_params['X-Task-Diagnostics'] = x_task_diagnostics
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'basicAuth', 
            'cookieAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='{deb_source_package_href}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def set_label(
        self,
        deb_source_package_href: StrictStr,
        set_label: SetLabel,
        x_task_diagnostics: Annotated[Optional[List[StrictStr]], Field(description="List of profilers to use on tasks.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> SetLabelResponse:
        """Set a label

        Set a single pulp_label on the object to a specific value or null.

        :param deb_source_package_href: (required)
        :type deb_source_package_href: str
        :param set_label: (required)
        :type set_label: SetLabel
        :param x_task_diagnostics: List of profilers to use on tasks.
        :type x_task_diagnostics: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._set_label_serialize(
            deb_source_package_href=deb_source_package_href,
            set_label=set_label,
            x_task_diagnostics=x_task_diagnostics,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "SetLabelResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def set_label_with_http_info(
        self,
        deb_source_package_href: StrictStr,
        set_label: SetLabel,
        x_task_diagnostics: Annotated[Optional[List[StrictStr]], Field(description="List of profilers to use on tasks.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[SetLabelResponse]:
        """Set a label

        Set a single pulp_label on the object to a specific value or null.

        :param deb_source_package_href: (required)
        :type deb_source_package_href: str
        :param set_label: (required)
        :type set_label: SetLabel
        :param x_task_diagnostics: List of profilers to use on tasks.
        :type x_task_diagnostics: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._set_label_serialize(
            deb_source_package_href=deb_source_package_href,
            set_label=set_label,
            x_task_diagnostics=x_task_diagnostics,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "SetLabelResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def set_label_without_preload_content(
        self,
        deb_source_package_href: StrictStr,
        set_label: SetLabel,
        x_task_diagnostics: Annotated[Optional[List[StrictStr]], Field(description="List of profilers to use on tasks.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Set a label

        Set a single pulp_label on the object to a specific value or null.

        :param deb_source_package_href: (required)
        :type deb_source_package_href: str
        :param set_label: (required)
        :type set_label: SetLabel
        :param x_task_diagnostics: List of profilers to use on tasks.
        :type x_task_diagnostics: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._set_label_serialize(
            deb_source_package_href=deb_source_package_href,
            set_label=set_label,
            x_task_diagnostics=x_task_diagnostics,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "SetLabelResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _set_label_serialize(
        self,
        deb_source_package_href,
        set_label,
        x_task_diagnostics,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'X-Task-Diagnostics': 'csv',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if deb_source_package_href is not None:
            _path_params['deb_source_package_href'] = deb_source_package_href
        # process the query parameters
        # process the header parameters
        if x_task_diagnostics is not None:
            _header_params['X-Task-Diagnostics'] = x_task_diagnostics
        # process the form parameters
        # process the body parameter
        if set_label is not None:
            _body_params = set_label


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'basicAuth', 
            'cookieAuth'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='{deb_source_package_href}set_label/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def unset_label(
        self,
        deb_source_package_href: StrictStr,
        unset_label: UnsetLabel,
        x_task_diagnostics: Annotated[Optional[List[StrictStr]], Field(description="List of profilers to use on tasks.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> UnsetLabelResponse:
        """Unset a label

        Unset a single pulp_label on the object.

        :param deb_source_package_href: (required)
        :type deb_source_package_href: str
        :param unset_label: (required)
        :type unset_label: UnsetLabel
        :param x_task_diagnostics: List of profilers to use on tasks.
        :type x_task_diagnostics: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._unset_label_serialize(
            deb_source_package_href=deb_source_package_href,
            unset_label=unset_label,
            x_task_diagnostics=x_task_diagnostics,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "UnsetLabelResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def unset_label_with_http_info(
        self,
        deb_source_package_href: StrictStr,
        unset_label: UnsetLabel,
        x_task_diagnostics: Annotated[Optional[List[StrictStr]], Field(description="List of profilers to use on tasks.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[UnsetLabelResponse]:
        """Unset a label

        Unset a single pulp_label on the object.

        :param deb_source_package_href: (required)
        :type deb_source_package_href: str
        :param unset_label: (required)
        :type unset_label: UnsetLabel
        :param x_task_diagnostics: List of profilers to use on tasks.
        :type x_task_diagnostics: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._unset_label_serialize(
            deb_source_package_href=deb_source_package_href,
            unset_label=unset_label,
            x_task_diagnostics=x_task_diagnostics,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "UnsetLabelResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def unset_label_without_preload_content(
        self,
        deb_source_package_href: StrictStr,
        unset_label: UnsetLabel,
        x_task_diagnostics: Annotated[Optional[List[StrictStr]], Field(description="List of profilers to use on tasks.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Unset a label

        Unset a single pulp_label on the object.

        :param deb_source_package_href: (required)
        :type deb_source_package_href: str
        :param unset_label: (required)
        :type unset_label: UnsetLabel
        :param x_task_diagnostics: List of profilers to use on tasks.
        :type x_task_diagnostics: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._unset_label_serialize(
            deb_source_package_href=deb_source_package_href,
            unset_label=unset_label,
            x_task_diagnostics=x_task_diagnostics,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "UnsetLabelResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _unset_label_serialize(
        self,
        deb_source_package_href,
        unset_label,
        x_task_diagnostics,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'X-Task-Diagnostics': 'csv',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if deb_source_package_href is not None:
            _path_params['deb_source_package_href'] = deb_source_package_href
        # process the query parameters
        # process the header parameters
        if x_task_diagnostics is not None:
            _header_params['X-Task-Diagnostics'] = x_task_diagnostics
        # process the form parameters
        # process the body parameter
        if unset_label is not None:
            _body_params = unset_label


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'basicAuth', 
            'cookieAuth'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='{deb_source_package_href}unset_label/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


