# coding: utf-8

"""
    Pulp 3 API

    Fetch, Upload, Organize, and Distribute Software Packages

    The version of the OpenAPI document: v3
    Contact: pulp-list@redhat.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self


class OneOf:
    @staticmethod
    def from_dict(obj, *args, **kwargs):
        """Noop override to fix missing OneOf import/implementation."""
        return obj


class DebSourcePackageResponse(BaseModel):
    """
    A Serializer for DscFile.
    """ # noqa: E501
    pulp_href: Optional[StrictStr] = None
    prn: Optional[StrictStr] = Field(default=None, description="The Pulp Resource Name (PRN).")
    pulp_created: Optional[datetime] = Field(default=None, description="Timestamp of creation.")
    pulp_last_updated: Optional[datetime] = Field(default=None, description="Timestamp of the last time this resource was updated. Note: for immutable resources - like content, repository versions, and publication - pulp_created and pulp_last_updated dates will be the same.")
    pulp_labels: Optional[Dict[str, Optional[StrictStr]]] = Field(default=None, description="A dictionary of arbitrary key/value pairs used to describe a specific Content instance.")
    vuln_report: Optional[StrictStr] = None
    artifacts: Dict[str, Any] = Field(description="A dict mapping relative paths inside the Content to the correspondingArtifact URLs. E.g.: {'relative/path': '/artifacts/1/'")
    relative_path: Optional[StrictStr] = Field(default=None, description="Relative path of the Debian Source Control (dsc) file.It is normally advised to let Pulp generate this.")
    sha256: Optional[StrictStr] = Field(default=None, description="sha256 digest of the dsc file.")
    format: Optional[StrictStr] = None
    source: Optional[StrictStr] = None
    binary: Optional[StrictStr] = None
    architecture: Optional[StrictStr] = None
    version: Optional[StrictStr] = None
    maintainer: Optional[StrictStr] = None
    uploaders: Optional[StrictStr] = None
    homepage: Optional[StrictStr] = None
    vcs_browser: Optional[StrictStr] = None
    vcs_arch: Optional[StrictStr] = None
    vcs_bzr: Optional[StrictStr] = None
    vcs_cvs: Optional[StrictStr] = None
    vcs_darcs: Optional[StrictStr] = None
    vcs_git: Optional[StrictStr] = None
    vcs_hg: Optional[StrictStr] = None
    vcs_mtn: Optional[StrictStr] = None
    vcs_snv: Optional[StrictStr] = None
    testsuite: Optional[StrictStr] = None
    dgit: Optional[StrictStr] = None
    standards_version: Optional[StrictStr] = None
    build_depends: Optional[StrictStr] = None
    build_depends_indep: Optional[StrictStr] = None
    build_depends_arch: Optional[StrictStr] = None
    build_conflicts: Optional[StrictStr] = None
    build_conflicts_indep: Optional[StrictStr] = None
    build_conflicts_arch: Optional[StrictStr] = None
    package_list: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["pulp_href", "prn", "pulp_created", "pulp_last_updated", "pulp_labels", "vuln_report", "artifacts", "relative_path", "sha256", "format", "source", "binary", "architecture", "version", "maintainer", "uploaders", "homepage", "vcs_browser", "vcs_arch", "vcs_bzr", "vcs_cvs", "vcs_darcs", "vcs_git", "vcs_hg", "vcs_mtn", "vcs_snv", "testsuite", "dgit", "standards_version", "build_depends", "build_depends_indep", "build_depends_arch", "build_conflicts", "build_conflicts_indep", "build_conflicts_arch", "package_list"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DebSourcePackageResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "pulp_href",
            "prn",
            "pulp_created",
            "pulp_last_updated",
            "vuln_report",
            "artifacts",
            "sha256",
            "format",
            "source",
            "binary",
            "architecture",
            "version",
            "maintainer",
            "uploaders",
            "homepage",
            "vcs_browser",
            "vcs_arch",
            "vcs_bzr",
            "vcs_cvs",
            "vcs_darcs",
            "vcs_git",
            "vcs_hg",
            "vcs_mtn",
            "vcs_snv",
            "testsuite",
            "dgit",
            "standards_version",
            "build_depends",
            "build_depends_indep",
            "build_depends_arch",
            "build_conflicts",
            "build_conflicts_indep",
            "build_conflicts_arch",
            "package_list",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DebSourcePackageResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "pulp_href": obj.get("pulp_href"),
            "prn": obj.get("prn"),
            "pulp_created": obj.get("pulp_created"),
            "pulp_last_updated": obj.get("pulp_last_updated"),
            "pulp_labels": obj.get("pulp_labels"),
            "vuln_report": obj.get("vuln_report"),
            "artifacts": obj.get("artifacts"),
            "relative_path": obj.get("relative_path"),
            "sha256": obj.get("sha256"),
            "format": obj.get("format"),
            "source": obj.get("source"),
            "binary": obj.get("binary"),
            "architecture": obj.get("architecture"),
            "version": obj.get("version"),
            "maintainer": obj.get("maintainer"),
            "uploaders": obj.get("uploaders"),
            "homepage": obj.get("homepage"),
            "vcs_browser": obj.get("vcs_browser"),
            "vcs_arch": obj.get("vcs_arch"),
            "vcs_bzr": obj.get("vcs_bzr"),
            "vcs_cvs": obj.get("vcs_cvs"),
            "vcs_darcs": obj.get("vcs_darcs"),
            "vcs_git": obj.get("vcs_git"),
            "vcs_hg": obj.get("vcs_hg"),
            "vcs_mtn": obj.get("vcs_mtn"),
            "vcs_snv": obj.get("vcs_snv"),
            "testsuite": obj.get("testsuite"),
            "dgit": obj.get("dgit"),
            "standards_version": obj.get("standards_version"),
            "build_depends": obj.get("build_depends"),
            "build_depends_indep": obj.get("build_depends_indep"),
            "build_depends_arch": obj.get("build_depends_arch"),
            "build_conflicts": obj.get("build_conflicts"),
            "build_conflicts_indep": obj.get("build_conflicts_indep"),
            "build_conflicts_arch": obj.get("build_conflicts_arch"),
            "package_list": obj.get("package_list")
        })
        return _obj


