#!/usr/bin/env python
# -*- coding: utf-8 -*-
# vim: nu:ai:ts=4:sw=4

#
#  Copyright (C) 2025 Joseph Areeda <joseph.areeda@ligo.org>
#
#  This program is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
"""
Functions that interact with condor to manage our jobs
"""

__author__ = 'joseph areeda'
__email__ = 'joseph.areeda@ligo.org'

import htcondor, classad

def query_by_name(name, schedd=None, projection=["ClusterId", "ProcId", "JobBatchName", "JobStatus"],):
    """
    Query the schedd for the value of a classad attribute
    :param str name: regex pattern to match against JobBatchName. EG: '.*online.*PEM1.*'
    :param htcondor.Schedd schedd: schedd to query
    :param list[str] projection: list of classad attributes to query for,
                                 defaults to ["ClusterId", "ProcId", "JobBatchName", "JobStatus"]
    :return: list of matching Jobs
    """
    if schedd is None:
        schedd = htcondor.Schedd()

    constraint = f'regexp("{name}", JobBatchName)'
    ret = schedd.query(projection=projection, constraint=constraint)
    return ret