# coding: utf-8

"""
Jaqpot API

A modern RESTful API for model management and prediction services, built using Spring Boot and Kotlin. Supports seamless integration with machine learning workflows.

The version of the OpenAPI document: 1.0.0
Contact: upci.ntua@gmail.com
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import (
    BaseModel,
    ConfigDict,
    Field,
    StrictBool,
    StrictInt,
    StrictStr,
    field_validator,
)
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from jaqpotpy.api.openapi.models.organization_user import OrganizationUser
from jaqpotpy.api.openapi.models.organization_visibility import OrganizationVisibility
from jaqpotpy.api.openapi.models.user import User
from typing import Optional, Set
from typing_extensions import Self


class Organization(BaseModel):
    """
    Organization
    """  # noqa: E501

    id: Optional[StrictInt] = None
    name: Annotated[str, Field(min_length=3, strict=True, max_length=200)]
    creator: Optional[User] = None
    visibility: OrganizationVisibility
    description: Optional[
        Annotated[str, Field(min_length=3, strict=True, max_length=2000)]
    ] = None
    organization_members: Optional[List[OrganizationUser]] = Field(
        default=None, alias="organizationMembers"
    )
    contact_email: StrictStr = Field(alias="contactEmail")
    contact_phone: Optional[StrictStr] = Field(default=None, alias="contactPhone")
    website: Optional[StrictStr] = None
    address: Optional[StrictStr] = None
    can_edit: Optional[StrictBool] = Field(
        default=None,
        description="If the current user can edit the organization",
        alias="canEdit",
    )
    is_member: Optional[StrictBool] = Field(
        default=None,
        description="If the current user is a member of the organization",
        alias="isMember",
    )
    created_at: Optional[datetime] = None
    updated_at: Optional[datetime] = None
    __properties: ClassVar[List[str]] = [
        "id",
        "name",
        "creator",
        "visibility",
        "description",
        "organizationMembers",
        "contactEmail",
        "contactPhone",
        "website",
        "address",
        "canEdit",
        "isMember",
        "created_at",
        "updated_at",
    ]

    @field_validator("name")
    def name_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"[\w\-_]+", value):
            raise ValueError(r"must validate the regular expression /[\w\-_]+/")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Organization from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of creator
        if self.creator:
            _dict["creator"] = self.creator.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in organization_members (list)
        _items = []
        if self.organization_members:
            for _item_organization_members in self.organization_members:
                if _item_organization_members:
                    _items.append(_item_organization_members.to_dict())
            _dict["organizationMembers"] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Organization from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "id": obj.get("id"),
                "name": obj.get("name"),
                "creator": User.from_dict(obj["creator"])
                if obj.get("creator") is not None
                else None,
                "visibility": obj.get("visibility"),
                "description": obj.get("description"),
                "organizationMembers": [
                    OrganizationUser.from_dict(_item)
                    for _item in obj["organizationMembers"]
                ]
                if obj.get("organizationMembers") is not None
                else None,
                "contactEmail": obj.get("contactEmail"),
                "contactPhone": obj.get("contactPhone"),
                "website": obj.get("website"),
                "address": obj.get("address"),
                "canEdit": obj.get("canEdit"),
                "isMember": obj.get("isMember"),
                "created_at": obj.get("created_at"),
                "updated_at": obj.get("updated_at"),
            }
        )
        return _obj
