# coding: utf-8

"""
Jaqpot API

A modern RESTful API for model management and prediction services, built using Spring Boot and Kotlin. Supports seamless integration with machine learning workflows.

The version of the OpenAPI document: 1.0.0
Contact: upci.ntua@gmail.com
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self


class OrganizationInvitation(BaseModel):
    """
    OrganizationInvitation
    """  # noqa: E501

    id: Optional[StrictStr] = Field(default=None, description="ID of the invitation")
    user_id: Optional[StrictStr] = Field(
        default=None,
        description="The user id associated with that invitation",
        alias="userId",
    )
    user_email: StrictStr = Field(
        description="Email address of the invited user", alias="userEmail"
    )
    status: StrictStr = Field(description="Status of the invitation")
    expiration_date: datetime = Field(
        description="Expiration date of the invitation", alias="expirationDate"
    )
    __properties: ClassVar[List[str]] = [
        "id",
        "userId",
        "userEmail",
        "status",
        "expirationDate",
    ]

    @field_validator("status")
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(["PENDING", "REJECTED", "ACCEPTED"]):
            raise ValueError(
                "must be one of enum values ('PENDING', 'REJECTED', 'ACCEPTED')"
            )
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of OrganizationInvitation from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of OrganizationInvitation from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "id": obj.get("id"),
                "userId": obj.get("userId"),
                "userEmail": obj.get("userEmail"),
                "status": obj.get("status"),
                "expirationDate": obj.get("expirationDate"),
            }
        )
        return _obj
