from enum import Enum


class Models(str, Enum):
    # OpenAI models.
    chat_gpt = "gpt-3.5-turbo"
    chat_gpt_16k = "gpt-3.5-turbo"
    gpt_35_turbo = "gpt-3.5-turbo"
    gpt_35_turbo_16k = "gpt-3.5-turbo"
    gpt_35_turbo_16k_0125 = "gpt-3.5-turbo"
    gpt_35_turbo_instruct = "gpt-3.5-turbo-instruct"
    gpt_4 = "gpt-4 (8K context)"
    gpt_4_turbo = "GPT-4 Turbo"
    gpt_4o = "GPT-4o"
    gpt_4o_mini = "GPT-4o mini"
    gpt_4_turbo_0125 = "GPT-4 Turbo (0125)"
    gpt_4_128k = "gpt-4 (128K context)"
    gpt_4_1 = "gpt-4.1"
    gpt_4_1_nano = "gpt-4.1-nano"
    gpt_4_1_mini = "gpt-4.1-mini"
    babbage_2 = "babbage-002"
    davinci_2 = "davinci-002"
    o1_preview = "o1-preview"
    o1_mini = "o1-mini"

    # Azure models.
    azure_chat_gpt = "gpt-3.5-turbo (Azure)"
    azure_chat_gpt_16k = "gpt-3.5-turbo (Azure)"
    azure_gpt_35_turbo = "gpt-3.5-turbo (Azure)"
    azure_gpt_35_turbo_16k = "gpt-3.5-turbo (Azure)"
    azure_gpt_35_turbo_instruct = "gpt-3.5-turbo-instruct (Azure)"
    azure_gpt_4 = "gpt-4 (Azure)"
    azure_gpt_4o = "GPT-4o (Azure)"
    azure_gpt_4o_mini = "GPT-4o mini (Azure)"
    azure_gpt_4_1 = "gpt-4.1 (Azure)"
    azure_gpt_4_1_nano = "gpt-4.1-nano (Azure)"
    azure_gpt_4_1_mini = "gpt-4.1-mini (Azure)"

    # Vertex AI models.
    text_bison = "text-bison"
    text_bison_001 = "text-bison@001"
    gemini_pro = "gemini-1.0-pro"
    gemini_1_pro = "gemini-1.0-pro"
    gemini_15_flash = "gemini-1.5-flash"
    gemini_15_pro = "gemini-1.5-pro"
    gemini_20_flash = "gemini-2.0-flash"
    gemini_20_flash_lite = "gemini-2.0-flash-lite"
    gemini_20_pro = "gemini-2.0-pro"
    gemini_20_flash_thinking = "gemini-2.0-flash-thinking"

    # Anthropic models.
    claude_3_opus = "Claude 3 Opus"
    claude_3_haiku = "Claude 3 Haiku"
    claude_3_sonnet = "Claude 3 Sonnet"
    claude_35_haiku = "Claude 3.5 Haiku"
    claude_35_sonnet = "Claude 3.5 Sonnet"
    claude_37_sonnet = "Claude 3.7 Sonnet"

    # AWS Bedrock models.
    aws_titan_tg1_large = "AWS - Titan TG1 Large (Bedrock)"
    aws_titan_text_lite_v1 = "AWS - Titan Lite v1 (Bedrock)"
    aws_titan_text_express_v1 = "AWS - Titan Express v1 (Bedrock)"
    cohere_command_r_v1 = "Cohere - Command R v1 (Bedrock)"
    cohere_command_r_plus_v1 = "Cohere - Command R+ v1 (Bedrock)"
    cohere_command_text_v14 = "Cohere - Command v14 (Bedrock)"
    cohere_command_light_text_v14 = "Cohere - Command Light v14 (Bedrock)"
    ai21_j2_mid_v1 = "AI21 - Jurassic-2 Mid v1 (Bedrock)"
    ai21_j2_ultra_v1 = "AI21 - Jurassic-2 Ultra v1 (Bedrock)"
    anthropic_claude_instant_v1 = "Anthropic - Claude Instant v1 (Bedrock)"
    anthropic_claude_v1 = "Anthropic - Claude v1 (Bedrock)"
    anthropic_claude_v2 = "Anthropic - Claude v2 (Bedrock)"
    anthropic_claude_v21 = "Anthropic - Claude v2.1 (Bedrock)"
    anthropic_claude_3_sonnet = "Anthropic - Claude 3 Sonnet (Bedrock)"
    anthropic_claude_3_haiku = "Anthropic - Claude 3 Haiku (Bedrock)"
    anthropic_claude_3_opus = "Anthropic - Claude 3 Opus (Bedrock)"
    anthropic_claude_35_sonnet = "Anthropic - Claude 3.5 Sonnet (Bedrock)"
    anthropic_claude_35_sonnet_v2 = "Anthropic - Claude 3.5 Sonnet v2 (Bedrock)"
    meta_llama2_13b_chat_v1 = "Meta - Llama 2 Chat 13B v1 (Bedrock)"
    meta_llama3_8b_instruct_v1 = "Meta - Llama 3 8B Instruct v1 (Bedrock)"
    meta_llama3_70b_instruct_v1 = "Meta - Llama 3 70B Instruct v1 (Bedrock)"
    meta_llama3_1_8b_instruct_v1 = "Meta - Llama 3.1 8B Instruct v1 (Bedrock)"
    meta_llama3_1_70b_instruct_v1 = "Meta - Llama 3.1 70B Instruct v1 (Bedrock)"
    meta_llama3_1_405b_instruct_v1 = "Meta - Llama 3.1 405B Instruct v1 (Bedrock)"
    meta_llama3_2_1b_instruct = "Meta - Llama 3.2 1B Instruct (Bedrock)"
    meta_llama3_2_3b_instruct = "Meta - Llama 3.2 3B Instruct (Bedrock)"
    meta_llama3_2_11b_instruct = "Meta - Llama 3.2 11B Instruct (Bedrock)"
    meta_llama3_2_90b_instruct = "Meta - Llama 3.2 90B Instruct (Bedrock)"
    mistral_7b_instruct = "Mistral - 7B Instruct (Bedrock)"
    mistral_8x7b_instruct = "Mixtral - 8x7B Instruct (Bedrock)"
    mistral_large = "Mistral - Large (Bedrock)"

    # Writer models.
    palmyra_base = "Palmyra Base"
    palmyra_large = "Palmyra Large"
    palmyra_instruct = "Palmyra Instruct"
    palmyra_instruct_30 = "Palmyra Instruct 30"
    palmyra_beta = "Palmyra Beta"
    silk_road = "Silk Road"
    palmyra_e = "Palmyra E"
    palmyra_x = "Palmyra X"
    palmyra_x_32k = "Palmyra X 32K"
    palmyra_med = "Palmyra Med"
    examworks_v1 = "Exam Works"
