# ZefirAnalytics
# Copyright (C) 2023-2024 Narodowe Centrum Badań Jądrowych
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

from zefir_analytics._engine.data_loader import DataLoader
from zefir_analytics._engine.data_queries.aggregated_consumer_parameters_over_years import (
    AggregatedConsumerParametersOverYearsQuery,
)
from zefir_analytics._engine.data_queries.lbs_parameters_over_years import (
    LbsParametersOverYearsQuery,
)
from zefir_analytics._engine.data_queries.line_parameters_over_years import (
    LineParametersOverYearsQuery,
)
from zefir_analytics._engine.data_queries.source_parameters_over_years import (
    SourceParametersOverYearsQuery,
)

__all__ = [
    "DataLoader",
    "SourceParametersOverYearsQuery",
    "LineParametersOverYearsQuery",
    "AggregatedConsumerParametersOverYearsQuery",
    "LbsParametersOverYearsQuery",
]
