# excel 2 Moodle
![Logo](excel2moodleLogo.png "Logo excel2moodle"){width=35%}

*excel2moodle* helps you to create moodle questions in less time.
The idea is to write the questions data into a spreadsheet file, from which *excel2moodle* generates moodle compliant xml Files. 
All questions or a selection of questions can then be imported into moodle.
Furthermore *excel2moodle* helps you generating semi-random Variables for parametric questions. 
This way you can generate a thousands of numeric questions based off a formula and a set of variables.

## Concept
At the heart the *excel2moodle* is a simple key-value-pair "syntax", where the key is set once in the first spreadsheet column.
Each key can be provided with a value for each question in its column.
To enhance reusability, keys which are correct for more than one question can be set per category or for all questions.

### Structure of the Spreadsheet
A `settings` sheet contains global settings to be used for all questions and categories.
Another sheet stores metadata for the different categories of questions.
And each category lives inside a separate sheet inside the spreadsheet document.

## Getting Started

### Installation
To get started with excel2moodle first have a look at the [installation](https://jbosse3.gitlab.io/excel2moodle/howto.html#excel2moodle-unter-windows-installieren)
If you already have python and uv installed, it is as easy as running `uv tool install excel2moodle`.

### [ Documentation ](https://jbosse3.gitlab.io/excel2moodle/index.html)
Once excel2moodle is installed you can checkout the [example question sheet](https://gitlab.com/jbosse3/excel2moodle/-/tree/master/example?ref_type=heads) 
in the repository. You need to download all Files in the `example` directory and save them together.

Most steps are already documented as [ tutorials ](https://jbosse3.gitlab.io/excel2moodle/howto.html)
you can follow along.

And please have a look into the [**user Reference**](https://jbosse3.gitlab.io/excel2moodle/userReference.html)
of the documentation. 
That part explains in more detail each part of defining a question.


## Features
- Fully parametrized numeric questions:
    * Formulas for the calculated results can be coded into extensive python modules, which can be loaded.
- Question Preview:
    + This helps you when selecting the correct questions for the export.
- Equation Verification:
    + this tool helps you to validate the correct equation for the parametrized Questions.
- Variable Generation:
    + You can generate variables for the parametric Question to easily create hundreds of different variants of the same question.
- Export Options:
    + you can export the questions preserving the categories in moodle

### Question Types
- Generate multiple Choice Questions:
    * The answers can be pictures or normal text
- Generate Numeric Questions
- Generate parametrized numeric Questions:
    * With the parametrization *excel2moodle* calculats the numeric answer from a given formula based on a set of variables.
- Generate parametrized cloze Questions


![MainWindow](mainWindow.png "Logo excel2moodle"){width=80%}

## Licensing and authorship
excel2moodle is lincensed under the latest [GNU GPL license](https://gitlab.com/jbosse3/excel2moodle/-/blob/master/LICENSE)
Initial development was made by Richard Lorenz, and later taken over by Jakob Bosse

## Supporting
A special thanks goes to the [Civil Engineering Departement of the Fachhochschule Potsdam](https://www.fh-potsdam.de/en/study-further-education/departments/civil-engineering-department) 
where i was employed as a student associate to work on this project.

If You want to support my work as well, you can by me a [coffee](https://ko-fi.com/jbosse3)

# Changelogs

## 0.9.0 (2025-11-02)
Bullet Points can be formatted by a template

### documentation (3 changes)

- [Restructured and improved documentation](https://gitlab.com/jbosse3/excel2moodle/-/commit/289a38a2f9545d22b0729620a7d2c24f0612a57a)
- [Wrote Tutorial on implementing NFM questions](https://gitlab.com/jbosse3/excel2moodle/-/commit/917b54a1e8daf705c2e5c1a2243b0a9f395a5bd3)
- [improved picture key documentatino](https://gitlab.com/jbosse3/excel2moodle/-/commit/03ca72de74999858b1f890e71dffd388b0086a1d)

### feature (2 changes)

- [added bulletpoint template support](https://gitlab.com/jbosse3/excel2moodle/-/commit/56882051862a64c6acdc2687bb45e53600fa6acf)
- [preview of LaTex code using matplotlibs rendering capabilities](https://gitlab.com/jbosse3/excel2moodle/-/commit/1d52d13745541c45f7692834bc10ab07864ca2be)

## 0.8.0 (2025-10-25)
feedbacking and raw bullet implemented

### feature (3 changes)

- [show the feedback in question preview as well](https://gitlab.com/jbosse3/excel2moodle/-/commit/9be9392ea4ff6ffc9d808ba29f228e1f6678c245)
- [added true and false answerfeedback for MC questions](https://gitlab.com/jbosse3/excel2moodle/-/commit/12412e6fbf1f41ead14a4e99e7fbf23b6c6faa66)
- [added rawBulletPoint for easy bullet Points](https://gitlab.com/jbosse3/excel2moodle/-/commit/6556967eb449172ffceb0119e1245c25d00a3819)

### bugfix (1 change)

- [fix warning about cloze points](https://gitlab.com/jbosse3/excel2moodle/-/commit/a2488dad20dbd84252fa3a362e656359748a71dc)

### documentation (2 changes)

- [Added logLevel key to documentation and question_types code docs](https://gitlab.com/jbosse3/excel2moodle/-/commit/0118358caacf1e010d40e36d19d75a079dce5365)
- [Update example Questions.ods](https://gitlab.com/jbosse3/excel2moodle/-/commit/5570de4628385e81e9e1effad5d1412688aa09ab)

## 0.7.4 (2025-10-13)
hopefully final bulletPoint improvement

### bugfix (2 changes)

- [Fix opening spreadsheet in external app broken under windows](https://gitlab.com/jbosse3/excel2moodle/-/commit/762f5d711611938ef615076f5d0fa5e1e1e5494d)
- [Inserted space between number and unit of bulletPoints](https://gitlab.com/jbosse3/excel2moodle/-/commit/e591b119705356d76540d485ff72b64295015c3d)

## 0.7.3 (2025-10-12)
further bulletPoint improvements

No changes.

## 0.7.2 (2025-10-11)
small important bugfixes

### improvement (2 changes)

- [BulletPoints are decoded using regex to allow multi word names](https://gitlab.com/jbosse3/excel2moodle/-/commit/7e32e9817323054d84a0dfb9a0a241c702fd096d)
- [Restructured globals, renamed rawInput to rawData](https://gitlab.com/jbosse3/excel2moodle/-/commit/effd9c3cd196b36d49204fe715acc1ffb124549c)

### bugfix (2 changes)

- [Added the number do the mandatory tags because it is](https://gitlab.com/jbosse3/excel2moodle/-/commit/56e9b69d71504dffe7c235d69ff44dec6931db28)
- [fixed assigning the first result to all clozes](https://gitlab.com/jbosse3/excel2moodle/-/commit/09a281c253502adc23442892be03aac36e6ea720)

## 0.7.1 (2025-10-04)
feedbacking improved

### documentation (1 change)

- [documentation improvement](https://gitlab.com/jbosse3/excel2moodle/-/commit/1a1110d05b49175e049a9ca18a027216a765e277)

### feature (1 change)

- [Added MC answer feedback support](https://gitlab.com/jbosse3/excel2moodle/-/commit/4f5fe550786cf29839ba54fbdfedbf03c72d3009)

## 0.7.0 (2025-09-30)
Rework of the equation checker done!

### feature (1 change)

- [finalized equation Checker](https://gitlab.com/jbosse3/excel2moodle/-/commit/55e3891d3da56357ad00f672a86c2690d551d21c)

### documentation (1 change)

- [Documented feedback usages](https://gitlab.com/jbosse3/excel2moodle/-/commit/6f50ce023a3235b3f34b6272a4ce5057346f8751)

### improvement (1 change)

- [MainWindow got a currentQuestion property](https://gitlab.com/jbosse3/excel2moodle/-/commit/59b18e158201357b767a36dab0f300f88cb5e9ad)

## 0.6.5 (2025-09-02)
Added Scripted Media Support now with the module

No changes.

## 0.6.4 (2025-09-02)
Added Scripted Media Support

### feature (1 change)

- [Added support for scripted Media content.](https://gitlab.com/jbosse3/excel2moodle/-/commit/2021942392147d0e9740af5286f469dd6226ffa5)

## 0.6.3 (2025-08-03)
Lots of small improvements made

### improvement (3 changes)

- [small logging improvements and error handling](https://gitlab.com/jbosse3/excel2moodle/-/commit/149f8e923a06d9d7077fe90c7005a3e1d5d2d42f)
- [Make variable generator rules editable](https://gitlab.com/jbosse3/excel2moodle/-/commit/80ea32d97bdec16b77100bc870a0e0272a739dd4)
- [Variable generator only generates unique sets.](https://gitlab.com/jbosse3/excel2moodle/-/commit/d347c91bbac66de1da157fee4f76faf8d4636557)

### bugfix (3 changes)

- [mixed parametric and non parametric Bullets are working now](https://gitlab.com/jbosse3/excel2moodle/-/commit/f094b13dffd4b6b7ac1a03fc7e34eec6e8d1bfa7)
- [Loglevel setting is respected in spreadsheet file](https://gitlab.com/jbosse3/excel2moodle/-/commit/d6ef89beeec94f24782a00b7564883074badf72d)
- [Treewidget variants count updated after variable generation](https://gitlab.com/jbosse3/excel2moodle/-/commit/c48a0d093a0cce85fd3e9c3c091eef936739c02b)

### feature (2 changes)

- [Category ID taken from any number in its name](https://gitlab.com/jbosse3/excel2moodle/-/commit/ac7e19af5f25ac2e576b63c478e7b07153e782ef)
- [Implemented Update Check on Startup](https://gitlab.com/jbosse3/excel2moodle/-/commit/a143edd47f566c5e731c05612f4ac21dc7728eb7)

## 0.6.2 (2025-08-02)
Adding export options and fixing cloze points bug

### feature (4 changes)

- [Added export options to include all Question Variants and generate report](https://gitlab.com/jbosse3/excel2moodle/-/commit/6433615de23174451748b69669a9dce748dd5b4d)
- [Implemented export dialog generator method](https://gitlab.com/jbosse3/excel2moodle/-/commit/a8eda982309bf9a6dae7ef2b261a59654f2c8910)
- [Answer Feedback strings settable in sheet](https://gitlab.com/jbosse3/excel2moodle/-/commit/ad90da49ac60e429ad3243f54846b08f0caf5bc7)
- [Inverted result and feedback for NFM & Cloze questions](https://gitlab.com/jbosse3/excel2moodle/-/commit/57d77c83a661398b0082f84d25e5447000df9096)

### improvement (1 change)

- [Missing `settings` sheet raises an error](https://gitlab.com/jbosse3/excel2moodle/-/commit/e1cc42c1d31981bf74582b23c24c6ac378e9256d)

### bugfix (1 change)

- [resolve cloze moodle import error due to float points](https://gitlab.com/jbosse3/excel2moodle/-/commit/f13b7b9df39df55d65b6063a9deb1fc1c72f5ebb)

## 0.6.1 (2025-07-12)
Fixing import error caused by dumping pyside meta package

### bugfix (1 change)

- [fixing pyside import error](https://gitlab.com/jbosse3/excel2moodle/-/commit/e5e0fc7695caa1a6864785828ff7311fa9624ad4)

## 0.6.0 (2025-07-12)
Added variable generator and other architechtural improvements

### documentation (1 change)

- [Documenting variable generator usage](https://gitlab.com/jbosse3/excel2moodle/-/commit/3e4d3019b29872b5cfddf5539d5ebe7638bca049)

### feature (5 changes)

- [Opening spreadsheet file works from within excel2moodle](https://gitlab.com/jbosse3/excel2moodle/-/commit/9470f12ea5f098745a3210b281a5144a938ae8b5)
- [Variables are copied to clipboard](https://gitlab.com/jbosse3/excel2moodle/-/commit/87a7e5ec75f899b293e89ad3c1742567e3ec1c29)
- [Removed dependence on pyside6-addons](https://gitlab.com/jbosse3/excel2moodle/-/commit/2b3a7cf48581c14bd9cb570cd61d1d41aa410e11)
- [Var Generator ready](https://gitlab.com/jbosse3/excel2moodle/-/commit/ea97f0639dc35a4c99a64ae3976ccc8a0ac5d109)
- [Merge development of BulletsObj, Parametrization and VarGenerator](https://gitlab.com/jbosse3/excel2moodle/-/commit/40b46f3c143e082f1bb985d6c8c4e68bb6b6a7a8)

### improvement (7 changes)

- [Adapted Param. Parser to use bullet Obj](https://gitlab.com/jbosse3/excel2moodle/-/commit/194cab7cc6aecb2d25d1cb9c1538ed7d607dd9e1)
- [Added bulleList Object](https://gitlab.com/jbosse3/excel2moodle/-/commit/4ea982b8d8dc270675d2cb059c59fa980ce38894)
- [Parametrics in beta stage](https://gitlab.com/jbosse3/excel2moodle/-/commit/7d04d8ef2fc603c1b12b6934c827ce079df5d540)
- [Refactor parse() method, to construct complete xml-Tree](https://gitlab.com/jbosse3/excel2moodle/-/commit/8dc4bea9aa0673d39357115254dd55b02c04114e)
- [Refactored question assembly to only update fields.](https://gitlab.com/jbosse3/excel2moodle/-/commit/d7accb69be3b4a1e65f59eeecfb463f2663fabd4)
- [Adapted NFM Question to parametricResult](https://gitlab.com/jbosse3/excel2moodle/-/commit/fe552cd2b538ca8886415c200e4a2a3ecc1fbb2f) ([merge request](https://gitlab.com/jbosse3/excel2moodle/-/merge_requests/5))
- [Implemented ParametricResult Object](https://gitlab.com/jbosse3/excel2moodle/-/commit/e36d025955f1cab8e0542d66263ab70e3d8980df) ([merge request](https://gitlab.com/jbosse3/excel2moodle/-/merge_requests/5))

## 0.5.2 (2025-06-30)
Extended Documentation and bugfix for import Module

### bugfix (2 changes)

- [Default question variant saved and reused.](https://gitlab.com/jbosse3/excel2moodle/-/commit/097705ba83727463a9b27cd76e99814a7ecf28df)
- [bugfix: Import module working again](https://gitlab.com/jbosse3/excel2moodle/-/commit/5f293970bcdac3858911cdcc102b72714af057bd)

### documentation (1 change)

- [documentation: Added how to build question database](https://gitlab.com/jbosse3/excel2moodle/-/commit/71ceb122aa37e8bf2735b659359ae37d81017599)

### feature (1 change)

- [Implemented MC question string method](https://gitlab.com/jbosse3/excel2moodle/-/commit/c4f2081d0000ee60322fe8eec8468fa3317ce7be)

### improvement (1 change)

- [Implemented ClozePart object](https://gitlab.com/jbosse3/excel2moodle/-/commit/878f90f45e37421384c4f8f602115e7596b4ceb9)

## 0.5.2 (2025-06-30)
Extended Documentation and bugfix for import Module

### bugfix (2 changes)

- [Default question variant saved and reused.](https://gitlab.com/jbosse3/excel2moodle/-/commit/097705ba83727463a9b27cd76e99814a7ecf28df)
- [bugfix: Import module working again](https://gitlab.com/jbosse3/excel2moodle/-/commit/5f293970bcdac3858911cdcc102b72714af057bd)

### documentation (1 change)

- [documentation: Added how to build question database](https://gitlab.com/jbosse3/excel2moodle/-/commit/71ceb122aa37e8bf2735b659359ae37d81017599)

### feature (1 change)

- [Implemented MC question string method](https://gitlab.com/jbosse3/excel2moodle/-/commit/c4f2081d0000ee60322fe8eec8468fa3317ce7be)

### improvement (1 change)

- [Implemented ClozePart object](https://gitlab.com/jbosse3/excel2moodle/-/commit/878f90f45e37421384c4f8f602115e7596b4ceb9)

## 0.5.1 (2025-06-24)
Minor docs improvement and question variant bugfix

### bugfix (1 change)

- [Bullet points variant didn't get updated](https://gitlab.com/jbosse3/excel2moodle/-/commit/7b4ad9e9c8a4216167ae019859ebaa8def81d57f)

## 0.5.0 (2025-06-20)
settings handling improved

### feature (2 changes)

- [Pixmaps and vector graphics scaled to fit in preview](https://gitlab.com/jbosse3/excel2moodle/-/commit/00a6ef13fb2a0046d7641e24af6cf6f08642390e)
- [feature: category Settings implemented](https://gitlab.com/jbosse3/excel2moodle/-/commit/d673cc3f5ba06051aa37bc17a3ef0161121cb730)

### improvement (1 change)

- [Tolerance is harmonized by questionData.get()](https://gitlab.com/jbosse3/excel2moodle/-/commit/8d1724f4877e1584cc531b6b3f278bdea68b5831)

### Settings Errors are logged (1 change)

- [Log Errors in settings Sheet](https://gitlab.com/jbosse3/excel2moodle/-/commit/07e58f957c69ea818db1c5679cf89e287817ced3)

