# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.language import Language
from ..types.response_code_execute_response import ResponseCodeExecuteResponse
from ..types.response_code_info_response import ResponseCodeInfoResponse
from .raw_client import AsyncRawCodeClient, RawCodeClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class CodeClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawCodeClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawCodeClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawCodeClient
        """
        return self._raw_client

    def execute_code(
        self,
        *,
        language: Language,
        code: str,
        timeout: typing.Optional[int] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ResponseCodeExecuteResponse:
        """
        Run code through the unified runtime, dispatching to Python, Node.js, or future language executors

        Parameters
        ----------
        language : Language
            Target runtime language

        code : str
            Source code to execute

        timeout : typing.Optional[int]
            Execution timeout in seconds

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ResponseCodeExecuteResponse
            Successful Response

        Examples
        --------
        from agent_sandbox import Sandbox

        client = Sandbox(
            base_url="https://yourhost.com/path/to/api",
        )
        client.code.execute_code(
            language="python",
            code="code",
        )
        """
        _response = self._raw_client.execute_code(
            language=language, code=code, timeout=timeout, request_options=request_options
        )
        return _response.data

    def get_info(self, *, request_options: typing.Optional[RequestOptions] = None) -> ResponseCodeInfoResponse:
        """
        Return metadata about supported code runtimes

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ResponseCodeInfoResponse
            Successful Response

        Examples
        --------
        from agent_sandbox import Sandbox

        client = Sandbox(
            base_url="https://yourhost.com/path/to/api",
        )
        client.code.get_info()
        """
        _response = self._raw_client.get_info(request_options=request_options)
        return _response.data


class AsyncCodeClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawCodeClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawCodeClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawCodeClient
        """
        return self._raw_client

    async def execute_code(
        self,
        *,
        language: Language,
        code: str,
        timeout: typing.Optional[int] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ResponseCodeExecuteResponse:
        """
        Run code through the unified runtime, dispatching to Python, Node.js, or future language executors

        Parameters
        ----------
        language : Language
            Target runtime language

        code : str
            Source code to execute

        timeout : typing.Optional[int]
            Execution timeout in seconds

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ResponseCodeExecuteResponse
            Successful Response

        Examples
        --------
        import asyncio

        from agent_sandbox import AsyncSandbox

        client = AsyncSandbox(
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.code.execute_code(
                language="python",
                code="code",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.execute_code(
            language=language, code=code, timeout=timeout, request_options=request_options
        )
        return _response.data

    async def get_info(self, *, request_options: typing.Optional[RequestOptions] = None) -> ResponseCodeInfoResponse:
        """
        Return metadata about supported code runtimes

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ResponseCodeInfoResponse
            Successful Response

        Examples
        --------
        import asyncio

        from agent_sandbox import AsyncSandbox

        client = AsyncSandbox(
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.code.get_info()


        asyncio.run(main())
        """
        _response = await self._raw_client.get_info(request_options=request_options)
        return _response.data
