# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ..core.api_error import ApiError
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.http_response import AsyncHttpResponse, HttpResponse
from ..core.pydantic_utilities import parse_obj_as
from ..core.request_options import RequestOptions
from ..errors.unprocessable_entity_error import UnprocessableEntityError
from ..types.http_validation_error import HttpValidationError
from ..types.language import Language
from ..types.response_code_execute_response import ResponseCodeExecuteResponse
from ..types.response_code_info_response import ResponseCodeInfoResponse

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawCodeClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def execute_code(
        self,
        *,
        language: Language,
        code: str,
        timeout: typing.Optional[int] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[ResponseCodeExecuteResponse]:
        """
        Run code through the unified runtime, dispatching to Python, Node.js, or future language executors

        Parameters
        ----------
        language : Language
            Target runtime language

        code : str
            Source code to execute

        timeout : typing.Optional[int]
            Execution timeout in seconds

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ResponseCodeExecuteResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "v1/code/execute",
            method="POST",
            json={
                "language": language,
                "code": code,
                "timeout": timeout,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ResponseCodeExecuteResponse,
                    parse_obj_as(
                        type_=ResponseCodeExecuteResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_info(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[ResponseCodeInfoResponse]:
        """
        Return metadata about supported code runtimes

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ResponseCodeInfoResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "v1/code/info",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ResponseCodeInfoResponse,
                    parse_obj_as(
                        type_=ResponseCodeInfoResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawCodeClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def execute_code(
        self,
        *,
        language: Language,
        code: str,
        timeout: typing.Optional[int] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[ResponseCodeExecuteResponse]:
        """
        Run code through the unified runtime, dispatching to Python, Node.js, or future language executors

        Parameters
        ----------
        language : Language
            Target runtime language

        code : str
            Source code to execute

        timeout : typing.Optional[int]
            Execution timeout in seconds

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ResponseCodeExecuteResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v1/code/execute",
            method="POST",
            json={
                "language": language,
                "code": code,
                "timeout": timeout,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ResponseCodeExecuteResponse,
                    parse_obj_as(
                        type_=ResponseCodeExecuteResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_info(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[ResponseCodeInfoResponse]:
        """
        Return metadata about supported code runtimes

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ResponseCodeInfoResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v1/code/info",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ResponseCodeInfoResponse,
                    parse_obj_as(
                        type_=ResponseCodeInfoResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
