# This file was auto-generated by Fern from our API Definition.

import contextlib
import typing
from json.decoder import JSONDecodeError

from .. import core
from ..core.api_error import ApiError
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.http_response import AsyncHttpResponse, HttpResponse
from ..core.pydantic_utilities import parse_obj_as
from ..core.request_options import RequestOptions
from ..errors.unprocessable_entity_error import UnprocessableEntityError
from ..types.file_content_encoding import FileContentEncoding
from ..types.http_validation_error import HttpValidationError
from ..types.response_file_find_result import ResponseFileFindResult
from ..types.response_file_list_result import ResponseFileListResult
from ..types.response_file_read_result import ResponseFileReadResult
from ..types.response_file_replace_result import ResponseFileReplaceResult
from ..types.response_file_search_result import ResponseFileSearchResult
from ..types.response_file_upload_result import ResponseFileUploadResult
from ..types.response_file_write_result import ResponseFileWriteResult
from ..types.response_str_replace_editor_result import ResponseStrReplaceEditorResult
from .types.command import Command

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawFileClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def read_file(
        self,
        *,
        file: str,
        start_line: typing.Optional[int] = OMIT,
        end_line: typing.Optional[int] = OMIT,
        sudo: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[ResponseFileReadResult]:
        """
        Read file content

        Parameters
        ----------
        file : str
            Absolute file path

        start_line : typing.Optional[int]
            Start line (0-based)

        end_line : typing.Optional[int]
            End line (not inclusive)

        sudo : typing.Optional[bool]
            Whether to use sudo privileges

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ResponseFileReadResult]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "v1/file/read",
            method="POST",
            json={
                "file": file,
                "start_line": start_line,
                "end_line": end_line,
                "sudo": sudo,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ResponseFileReadResult,
                    parse_obj_as(
                        type_=ResponseFileReadResult,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def write_file(
        self,
        *,
        file: str,
        content: str,
        encoding: typing.Optional[FileContentEncoding] = OMIT,
        append: typing.Optional[bool] = OMIT,
        leading_newline: typing.Optional[bool] = OMIT,
        trailing_newline: typing.Optional[bool] = OMIT,
        sudo: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[ResponseFileWriteResult]:
        """
        Write file content (supports both text and binary files)

        For binary files, set encoding to 'base64' and provide base64-encoded content.
        For text files, use default 'utf-8' encoding.

        Parameters
        ----------
        file : str
            Absolute file path

        content : str
            Content to write (text or base64 encoded for binary)

        encoding : typing.Optional[FileContentEncoding]
            Content encoding: utf-8 for text, base64 for binary data

        append : typing.Optional[bool]
            Whether to use append mode

        leading_newline : typing.Optional[bool]
            Whether to add leading newline (only for text mode)

        trailing_newline : typing.Optional[bool]
            Whether to add trailing newline (only for text mode)

        sudo : typing.Optional[bool]
            Whether to use sudo privileges

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ResponseFileWriteResult]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "v1/file/write",
            method="POST",
            json={
                "file": file,
                "content": content,
                "encoding": encoding,
                "append": append,
                "leading_newline": leading_newline,
                "trailing_newline": trailing_newline,
                "sudo": sudo,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ResponseFileWriteResult,
                    parse_obj_as(
                        type_=ResponseFileWriteResult,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def replace_in_file(
        self,
        *,
        file: str,
        old_str: str,
        new_str: str,
        sudo: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[ResponseFileReplaceResult]:
        """
        Replace string in file

        Parameters
        ----------
        file : str
            Absolute file path

        old_str : str
            Original string to replace

        new_str : str
            New string to replace with

        sudo : typing.Optional[bool]
            Whether to use sudo privileges

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ResponseFileReplaceResult]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "v1/file/replace",
            method="POST",
            json={
                "file": file,
                "old_str": old_str,
                "new_str": new_str,
                "sudo": sudo,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ResponseFileReplaceResult,
                    parse_obj_as(
                        type_=ResponseFileReplaceResult,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def search_in_file(
        self,
        *,
        file: str,
        regex: str,
        sudo: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[ResponseFileSearchResult]:
        """
        Search in file content

        Parameters
        ----------
        file : str
            Absolute file path

        regex : str
            Regular expression pattern

        sudo : typing.Optional[bool]
            Whether to use sudo privileges

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ResponseFileSearchResult]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "v1/file/search",
            method="POST",
            json={
                "file": file,
                "regex": regex,
                "sudo": sudo,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ResponseFileSearchResult,
                    parse_obj_as(
                        type_=ResponseFileSearchResult,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def find_files(
        self, *, path: str, glob: str, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[ResponseFileFindResult]:
        """
        Find files by name pattern

        Parameters
        ----------
        path : str
            Directory path to search

        glob : str
            Filename pattern (glob syntax)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ResponseFileFindResult]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "v1/file/find",
            method="POST",
            json={
                "path": path,
                "glob": glob,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ResponseFileFindResult,
                    parse_obj_as(
                        type_=ResponseFileFindResult,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def upload_file(
        self,
        *,
        file: core.File,
        path: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[ResponseFileUploadResult]:
        """
        Upload file using streaming

        Parameters
        ----------
        file : core.File
            See core.File for more documentation

        path : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ResponseFileUploadResult]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "v1/file/upload",
            method="POST",
            data={
                "path": path,
            },
            files={
                "file": file,
            },
            request_options=request_options,
            omit=OMIT,
            force_multipart=True,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ResponseFileUploadResult,
                    parse_obj_as(
                        type_=ResponseFileUploadResult,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    @contextlib.contextmanager
    def download_file(
        self, *, path: str, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.Iterator[HttpResponse[typing.Iterator[bytes]]]:
        """
        Download file using FileResponse

        Parameters
        ----------
        path : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration. You can pass in configuration such as `chunk_size`, and more to customize the request and response.

        Returns
        -------
        typing.Iterator[HttpResponse[typing.Iterator[bytes]]]
            Successful Response
        """
        with self._client_wrapper.httpx_client.stream(
            "v1/file/download",
            method="GET",
            params={
                "path": path,
            },
            request_options=request_options,
        ) as _response:

            def _stream() -> HttpResponse[typing.Iterator[bytes]]:
                try:
                    if 200 <= _response.status_code < 300:
                        _chunk_size = request_options.get("chunk_size", None) if request_options is not None else None
                        return HttpResponse(
                            response=_response, data=(_chunk for _chunk in _response.iter_bytes(chunk_size=_chunk_size))
                        )
                    _response.read()
                    if _response.status_code == 422:
                        raise UnprocessableEntityError(
                            headers=dict(_response.headers),
                            body=typing.cast(
                                HttpValidationError,
                                parse_obj_as(
                                    type_=HttpValidationError,  # type: ignore
                                    object_=_response.json(),
                                ),
                            ),
                        )
                    _response_json = _response.json()
                except JSONDecodeError:
                    raise ApiError(
                        status_code=_response.status_code, headers=dict(_response.headers), body=_response.text
                    )
                raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

            yield _stream()

    def list_path(
        self,
        *,
        path: str,
        recursive: typing.Optional[bool] = OMIT,
        show_hidden: typing.Optional[bool] = OMIT,
        file_types: typing.Optional[typing.Sequence[str]] = OMIT,
        max_depth: typing.Optional[int] = OMIT,
        include_size: typing.Optional[bool] = OMIT,
        include_permissions: typing.Optional[bool] = OMIT,
        sort_by: typing.Optional[str] = OMIT,
        sort_desc: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[ResponseFileListResult]:
        """
        List path contents with flexible options

        Parameters
        ----------
        path : str
            Directory path to list

        recursive : typing.Optional[bool]
            Whether to list recursively

        show_hidden : typing.Optional[bool]
            Whether to show hidden files

        file_types : typing.Optional[typing.Sequence[str]]
            Filter by file extensions (e.g., ['.py', '.txt'])

        max_depth : typing.Optional[int]
            Maximum depth for recursive listing

        include_size : typing.Optional[bool]
            Whether to include file size information

        include_permissions : typing.Optional[bool]
            Whether to include file permissions

        sort_by : typing.Optional[str]
            Sort by: name, size, modified, type

        sort_desc : typing.Optional[bool]
            Sort in descending order

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ResponseFileListResult]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "v1/file/list",
            method="POST",
            json={
                "path": path,
                "recursive": recursive,
                "show_hidden": show_hidden,
                "file_types": file_types,
                "max_depth": max_depth,
                "include_size": include_size,
                "include_permissions": include_permissions,
                "sort_by": sort_by,
                "sort_desc": sort_desc,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ResponseFileListResult,
                    parse_obj_as(
                        type_=ResponseFileListResult,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def str_replace_editor(
        self,
        *,
        command: Command,
        path: str,
        file_text: typing.Optional[str] = OMIT,
        old_str: typing.Optional[str] = OMIT,
        new_str: typing.Optional[str] = OMIT,
        insert_line: typing.Optional[int] = OMIT,
        view_range: typing.Optional[typing.Sequence[int]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[ResponseStrReplaceEditorResult]:
        """
        An filesystem editor tool that allows the agent to
        - view
        - create
        - navigate
        - edit files
        The tool parameters are defined by Anthropic and are not editable.

        Parameters
        ----------
        command : Command
            The commands to run. Allowed options are: `view`, `create`, `str_replace`, `insert`, `undo_edit`.

        path : str
            Absolute path to file or directory, e.g. `/workspace/file.py` or `/workspace`.

        file_text : typing.Optional[str]
            Required parameter of `create` command, with the content of the file to be created.

        old_str : typing.Optional[str]
            Required parameter of `str_replace` command containing the string in `path` to replace.

        new_str : typing.Optional[str]
            Optional parameter of `str_replace` command containing the new string (if not given, no string will be added). Required parameter of `insert` command containing the string to insert.

        insert_line : typing.Optional[int]
            Required parameter of `insert` command. The `new_str` will be inserted AFTER the line `insert_line` of `path`.

        view_range : typing.Optional[typing.Sequence[int]]
            Optional parameter of `view` command when `path` points to a file. If none is given, the full file is shown. If provided, the file will be shown in the indicated line number range, e.g. [11, 12] will show lines 11 and 12. Indexing at 1 to start. Setting `[start_line, -1]` shows all lines from `start_line` to the end of the file.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ResponseStrReplaceEditorResult]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "v1/file/str_replace_editor",
            method="POST",
            json={
                "command": command,
                "path": path,
                "file_text": file_text,
                "old_str": old_str,
                "new_str": new_str,
                "insert_line": insert_line,
                "view_range": view_range,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ResponseStrReplaceEditorResult,
                    parse_obj_as(
                        type_=ResponseStrReplaceEditorResult,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawFileClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def read_file(
        self,
        *,
        file: str,
        start_line: typing.Optional[int] = OMIT,
        end_line: typing.Optional[int] = OMIT,
        sudo: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[ResponseFileReadResult]:
        """
        Read file content

        Parameters
        ----------
        file : str
            Absolute file path

        start_line : typing.Optional[int]
            Start line (0-based)

        end_line : typing.Optional[int]
            End line (not inclusive)

        sudo : typing.Optional[bool]
            Whether to use sudo privileges

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ResponseFileReadResult]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v1/file/read",
            method="POST",
            json={
                "file": file,
                "start_line": start_line,
                "end_line": end_line,
                "sudo": sudo,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ResponseFileReadResult,
                    parse_obj_as(
                        type_=ResponseFileReadResult,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def write_file(
        self,
        *,
        file: str,
        content: str,
        encoding: typing.Optional[FileContentEncoding] = OMIT,
        append: typing.Optional[bool] = OMIT,
        leading_newline: typing.Optional[bool] = OMIT,
        trailing_newline: typing.Optional[bool] = OMIT,
        sudo: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[ResponseFileWriteResult]:
        """
        Write file content (supports both text and binary files)

        For binary files, set encoding to 'base64' and provide base64-encoded content.
        For text files, use default 'utf-8' encoding.

        Parameters
        ----------
        file : str
            Absolute file path

        content : str
            Content to write (text or base64 encoded for binary)

        encoding : typing.Optional[FileContentEncoding]
            Content encoding: utf-8 for text, base64 for binary data

        append : typing.Optional[bool]
            Whether to use append mode

        leading_newline : typing.Optional[bool]
            Whether to add leading newline (only for text mode)

        trailing_newline : typing.Optional[bool]
            Whether to add trailing newline (only for text mode)

        sudo : typing.Optional[bool]
            Whether to use sudo privileges

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ResponseFileWriteResult]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v1/file/write",
            method="POST",
            json={
                "file": file,
                "content": content,
                "encoding": encoding,
                "append": append,
                "leading_newline": leading_newline,
                "trailing_newline": trailing_newline,
                "sudo": sudo,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ResponseFileWriteResult,
                    parse_obj_as(
                        type_=ResponseFileWriteResult,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def replace_in_file(
        self,
        *,
        file: str,
        old_str: str,
        new_str: str,
        sudo: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[ResponseFileReplaceResult]:
        """
        Replace string in file

        Parameters
        ----------
        file : str
            Absolute file path

        old_str : str
            Original string to replace

        new_str : str
            New string to replace with

        sudo : typing.Optional[bool]
            Whether to use sudo privileges

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ResponseFileReplaceResult]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v1/file/replace",
            method="POST",
            json={
                "file": file,
                "old_str": old_str,
                "new_str": new_str,
                "sudo": sudo,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ResponseFileReplaceResult,
                    parse_obj_as(
                        type_=ResponseFileReplaceResult,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def search_in_file(
        self,
        *,
        file: str,
        regex: str,
        sudo: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[ResponseFileSearchResult]:
        """
        Search in file content

        Parameters
        ----------
        file : str
            Absolute file path

        regex : str
            Regular expression pattern

        sudo : typing.Optional[bool]
            Whether to use sudo privileges

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ResponseFileSearchResult]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v1/file/search",
            method="POST",
            json={
                "file": file,
                "regex": regex,
                "sudo": sudo,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ResponseFileSearchResult,
                    parse_obj_as(
                        type_=ResponseFileSearchResult,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def find_files(
        self, *, path: str, glob: str, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[ResponseFileFindResult]:
        """
        Find files by name pattern

        Parameters
        ----------
        path : str
            Directory path to search

        glob : str
            Filename pattern (glob syntax)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ResponseFileFindResult]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v1/file/find",
            method="POST",
            json={
                "path": path,
                "glob": glob,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ResponseFileFindResult,
                    parse_obj_as(
                        type_=ResponseFileFindResult,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def upload_file(
        self,
        *,
        file: core.File,
        path: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[ResponseFileUploadResult]:
        """
        Upload file using streaming

        Parameters
        ----------
        file : core.File
            See core.File for more documentation

        path : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ResponseFileUploadResult]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v1/file/upload",
            method="POST",
            data={
                "path": path,
            },
            files={
                "file": file,
            },
            request_options=request_options,
            omit=OMIT,
            force_multipart=True,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ResponseFileUploadResult,
                    parse_obj_as(
                        type_=ResponseFileUploadResult,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    @contextlib.asynccontextmanager
    async def download_file(
        self, *, path: str, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.AsyncIterator[AsyncHttpResponse[typing.AsyncIterator[bytes]]]:
        """
        Download file using FileResponse

        Parameters
        ----------
        path : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration. You can pass in configuration such as `chunk_size`, and more to customize the request and response.

        Returns
        -------
        typing.AsyncIterator[AsyncHttpResponse[typing.AsyncIterator[bytes]]]
            Successful Response
        """
        async with self._client_wrapper.httpx_client.stream(
            "v1/file/download",
            method="GET",
            params={
                "path": path,
            },
            request_options=request_options,
        ) as _response:

            async def _stream() -> AsyncHttpResponse[typing.AsyncIterator[bytes]]:
                try:
                    if 200 <= _response.status_code < 300:
                        _chunk_size = request_options.get("chunk_size", None) if request_options is not None else None
                        return AsyncHttpResponse(
                            response=_response,
                            data=(_chunk async for _chunk in _response.aiter_bytes(chunk_size=_chunk_size)),
                        )
                    await _response.aread()
                    if _response.status_code == 422:
                        raise UnprocessableEntityError(
                            headers=dict(_response.headers),
                            body=typing.cast(
                                HttpValidationError,
                                parse_obj_as(
                                    type_=HttpValidationError,  # type: ignore
                                    object_=_response.json(),
                                ),
                            ),
                        )
                    _response_json = _response.json()
                except JSONDecodeError:
                    raise ApiError(
                        status_code=_response.status_code, headers=dict(_response.headers), body=_response.text
                    )
                raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

            yield await _stream()

    async def list_path(
        self,
        *,
        path: str,
        recursive: typing.Optional[bool] = OMIT,
        show_hidden: typing.Optional[bool] = OMIT,
        file_types: typing.Optional[typing.Sequence[str]] = OMIT,
        max_depth: typing.Optional[int] = OMIT,
        include_size: typing.Optional[bool] = OMIT,
        include_permissions: typing.Optional[bool] = OMIT,
        sort_by: typing.Optional[str] = OMIT,
        sort_desc: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[ResponseFileListResult]:
        """
        List path contents with flexible options

        Parameters
        ----------
        path : str
            Directory path to list

        recursive : typing.Optional[bool]
            Whether to list recursively

        show_hidden : typing.Optional[bool]
            Whether to show hidden files

        file_types : typing.Optional[typing.Sequence[str]]
            Filter by file extensions (e.g., ['.py', '.txt'])

        max_depth : typing.Optional[int]
            Maximum depth for recursive listing

        include_size : typing.Optional[bool]
            Whether to include file size information

        include_permissions : typing.Optional[bool]
            Whether to include file permissions

        sort_by : typing.Optional[str]
            Sort by: name, size, modified, type

        sort_desc : typing.Optional[bool]
            Sort in descending order

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ResponseFileListResult]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v1/file/list",
            method="POST",
            json={
                "path": path,
                "recursive": recursive,
                "show_hidden": show_hidden,
                "file_types": file_types,
                "max_depth": max_depth,
                "include_size": include_size,
                "include_permissions": include_permissions,
                "sort_by": sort_by,
                "sort_desc": sort_desc,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ResponseFileListResult,
                    parse_obj_as(
                        type_=ResponseFileListResult,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def str_replace_editor(
        self,
        *,
        command: Command,
        path: str,
        file_text: typing.Optional[str] = OMIT,
        old_str: typing.Optional[str] = OMIT,
        new_str: typing.Optional[str] = OMIT,
        insert_line: typing.Optional[int] = OMIT,
        view_range: typing.Optional[typing.Sequence[int]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[ResponseStrReplaceEditorResult]:
        """
        An filesystem editor tool that allows the agent to
        - view
        - create
        - navigate
        - edit files
        The tool parameters are defined by Anthropic and are not editable.

        Parameters
        ----------
        command : Command
            The commands to run. Allowed options are: `view`, `create`, `str_replace`, `insert`, `undo_edit`.

        path : str
            Absolute path to file or directory, e.g. `/workspace/file.py` or `/workspace`.

        file_text : typing.Optional[str]
            Required parameter of `create` command, with the content of the file to be created.

        old_str : typing.Optional[str]
            Required parameter of `str_replace` command containing the string in `path` to replace.

        new_str : typing.Optional[str]
            Optional parameter of `str_replace` command containing the new string (if not given, no string will be added). Required parameter of `insert` command containing the string to insert.

        insert_line : typing.Optional[int]
            Required parameter of `insert` command. The `new_str` will be inserted AFTER the line `insert_line` of `path`.

        view_range : typing.Optional[typing.Sequence[int]]
            Optional parameter of `view` command when `path` points to a file. If none is given, the full file is shown. If provided, the file will be shown in the indicated line number range, e.g. [11, 12] will show lines 11 and 12. Indexing at 1 to start. Setting `[start_line, -1]` shows all lines from `start_line` to the end of the file.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ResponseStrReplaceEditorResult]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v1/file/str_replace_editor",
            method="POST",
            json={
                "command": command,
                "path": path,
                "file_text": file_text,
                "old_str": old_str,
                "new_str": new_str,
                "insert_line": insert_line,
                "view_range": view_range,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ResponseStrReplaceEditorResult,
                    parse_obj_as(
                        type_=ResponseStrReplaceEditorResult,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
