# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.response_node_js_execute_response import ResponseNodeJsExecuteResponse
from ..types.response_node_js_runtime_info import ResponseNodeJsRuntimeInfo
from .raw_client import AsyncRawNodejsClient, RawNodejsClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class NodejsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawNodejsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawNodejsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawNodejsClient
        """
        return self._raw_client

    def execute_code(
        self,
        *,
        code: str,
        timeout: typing.Optional[int] = OMIT,
        stdin: typing.Optional[str] = OMIT,
        files: typing.Optional[typing.Dict[str, typing.Optional[str]]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ResponseNodeJsExecuteResponse:
        """
        Execute JavaScript code using Node.js

        This endpoint allows you to execute JavaScript code and get results back.
        Each request creates a fresh execution environment that's cleaned up automatically.

        Parameters
        ----------
        code : str
            JavaScript code to execute

        timeout : typing.Optional[int]
            Execution timeout in seconds

        stdin : typing.Optional[str]
            Standard input for the process

        files : typing.Optional[typing.Dict[str, typing.Optional[str]]]
            Additional files to create in execution directory

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ResponseNodeJsExecuteResponse
            Successful Response

        Examples
        --------
        from agent_sandbox import Sandbox

        client = Sandbox(
            base_url="https://yourhost.com/path/to/api",
        )
        client.nodejs.execute_code(
            code="code",
        )
        """
        _response = self._raw_client.execute_code(
            code=code, timeout=timeout, stdin=stdin, files=files, request_options=request_options
        )
        return _response.data

    def get_info(self, *, request_options: typing.Optional[RequestOptions] = None) -> ResponseNodeJsRuntimeInfo:
        """
        Get information about Node.js runtime and available languages

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ResponseNodeJsRuntimeInfo
            Successful Response

        Examples
        --------
        from agent_sandbox import Sandbox

        client = Sandbox(
            base_url="https://yourhost.com/path/to/api",
        )
        client.nodejs.get_info()
        """
        _response = self._raw_client.get_info(request_options=request_options)
        return _response.data


class AsyncNodejsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawNodejsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawNodejsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawNodejsClient
        """
        return self._raw_client

    async def execute_code(
        self,
        *,
        code: str,
        timeout: typing.Optional[int] = OMIT,
        stdin: typing.Optional[str] = OMIT,
        files: typing.Optional[typing.Dict[str, typing.Optional[str]]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ResponseNodeJsExecuteResponse:
        """
        Execute JavaScript code using Node.js

        This endpoint allows you to execute JavaScript code and get results back.
        Each request creates a fresh execution environment that's cleaned up automatically.

        Parameters
        ----------
        code : str
            JavaScript code to execute

        timeout : typing.Optional[int]
            Execution timeout in seconds

        stdin : typing.Optional[str]
            Standard input for the process

        files : typing.Optional[typing.Dict[str, typing.Optional[str]]]
            Additional files to create in execution directory

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ResponseNodeJsExecuteResponse
            Successful Response

        Examples
        --------
        import asyncio

        from agent_sandbox import AsyncSandbox

        client = AsyncSandbox(
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.nodejs.execute_code(
                code="code",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.execute_code(
            code=code, timeout=timeout, stdin=stdin, files=files, request_options=request_options
        )
        return _response.data

    async def get_info(self, *, request_options: typing.Optional[RequestOptions] = None) -> ResponseNodeJsRuntimeInfo:
        """
        Get information about Node.js runtime and available languages

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ResponseNodeJsRuntimeInfo
            Successful Response

        Examples
        --------
        import asyncio

        from agent_sandbox import AsyncSandbox

        client = AsyncSandbox(
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.nodejs.get_info()


        asyncio.run(main())
        """
        _response = await self._raw_client.get_info(request_options=request_options)
        return _response.data
