# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ..core.api_error import ApiError
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.http_response import AsyncHttpResponse, HttpResponse
from ..core.pydantic_utilities import parse_obj_as
from ..core.request_options import RequestOptions
from ..errors.unprocessable_entity_error import UnprocessableEntityError
from ..types.http_validation_error import HttpValidationError
from ..types.response_node_js_execute_response import ResponseNodeJsExecuteResponse
from ..types.response_node_js_runtime_info import ResponseNodeJsRuntimeInfo

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawNodejsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def execute_code(
        self,
        *,
        code: str,
        timeout: typing.Optional[int] = OMIT,
        stdin: typing.Optional[str] = OMIT,
        files: typing.Optional[typing.Dict[str, typing.Optional[str]]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[ResponseNodeJsExecuteResponse]:
        """
        Execute JavaScript code using Node.js

        This endpoint allows you to execute JavaScript code and get results back.
        Each request creates a fresh execution environment that's cleaned up automatically.

        Parameters
        ----------
        code : str
            JavaScript code to execute

        timeout : typing.Optional[int]
            Execution timeout in seconds

        stdin : typing.Optional[str]
            Standard input for the process

        files : typing.Optional[typing.Dict[str, typing.Optional[str]]]
            Additional files to create in execution directory

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ResponseNodeJsExecuteResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "v1/nodejs/execute",
            method="POST",
            json={
                "code": code,
                "timeout": timeout,
                "stdin": stdin,
                "files": files,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ResponseNodeJsExecuteResponse,
                    parse_obj_as(
                        type_=ResponseNodeJsExecuteResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_info(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[ResponseNodeJsRuntimeInfo]:
        """
        Get information about Node.js runtime and available languages

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ResponseNodeJsRuntimeInfo]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "v1/nodejs/info",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ResponseNodeJsRuntimeInfo,
                    parse_obj_as(
                        type_=ResponseNodeJsRuntimeInfo,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawNodejsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def execute_code(
        self,
        *,
        code: str,
        timeout: typing.Optional[int] = OMIT,
        stdin: typing.Optional[str] = OMIT,
        files: typing.Optional[typing.Dict[str, typing.Optional[str]]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[ResponseNodeJsExecuteResponse]:
        """
        Execute JavaScript code using Node.js

        This endpoint allows you to execute JavaScript code and get results back.
        Each request creates a fresh execution environment that's cleaned up automatically.

        Parameters
        ----------
        code : str
            JavaScript code to execute

        timeout : typing.Optional[int]
            Execution timeout in seconds

        stdin : typing.Optional[str]
            Standard input for the process

        files : typing.Optional[typing.Dict[str, typing.Optional[str]]]
            Additional files to create in execution directory

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ResponseNodeJsExecuteResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v1/nodejs/execute",
            method="POST",
            json={
                "code": code,
                "timeout": timeout,
                "stdin": stdin,
                "files": files,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ResponseNodeJsExecuteResponse,
                    parse_obj_as(
                        type_=ResponseNodeJsExecuteResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_info(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[ResponseNodeJsRuntimeInfo]:
        """
        Get information about Node.js runtime and available languages

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ResponseNodeJsRuntimeInfo]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v1/nodejs/info",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ResponseNodeJsRuntimeInfo,
                    parse_obj_as(
                        type_=ResponseNodeJsRuntimeInfo,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
