# This file was auto-generated by Fern from our API Definition.

import typing
from abc import ABC, abstractmethod

from ..types.sandbox_response import SandboxResponse


class BaseProvider(ABC):
    """
    Base class for cloud provider implementations.
    
    All cloud providers should inherit from this class and implement
    the required sandbox management methods.
    """
    
    @abstractmethod
    def create_sandbox(self, function_id: str, **kwargs) -> SandboxResponse:
        """
        Create a new sandbox instance.
        
        Parameters
        ----------
        function_id : str
            The function ID for the sandbox
            
        Returns
        -------
        SandboxResponse
            The response containing sandbox creation details
        """
        pass
    
    @abstractmethod
    def delete_sandbox(self, function_id: str, sandbox_id: str, **kwargs) -> SandboxResponse:
        """
        Delete an existing sandbox instance.
        
        Parameters
        ----------
        function_id : str
            The function ID of the sandbox
        sandbox_id : str
            The ID of the sandbox to delete
            
        Returns
        -------
        SandboxResponse
            The response containing deletion status
        """
        pass
    
    @abstractmethod
    def get_sandbox(self, function_id: str, sandbox_id: str, **kwargs) -> SandboxResponse:
        """
        Get details of an existing sandbox instance.
        
        Parameters
        ----------
        function_id : str
            The function ID of the sandbox
        sandbox_id : str
            The ID of the sandbox to retrieve
            
        Returns
        -------
        SandboxResponse
            The response containing sandbox details
        """
        pass
    
    @abstractmethod
    def list_sandboxes(self, function_id: str, **kwargs) -> SandboxResponse:
        """
        List all sandbox instances for a function.
        
        Parameters
        ----------
        function_id : str
            The function ID to list sandboxes for
            
        Returns
        -------
        SandboxResponse
            The response containing list of sandboxes
        """
        pass
