# This file was auto-generated by Fern from our API Definition.

import typing

from .. import core
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.response_dict import ResponseDict
from ..types.response_skill_content_result import ResponseSkillContentResult
from ..types.response_skill_metadata import ResponseSkillMetadata
from ..types.response_skill_metadata_collection import ResponseSkillMetadataCollection
from ..types.response_skill_registration_result import ResponseSkillRegistrationResult
from .raw_client import AsyncRawSkillsClient, RawSkillsClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class SkillsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawSkillsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawSkillsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawSkillsClient
        """
        return self._raw_client

    def register_skills(
        self,
        *,
        file: core.File,
        path: typing.Optional[str] = OMIT,
        name: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ResponseSkillRegistrationResult:
        """
        Parameters
        ----------
        file : core.File
            See core.File for more documentation

        path : typing.Optional[str]

        name : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ResponseSkillRegistrationResult
            Successful Response

        Examples
        --------
        from agent_sandbox import Sandbox

        client = Sandbox(
            base_url="https://yourhost.com/path/to/api",
        )
        client.skills.register_skills()
        """
        _response = self._raw_client.register_skills(file=file, path=path, name=name, request_options=request_options)
        return _response.data

    def list_metadata(
        self, *, names: typing.Optional[str] = None, request_options: typing.Optional[RequestOptions] = None
    ) -> ResponseSkillMetadataCollection:
        """
        Parameters
        ----------
        names : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ResponseSkillMetadataCollection
            Successful Response

        Examples
        --------
        from agent_sandbox import Sandbox

        client = Sandbox(
            base_url="https://yourhost.com/path/to/api",
        )
        client.skills.list_metadata(
            names="names",
        )
        """
        _response = self._raw_client.list_metadata(names=names, request_options=request_options)
        return _response.data

    def clear_skills(self, *, request_options: typing.Optional[RequestOptions] = None) -> ResponseDict:
        """
        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ResponseDict
            Successful Response

        Examples
        --------
        from agent_sandbox import Sandbox

        client = Sandbox(
            base_url="https://yourhost.com/path/to/api",
        )
        client.skills.clear_skills()
        """
        _response = self._raw_client.clear_skills(request_options=request_options)
        return _response.data

    def delete_skill(
        self, name: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ResponseSkillMetadata:
        """
        Parameters
        ----------
        name : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ResponseSkillMetadata
            Successful Response

        Examples
        --------
        from agent_sandbox import Sandbox

        client = Sandbox(
            base_url="https://yourhost.com/path/to/api",
        )
        client.skills.delete_skill(
            name="name",
        )
        """
        _response = self._raw_client.delete_skill(name, request_options=request_options)
        return _response.data

    def get_content(
        self, name: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ResponseSkillContentResult:
        """
        Parameters
        ----------
        name : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ResponseSkillContentResult
            Successful Response

        Examples
        --------
        from agent_sandbox import Sandbox

        client = Sandbox(
            base_url="https://yourhost.com/path/to/api",
        )
        client.skills.get_content(
            name="name",
        )
        """
        _response = self._raw_client.get_content(name, request_options=request_options)
        return _response.data


class AsyncSkillsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawSkillsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawSkillsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawSkillsClient
        """
        return self._raw_client

    async def register_skills(
        self,
        *,
        file: core.File,
        path: typing.Optional[str] = OMIT,
        name: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ResponseSkillRegistrationResult:
        """
        Parameters
        ----------
        file : core.File
            See core.File for more documentation

        path : typing.Optional[str]

        name : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ResponseSkillRegistrationResult
            Successful Response

        Examples
        --------
        import asyncio

        from agent_sandbox import AsyncSandbox

        client = AsyncSandbox(
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.skills.register_skills()


        asyncio.run(main())
        """
        _response = await self._raw_client.register_skills(
            file=file, path=path, name=name, request_options=request_options
        )
        return _response.data

    async def list_metadata(
        self, *, names: typing.Optional[str] = None, request_options: typing.Optional[RequestOptions] = None
    ) -> ResponseSkillMetadataCollection:
        """
        Parameters
        ----------
        names : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ResponseSkillMetadataCollection
            Successful Response

        Examples
        --------
        import asyncio

        from agent_sandbox import AsyncSandbox

        client = AsyncSandbox(
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.skills.list_metadata(
                names="names",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.list_metadata(names=names, request_options=request_options)
        return _response.data

    async def clear_skills(self, *, request_options: typing.Optional[RequestOptions] = None) -> ResponseDict:
        """
        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ResponseDict
            Successful Response

        Examples
        --------
        import asyncio

        from agent_sandbox import AsyncSandbox

        client = AsyncSandbox(
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.skills.clear_skills()


        asyncio.run(main())
        """
        _response = await self._raw_client.clear_skills(request_options=request_options)
        return _response.data

    async def delete_skill(
        self, name: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ResponseSkillMetadata:
        """
        Parameters
        ----------
        name : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ResponseSkillMetadata
            Successful Response

        Examples
        --------
        import asyncio

        from agent_sandbox import AsyncSandbox

        client = AsyncSandbox(
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.skills.delete_skill(
                name="name",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete_skill(name, request_options=request_options)
        return _response.data

    async def get_content(
        self, name: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ResponseSkillContentResult:
        """
        Parameters
        ----------
        name : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ResponseSkillContentResult
            Successful Response

        Examples
        --------
        import asyncio

        from agent_sandbox import AsyncSandbox

        client = AsyncSandbox(
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.skills.get_content(
                name="name",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_content(name, request_options=request_options)
        return _response.data
