# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .language import Language


class CodeExecuteResponse(UniversalBaseModel):
    """
    Unified code execution response model
    """

    language: Language = pydantic.Field()
    """
    Runtime language that executed the code
    """

    status: str = pydantic.Field()
    """
    Execution status indicator
    """

    outputs: typing.Optional[typing.List[typing.Dict[str, typing.Optional[typing.Any]]]] = pydantic.Field(default=None)
    """
    Structured execution outputs
    """

    code: str = pydantic.Field()
    """
    Echo of executed code
    """

    stdout: typing.Optional[str] = pydantic.Field(default=None)
    """
    Captured standard output stream
    """

    stderr: typing.Optional[str] = pydantic.Field(default=None)
    """
    Captured standard error stream
    """

    exit_code: typing.Optional[int] = pydantic.Field(default=None)
    """
    Process exit code when applicable
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
