# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .language import Language


class CodeLanguageInfo(UniversalBaseModel):
    """
    Metadata about a supported code runtime
    """

    language: Language = pydantic.Field()
    """
    Supported language identifier
    """

    description: str = pydantic.Field()
    """
    Human readable runtime description
    """

    runtime_version: typing.Optional[str] = pydantic.Field(default=None)
    """
    Primary runtime version identifier
    """

    default_timeout: typing.Optional[int] = pydantic.Field(default=None)
    """
    Default timeout in seconds
    """

    max_timeout: typing.Optional[int] = pydantic.Field(default=None)
    """
    Maximum allowed timeout in seconds
    """

    details: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = pydantic.Field(default=None)
    """
    Additional runtime specific metadata
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
