# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class DependencyCommandResult(UniversalBaseModel):
    command: typing.List[str] = pydantic.Field()
    """
    Executed dependency command
    """

    success: bool = pydantic.Field()
    """
    Whether the command succeeded
    """

    stdout: typing.Optional[str] = pydantic.Field(default=None)
    """
    Standard output from command
    """

    stderr: typing.Optional[str] = pydantic.Field(default=None)
    """
    Standard error from command
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
