# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class JupyterCreateSessionResponse(UniversalBaseModel):
    """
    Jupyter session creation response model
    """

    session_id: str = pydantic.Field()
    """
    Unique identifier of the created session
    """

    kernel_name: str = pydantic.Field()
    """
    Name of the kernel associated with the session
    """

    message: str = pydantic.Field()
    """
    Status message about session creation
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
