# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .jupyter_output import JupyterOutput


class JupyterExecuteResponse(UniversalBaseModel):
    """
    Jupyter code execution response model
    """

    kernel_name: str = pydantic.Field()
    """
    Name of the kernel used for execution
    """

    session_id: str = pydantic.Field()
    """
    Session ID for this kernel instance
    """

    status: str = pydantic.Field()
    """
    Execution status: ok, error, or timeout
    """

    execution_count: typing.Optional[int] = pydantic.Field(default=None)
    """
    Execution count from the kernel
    """

    outputs: typing.List[JupyterOutput] = pydantic.Field()
    """
    List of execution outputs
    """

    code: str = pydantic.Field()
    """
    The executed code
    """

    msg_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Message ID from Jupyter kernel
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
