# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class NodeJsRuntimeInfo(UniversalBaseModel):
    """
    NodeJS runtime information model
    """

    node_version: str = pydantic.Field()
    """
    Node.js version
    """

    npm_version: str = pydantic.Field()
    """
    npm version
    """

    supported_languages: typing.List[str] = pydantic.Field()
    """
    List of supported languages
    """

    description: str = pydantic.Field()
    """
    Service description
    """

    runtime_directory: typing.Optional[str] = pydantic.Field(default=None)
    """
    Runtime directory path
    """

    error: typing.Optional[str] = pydantic.Field(default=None)
    """
    Error message if runtime info retrieval failed
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
