# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .annotations import Annotations
from .icon import Icon


class ResourceLink(UniversalBaseModel):
    """
    A resource that the server is capable of reading, included in a prompt or tool call result.

    Note: resource links returned by tools are not guaranteed to appear in the results of `resources/list` requests.
    """

    name: str
    title: typing.Optional[str] = None
    uri: str
    description: typing.Optional[str] = None
    mime_type: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="mimeType")] = None
    size: typing.Optional[int] = None
    icons: typing.Optional[typing.List[Icon]] = None
    annotations: typing.Optional[Annotations] = None
    meta: typing_extensions.Annotated[
        typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]], FieldMetadata(alias="_meta")
    ] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
