# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class ShellSessionInfo(UniversalBaseModel):
    """
    Shell session information
    """

    working_dir: str = pydantic.Field()
    """
    Working directory
    """

    created_at: dt.datetime = pydantic.Field()
    """
    Creation timestamp
    """

    last_used_at: dt.datetime = pydantic.Field()
    """
    Last used timestamp
    """

    age_seconds: int = pydantic.Field()
    """
    Age of session in seconds
    """

    status: str = pydantic.Field()
    """
    Session status
    """

    current_command: typing.Optional[str] = pydantic.Field(default=None)
    """
    Currently executing command
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
