# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .dependency_command_result import DependencyCommandResult


class SkillRegistrationItem(UniversalBaseModel):
    name: str = pydantic.Field()
    """
    Skill name
    """

    path: str = pydantic.Field()
    """
    Absolute path to the skill directory
    """

    metadata: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = pydantic.Field(default=None)
    """
    Metadata parsed from SKILL.md front matter
    """

    dependency_commands: typing.Optional[typing.List[DependencyCommandResult]] = pydantic.Field(default=None)
    """
    Dependency commands executed for the skill
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
