# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.response import Response
from .raw_client import AsyncRawUtilClient, RawUtilClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class UtilClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawUtilClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawUtilClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawUtilClient
        """
        return self._raw_client

    def convert_to_markdown(self, *, uri: str, request_options: typing.Optional[RequestOptions] = None) -> Response:
        """
        Convert a given URI to Markdown format

        Parameters
        ----------
        uri : str
            The URI of the resource to convert

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Response
            Successful Response

        Examples
        --------
        from agent_sandbox import Sandbox

        client = Sandbox(
            base_url="https://yourhost.com/path/to/api",
        )
        client.util.convert_to_markdown(
            uri="uri",
        )
        """
        _response = self._raw_client.convert_to_markdown(uri=uri, request_options=request_options)
        return _response.data


class AsyncUtilClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawUtilClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawUtilClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawUtilClient
        """
        return self._raw_client

    async def convert_to_markdown(
        self, *, uri: str, request_options: typing.Optional[RequestOptions] = None
    ) -> Response:
        """
        Convert a given URI to Markdown format

        Parameters
        ----------
        uri : str
            The URI of the resource to convert

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Response
            Successful Response

        Examples
        --------
        import asyncio

        from agent_sandbox import AsyncSandbox

        client = AsyncSandbox(
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.util.convert_to_markdown(
                uri="uri",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.convert_to_markdown(uri=uri, request_options=request_options)
        return _response.data
