/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.util.collections;

import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Set;
import org.semanticweb.elk.util.collections.DirectAccess;
import org.semanticweb.elk.util.collections.LinearProbing;
import org.semanticweb.elk.util.collections.LinearProbingIterator;

public class ArrayHashSet<E>
extends AbstractSet<E>
implements Set<E>,
DirectAccess<E> {
    transient E[] data;
    transient int size;

    public ArrayHashSet(int initialCapacity) {
        int capacity = LinearProbing.getInitialCapacity(initialCapacity);
        this.data = new Object[capacity];
        this.size = 0;
    }

    public ArrayHashSet() {
        int capacity = 16;
        this.data = new Object[capacity];
        this.size = 0;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    private void enlarge() {
        int oldCapacity = this.data.length;
        if (oldCapacity == 0x40000000) {
            throw new IllegalArgumentException("The set cannot grow beyond the capacity: 1073741824");
        }
        E[] oldData = this.data;
        int newCapacity = oldCapacity << 1;
        Object[] newData = new Object[newCapacity];
        for (int i = 0; i < oldCapacity; ++i) {
            E e = oldData[i];
            if (e == null) continue;
            LinearProbing.add(newData, e);
        }
        this.data = newData;
    }

    private void shrink() {
        int oldCapacity = this.data.length;
        if (oldCapacity == 1) {
            return;
        }
        E[] oldData = this.data;
        int newCapacity = oldCapacity >> 1;
        Object[] newData = new Object[newCapacity];
        for (int i = 0; i < oldCapacity; ++i) {
            E e = oldData[i];
            if (e == null) continue;
            LinearProbing.add(newData, e);
        }
        this.data = newData;
    }

    @Override
    public boolean contains(Object o) {
        if (o == null) {
            throw new NullPointerException();
        }
        return LinearProbing.contains(this.data, o);
    }

    @Override
    public boolean add(E e) {
        if (e == null) {
            throw new NullPointerException();
        }
        boolean added = LinearProbing.add(this.data, e);
        if (added && ++this.size == LinearProbing.getUpperSize(this.data.length)) {
            this.enlarge();
        }
        return added;
    }

    @Override
    public boolean remove(Object o) {
        if (o == null) {
            throw new NullPointerException();
        }
        boolean removed = LinearProbing.remove(this.data, o);
        if (removed && --this.size == LinearProbing.getLowerSize(this.data.length)) {
            this.shrink();
        }
        return removed;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean modified = false;
        for (Object o : c) {
            modified |= this.remove(o);
        }
        return modified;
    }

    @Override
    public Iterator<E> iterator() {
        return new ElementIterator();
    }

    @Override
    public void clear() {
        int capacity = this.data.length >> 2;
        if (capacity == 0) {
            capacity = 1;
        }
        this.size = 0;
        this.data = new Object[capacity];
    }

    @Override
    public String toString() {
        return Arrays.toString(this.toArray());
    }

    @Override
    public E[] getRawData() {
        return this.data;
    }

    private class ElementIterator
    extends LinearProbingIterator<E, E> {
        ElementIterator() {
            super(ArrayHashSet.this.data, ArrayHashSet.this.size);
            this.init();
        }

        @Override
        void checkSize(int expectedSize) {
            if (expectedSize != ArrayHashSet.this.size) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        void remove(int pos) {
            LinearProbing.remove(this.dataSnapshot, pos);
            --ArrayHashSet.this.size;
        }

        @Override
        E getValue(E element, int pos) {
            return element;
        }
    }
}

