/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.util.collections;

import java.util.Iterator;
import java.util.NoSuchElementException;

abstract class LinearProbingIterator<E, V>
implements Iterator<V> {
    final E[] dataSnapshot;
    private int sizeSnapshot_;
    private int start_;
    private int current_;
    private int next_;

    LinearProbingIterator(E[] data, int size) {
        this.dataSnapshot = data;
        this.sizeSnapshot_ = size;
    }

    void init() {
        this.start_ = this.seekFirstNull();
        this.current_ = this.next_ = this.seekNext(this.start_);
    }

    abstract void checkSize(int var1);

    abstract void remove(int var1);

    abstract V getValue(E var1, int var2);

    int seekFirstNull() {
        for (int pos = 0; pos < this.dataSnapshot.length; ++pos) {
            if (this.dataSnapshot[pos] != null) continue;
            return pos;
        }
        throw new RuntimeException("Set is full! (" + this.dataSnapshot.length + " elements)");
    }

    boolean isOccupied(int pos) {
        return this.dataSnapshot[pos] != null;
    }

    int seekNext(int pos) {
        do {
            if (++pos != this.dataSnapshot.length) continue;
            pos = 0;
        } while (pos != this.start_ && !this.isOccupied(pos));
        return pos;
    }

    @Override
    public boolean hasNext() {
        return this.next_ != this.start_;
    }

    @Override
    public V next() {
        this.checkSize(this.sizeSnapshot_);
        if (this.next_ == this.start_) {
            throw new NoSuchElementException();
        }
        this.current_ = this.next_;
        E element = this.dataSnapshot[this.current_];
        this.next_ = this.seekNext(this.current_);
        return this.getValue(element, this.current_);
    }

    @Override
    public void remove() {
        this.checkSize(this.sizeSnapshot_);
        if (this.current_ == this.next_) {
            throw new IllegalStateException();
        }
        this.remove(this.current_);
        if (this.isOccupied(this.current_)) {
            this.next_ = this.current_;
        } else {
            this.current_ = this.next_;
        }
        --this.sizeSnapshot_;
    }
}

