/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.util.collections;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import org.semanticweb.elk.util.collections.AbstractEvictor;
import org.semanticweb.elk.util.collections.Evictor;
import org.semanticweb.elk.util.collections.Evictors;
import org.semanticweb.elk.util.statistics.Stat;

public class RecencyEvictor<E>
extends AbstractEvictor<E> {
    private static final int DEFAULT_ELEMENTS_CAPACITY_ = 128;
    private static final float DEFAULT_ELEMENTS_LOAD_FACTOR_ = 0.75f;
    private final LinkedHashMap<E, Boolean> elements_ = new LinkedHashMap(128, 0.75f, true);
    private final double loadFactor_;
    private int capacity_;

    RecencyEvictor(int capacity, double loadFactor) {
        this.capacity_ = capacity;
        this.loadFactor_ = loadFactor;
        this.stats = new Stats();
    }

    @Override
    public void add(E element) {
        this.elements_.put(element, true);
    }

    @Override
    public Iterator<E> evict(Predicate<E> retain) {
        Preconditions.checkNotNull(retain);
        if (this.elements_.size() <= this.capacity_) {
            return Collections.emptyList().iterator();
        }
        int goalCapacity = (int)((double)this.capacity_ * this.loadFactor_);
        ArrayList<E> evicted = new ArrayList<E>(goalCapacity < this.elements_.size() ? this.elements_.size() - goalCapacity : 0);
        Iterator<E> iterator = this.elements_.keySet().iterator();
        while (iterator.hasNext() && this.elements_.size() > goalCapacity) {
            E element = iterator.next();
            if (retain.apply(element)) continue;
            evicted.add(element);
            iterator.remove();
        }
        return evicted.iterator();
    }

    public int getCapacity() {
        return this.capacity_;
    }

    public void setCapacity(int capacity) {
        if (0 > capacity) {
            throw new IllegalArgumentException("Capacity cannot be negative!");
        }
        this.capacity_ = capacity;
    }

    public int size() {
        return this.elements_.size();
    }

    protected class Stats {
        protected Stats() {
        }

        @Stat
        public int capacity() {
            return RecencyEvictor.this.getCapacity();
        }

        @Stat
        public int size() {
            return RecencyEvictor.this.size();
        }
    }

    public static class Builder
    extends ProtectedBuilder<Builder>
    implements Evictor.Builder {
        @Override
        protected Builder convertThis() {
            return this;
        }

        public static Builder valueOf(String value) {
            String[] args = Evictors.parseArgs(value, RecencyEvictor.class, 2);
            String capacityArg = args[0].trim();
            String loadFactorArg = args[1].trim();
            int capacity = capacityArg.isEmpty() ? 128 : Integer.valueOf(capacityArg);
            double loadFactor = loadFactorArg.isEmpty() ? 0.75 : Double.valueOf(loadFactorArg);
            return (Builder)((Builder)new Builder().capacity(capacity < 0 ? Integer.MAX_VALUE : capacity)).loadFactor(loadFactor);
        }

        public String toString() {
            return String.format("%s(%d,%f)", RecencyEvictor.class.getName(), this.capacity_, this.loadFactor_);
        }
    }

    protected static abstract class ProtectedBuilder<B extends ProtectedBuilder<B>> {
        public static final int DEFAULT_CAPACITY = 128;
        public static final double DEFAULT_LOAD_FACTOR = 0.75;
        protected int capacity_ = 128;
        protected double loadFactor_ = 0.75;

        protected ProtectedBuilder() {
        }

        public B capacity(int capacity) throws IllegalArgumentException {
            if (0 > capacity) {
                throw new IllegalArgumentException("Capacity cannot be negative!");
            }
            this.capacity_ = capacity;
            return this.convertThis();
        }

        public B loadFactor(double loadFactor) throws IllegalArgumentException {
            if (0.0 > loadFactor || loadFactor > 1.0) {
                throw new IllegalArgumentException("Load factor must be between 0 and 1 inclusive!");
            }
            this.loadFactor_ = loadFactor;
            return this.convertThis();
        }

        public <E> Evictor<E> build() {
            return new RecencyEvictor(this.capacity_, this.loadFactor_);
        }

        protected abstract B convertThis();
    }
}

