/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.util.collections.entryset;

import java.util.AbstractCollection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.semanticweb.elk.util.collections.entryset.Entry;
import org.semanticweb.elk.util.collections.entryset.GenericStructuralObject;
import org.semanticweb.elk.util.collections.entryset.StructuralObject;

public class EntryCollection<E extends Entry<E>>
extends AbstractCollection<E> {
    static final int DEFAULT_INITIAL_CAPACITY = 16;
    static final int MAXIMUM_CAPACITY = 0x40000000;
    static final float DEFAULT_UNDERLOAD_FACTOR = 0.15f;
    static final float DEFAULT_OVERLOAD_FACTOR = 0.75f;
    transient E[] buckets;
    transient int size;
    int minsize;
    int undersize;
    int oversize;
    final float overloadFactor;
    final float underloadFactor;
    transient int modCount;

    public EntryCollection(int initialCapacity, float underloadFactor, float overloadFactor) {
        int capacity;
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal initial capacity: " + initialCapacity);
        }
        if (initialCapacity > 0x40000000) {
            initialCapacity = 0x40000000;
        }
        if (overloadFactor <= 0.0f || Float.isNaN(overloadFactor)) {
            throw new IllegalArgumentException("Illegal load factor: " + overloadFactor);
        }
        for (capacity = 1; capacity < initialCapacity; capacity <<= 1) {
        }
        this.underloadFactor = underloadFactor;
        this.overloadFactor = overloadFactor;
        this.minsize = initialCapacity;
        this.undersize = (int)((float)capacity * underloadFactor);
        this.oversize = (int)((float)capacity * overloadFactor);
        this.buckets = new Entry[capacity];
        this.init();
    }

    public EntryCollection(int initialCapacity) {
        this(initialCapacity, 0.15f, 0.75f);
    }

    public EntryCollection() {
        this.underloadFactor = 0.15f;
        this.overloadFactor = 0.75f;
        this.undersize = 2;
        this.oversize = 12;
        this.buckets = new Entry[16];
        this.init();
    }

    void init() {
    }

    static int hash(int h) {
        h ^= h >>> 20 ^ h >>> 12;
        return h ^ h >>> 7 ^ h >>> 4;
    }

    static int indexFor(int h, int length) {
        return EntryCollection.hash(h) & length - 1;
    }

    @Override
    public int size() {
        return this.size;
    }

    public <T extends GenericStructuralObject<T>> T findStructural(T key) {
        int h = key.structuralHashCode();
        int i = EntryCollection.indexFor(h, this.buckets.length);
        StructuralObject result = null;
        for (Object r = this.buckets[i]; r != null; r = (Entry)r.getNext()) {
            if (r.structuralHashCode() != h || (result = key.structuralEquals(r)) == null) continue;
            return (T)result;
        }
        return null;
    }

    public void addStructural(E entry) {
        if (entry.getNext() != null) {
            throw new IllegalArgumentException("The given entry should be fresh!");
        }
        int h = entry.structuralHashCode();
        int i = EntryCollection.indexFor(h, this.buckets.length);
        ++this.modCount;
        E e = this.buckets[i];
        entry.setNext(e);
        this.buckets[i] = entry;
        if (this.size++ >= this.oversize) {
            this.resize(2 * this.buckets.length);
        }
    }

    public <T extends GenericStructuralObject<T>> T removeStructural(T key) {
        E prev;
        int h = key.structuralHashCode();
        int i = EntryCollection.indexFor(h, this.buckets.length);
        Object r = prev = this.buckets[i];
        StructuralObject result = null;
        while (r != null) {
            Entry next = (Entry)r.getNext();
            if (r.structuralHashCode() == h && (result = key.structuralEquals(r)) != null) {
                ++this.modCount;
                if (prev == r) {
                    this.buckets[i] = next;
                } else {
                    prev.setNext((Entry)next);
                }
                if (this.size-- <= this.undersize && this.buckets.length >= 2 * this.minsize) {
                    this.resize(this.buckets.length / 2);
                }
                return (T)result;
            }
            prev = r;
            r = next;
        }
        return null;
    }

    void resize(int newCapacity) {
        E[] oldTable = this.buckets;
        int oldCapacity = oldTable.length;
        if (oldCapacity == 0x40000000) {
            this.oversize = Integer.MAX_VALUE;
            this.oversize = (int)((float)newCapacity * this.overloadFactor);
            return;
        }
        Entry[] newTable = new Entry[newCapacity];
        this.transfer(newTable);
        this.buckets = newTable;
        this.undersize = (int)((float)newCapacity * this.underloadFactor);
        this.oversize = (int)((float)newCapacity * this.overloadFactor);
    }

    void transfer(E[] newArray) {
        E[] src = this.buckets;
        int newCapacity = newArray.length;
        for (int j = 0; j < src.length; ++j) {
            Entry next;
            Object e = src[j];
            if (e == null) continue;
            src[j] = null;
            do {
                next = (Entry)e.getNext();
                int i = EntryCollection.indexFor(e.structuralHashCode(), newCapacity);
                e.setNext(newArray[i]);
                newArray[i] = e;
            } while ((e = next) != null);
        }
    }

    @Override
    public void clear() {
        ++this.modCount;
        E[] tab = this.buckets;
        for (int i = 0; i < tab.length; ++i) {
            tab[i] = null;
        }
        this.size = 0;
    }

    @Override
    public Iterator<E> iterator() {
        return new EntryIterator();
    }

    private class EntryIterator
    implements Iterator<E> {
        E prev;
        E current;
        E next;
        int expectedModCount;
        int curIndex;
        int nextIndex;

        EntryIterator() {
            this.expectedModCount = EntryCollection.this.modCount;
            if (EntryCollection.this.size > 0) {
                E[] t = EntryCollection.this.buckets;
                while (this.nextIndex < t.length && (this.next = t[this.nextIndex++]) == null) {
                }
            }
        }

        @Override
        public final boolean hasNext() {
            return this.next != null;
        }

        @Override
        public final E next() {
            if (EntryCollection.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            Object e = this.next;
            if (e == null) {
                throw new NoSuchElementException();
            }
            this.curIndex = this.nextIndex;
            this.next = (Entry)e.getNext();
            if (this.next == null) {
                E[] t = EntryCollection.this.buckets;
                while (this.nextIndex < t.length && (this.next = t[this.nextIndex++]) == null) {
                }
            }
            if (this.current != null) {
                this.prev = this.current;
            }
            this.current = e;
            return e;
        }

        @Override
        public void remove() {
            if (this.current == null) {
                throw new IllegalStateException();
            }
            if (EntryCollection.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (this.prev != null && this.prev.getNext() == this.current) {
                this.prev.setNext(this.current.getNext());
            } else {
                EntryCollection.this.buckets[this.curIndex - 1] = (Entry)this.current.getNext();
            }
            --EntryCollection.this.size;
            this.current = null;
        }
    }
}

