/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.util.statistics;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.semanticweb.elk.util.statistics.NestedStats;
import org.semanticweb.elk.util.statistics.ResetStats;
import org.semanticweb.elk.util.statistics.Stat;
import org.semanticweb.elk.util.statistics.StatsException;

public class Stats {
    public static final String STAT_NAME_SEPARATOR = ".";

    private Stats() {
    }

    public static Map<String, Object> copyIntoMap(Object hasStats, Map<String, Object> result) {
        if (result == null) {
            result = new HashMap<String, Object>();
        }
        Iterable<Map.Entry<String, Object>> stats = Stats.getStats(hasStats);
        for (Map.Entry<String, Object> e : stats) {
            result.put(e.getKey(), e.getValue());
        }
        return result;
    }

    public static Map<String, Object> copyIntoMap(Object hasStats) {
        return Stats.copyIntoMap(hasStats, new HashMap<String, Object>());
    }

    public static Iterable<Map.Entry<String, Object>> getStats(Object hasStats) {
        return Stats.getStats(hasStats, "");
    }

    public static Iterable<Map.Entry<String, Object>> getStats(Object hasStats, String statNamePrefix) {
        Preconditions.checkNotNull((Object)hasStats);
        Preconditions.checkNotNull((Object)statNamePrefix);
        if (hasStats instanceof Class) {
            return Stats.getStats((Class)hasStats, null, statNamePrefix);
        }
        return Stats.getStats(hasStats.getClass(), hasStats, statNamePrefix);
    }

    public static Iterable<Map.Entry<String, Object>> getStats(Class<?> hasStatsClass, final Object hasStats, final String statNamePrefix) {
        Preconditions.checkNotNull(hasStatsClass);
        Preconditions.checkNotNull((Object)statNamePrefix);
        Iterable statFields = Stats.getAnnotatedElements(Stat.class, (AnnotatedElement[])hasStatsClass.getFields());
        Iterable fieldStats = Iterables.transform((Iterable)statFields, (Function)new Function<Field, Map.Entry<String, Object>>(){

            public Map.Entry<String, Object> apply(Field field) {
                return new AbstractMap.SimpleImmutableEntry<String, Object>(statNamePrefix + Stats.getStatName(field), Stats.checkedGet(field, hasStats));
            }
        });
        Iterable statMethods = Stats.getAnnotatedElements(Stat.class, (AnnotatedElement[])hasStatsClass.getMethods());
        Iterable methodStats = Iterables.transform((Iterable)statMethods, (Function)new Function<Method, Map.Entry<String, Object>>(){

            public Map.Entry<String, Object> apply(Method method) {
                return new AbstractMap.SimpleImmutableEntry<String, Object>(statNamePrefix + Stats.getStatName(method), Stats.checkedInvoke(method, hasStats));
            }
        });
        Iterable<Map.Entry<String, Object>> nesteds = Stats.getNested(hasStatsClass, hasStats, statNamePrefix);
        Iterable nestedStats = Iterables.concat((Iterable)Iterables.transform(nesteds, (Function)new Function<Map.Entry<String, Object>, Iterable<Map.Entry<String, Object>>>(){

            public Iterable<Map.Entry<String, Object>> apply(Map.Entry<String, Object> entry) {
                return Stats.getStats(entry.getValue(), entry.getKey() + Stats.STAT_NAME_SEPARATOR);
            }
        }));
        return Iterables.concat((Iterable)fieldStats, (Iterable)methodStats, (Iterable)nestedStats);
    }

    public static void resetStats(Object hasStats) {
        Preconditions.checkNotNull((Object)hasStats);
        if (hasStats instanceof Class) {
            Stats.resetStats((Class)hasStats, null);
        } else {
            Stats.resetStats(hasStats.getClass(), hasStats);
        }
    }

    public static void resetStats(Class<?> hasStatsClass, Object hasStats) {
        Preconditions.checkNotNull(hasStatsClass);
        Iterable resetMethods = Stats.getAnnotatedElements(ResetStats.class, (AnnotatedElement[])hasStatsClass.getMethods());
        for (Method resetMethod : resetMethods) {
            Stats.checkedInvoke(resetMethod, hasStats);
        }
        Iterable<Map.Entry<String, Object>> nesteds = Stats.getNested(hasStatsClass, hasStats);
        for (Map.Entry<String, Object> entry : nesteds) {
            Stats.resetStats(entry.getValue());
        }
    }

    private static Iterable<Map.Entry<String, Object>> getNested(Class<?> hasStatsClass, Object hasStats) {
        return Stats.getNested(hasStatsClass, hasStats, "");
    }

    private static Iterable<Map.Entry<String, Object>> getNested(Class<?> hasStatsClass, final Object hasStats, final String statNamePrefix) {
        Preconditions.checkNotNull(hasStatsClass);
        Preconditions.checkNotNull((Object)statNamePrefix);
        Iterable nestedFields = Stats.getAnnotatedElements(NestedStats.class, (AnnotatedElement[])hasStatsClass.getFields());
        Iterable fieldNesteds = Iterables.transform((Iterable)nestedFields, (Function)new Function<Field, Map.Entry<String, Object>>(){

            public Map.Entry<String, Object> apply(Field field) {
                return new AbstractMap.SimpleImmutableEntry<String, Object>(statNamePrefix + Stats.getNestedStatsName(field), Stats.checkedGet(field, hasStats));
            }
        });
        Iterable nestedMethods = Stats.getAnnotatedElements(NestedStats.class, (AnnotatedElement[])hasStatsClass.getMethods());
        Iterable methodNesteds = Iterables.transform((Iterable)nestedMethods, (Function)new Function<Method, Map.Entry<String, Object>>(){

            public Map.Entry<String, Object> apply(Method method) {
                return new AbstractMap.SimpleImmutableEntry<String, Object>(statNamePrefix + Stats.getNestedStatsName(method), Stats.checkedInvoke(method, hasStats));
            }
        });
        return Iterables.concat((Iterable)fieldNesteds, (Iterable)methodNesteds);
    }

    private static Object checkedGet(Field field, Object object) {
        if (object == null && !Modifier.isStatic(field.getModifiers())) {
            throw new StatsException("Can handle only static fields! Non-static field: " + field);
        }
        try {
            return field.get(object);
        }
        catch (IllegalAccessException e) {
            throw new StatsException(e);
        }
    }

    private static Object checkedInvoke(Method method, Object object) {
        if (object == null && !Modifier.isStatic(method.getModifiers())) {
            throw new StatsException("Can handle only static methods! Non-static method: " + method);
        }
        if (method.getParameterTypes().length != 0) {
            throw new StatsException("Can handle only methods with no parameters! Method with parameters: " + method);
        }
        try {
            return method.invoke(object, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new StatsException(e);
        }
        catch (InvocationTargetException e) {
            throw new StatsException(e);
        }
    }

    private static <E extends AnnotatedElement> Iterable<E> getAnnotatedElements(final Class<? extends Annotation> presentAnnotation, E[] elements) {
        return Iterables.filter(Arrays.asList(elements), (Predicate)new Predicate<E>(){

            public boolean apply(E element) {
                return element.isAnnotationPresent(presentAnnotation);
            }
        });
    }

    private static <E extends AnnotatedElement & Member> String getStatName(E element) {
        String name = element.getAnnotation(Stat.class).name();
        return name.isEmpty() ? ((Member)element).getName() : name;
    }

    private static <E extends AnnotatedElement & Member> String getNestedStatsName(E element) {
        String name = element.getAnnotation(NestedStats.class).name();
        return name.isEmpty() ? ((Member)element).getName() : name;
    }
}

