/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact;

import conformance.Original;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomVisitorEx;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeListener;
import org.semanticweb.owlapi.model.parameters.AxiomAnnotations;
import org.semanticweb.owlapi.model.parameters.Imports;
import org.semanticweb.owlapi.reasoner.BufferingMode;
import org.semanticweb.owlapi.reasoner.FreshEntitiesException;
import org.semanticweb.owlapi.reasoner.FreshEntityPolicy;
import org.semanticweb.owlapi.reasoner.InconsistentOntologyException;
import org.semanticweb.owlapi.reasoner.IndividualNodeSetPolicy;
import org.semanticweb.owlapi.reasoner.InferenceType;
import org.semanticweb.owlapi.reasoner.Node;
import org.semanticweb.owlapi.reasoner.NodeSet;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.reasoner.OWLReasonerConfiguration;
import org.semanticweb.owlapi.reasoner.ReasonerInterruptedException;
import org.semanticweb.owlapi.reasoner.impl.OWLClassNodeSet;
import org.semanticweb.owlapi.reasoner.impl.OWLDataPropertyNode;
import org.semanticweb.owlapi.reasoner.impl.OWLDataPropertyNodeSet;
import org.semanticweb.owlapi.reasoner.impl.OWLObjectPropertyNodeSet;
import org.semanticweb.owlapi.reasoner.knowledgeexploration.OWLKnowledgeExplorerReasoner;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;
import org.semanticweb.owlapi.util.Version;
import org.semanticweb.owlapitools.decomposition.AxiomWrapper;
import org.semanticweb.owlapitools.decomposition.OntologyAtom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.manchester.cs.jfact.TranslationMachinery;
import uk.ac.manchester.cs.jfact.datatypes.DatatypeFactory;
import uk.ac.manchester.cs.jfact.helpers.LogAdapter;
import uk.ac.manchester.cs.jfact.kernel.DlCompletionTree;
import uk.ac.manchester.cs.jfact.kernel.ExpressionCache;
import uk.ac.manchester.cs.jfact.kernel.Individual;
import uk.ac.manchester.cs.jfact.kernel.Ontology;
import uk.ac.manchester.cs.jfact.kernel.ReasonerFreshEntityException;
import uk.ac.manchester.cs.jfact.kernel.ReasoningKernel;
import uk.ac.manchester.cs.jfact.kernel.actors.ClassPolicy;
import uk.ac.manchester.cs.jfact.kernel.actors.DataPropertyPolicy;
import uk.ac.manchester.cs.jfact.kernel.actors.IndividualPolicy;
import uk.ac.manchester.cs.jfact.kernel.actors.ObjectPropertyPolicy;
import uk.ac.manchester.cs.jfact.kernel.actors.TaxonomyActor;
import uk.ac.manchester.cs.jfact.kernel.dl.IndividualName;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.ConceptExpression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.DataRoleExpression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.Expression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.IndividualExpression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.ObjectRoleExpression;
import uk.ac.manchester.cs.jfact.kernel.options.JFactReasonerConfiguration;
import uk.ac.manchester.cs.owlapi.modularity.ModuleType;

public class JFactReasoner
implements OWLReasoner,
OWLOntologyChangeListener,
OWLKnowledgeExplorerReasoner,
Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(JFactReasoner.class);
    protected final AtomicBoolean interrupted = new AtomicBoolean(false);
    private ReasoningKernel kernel;
    private final ExpressionCache em;
    @Nonnull
    private static final EnumSet<InferenceType> supportedInferenceTypes = EnumSet.of(InferenceType.CLASS_ASSERTIONS, InferenceType.CLASS_HIERARCHY, InferenceType.DATA_PROPERTY_HIERARCHY, InferenceType.OBJECT_PROPERTY_HIERARCHY, InferenceType.SAME_INDIVIDUAL);
    private static final Collection<AxiomType<?>> types = Arrays.asList(AxiomType.DECLARATION, AxiomType.OBJECT_PROPERTY_RANGE, AxiomType.FUNCTIONAL_OBJECT_PROPERTY, AxiomType.DIFFERENT_INDIVIDUALS, AxiomType.EQUIVALENT_CLASSES, AxiomType.SYMMETRIC_OBJECT_PROPERTY, AxiomType.DATA_PROPERTY_DOMAIN, AxiomType.DISJOINT_CLASSES, AxiomType.SUBCLASS_OF, AxiomType.DATA_PROPERTY_RANGE, AxiomType.TRANSITIVE_OBJECT_PROPERTY, AxiomType.INVERSE_OBJECT_PROPERTIES, AxiomType.OBJECT_PROPERTY_DOMAIN, AxiomType.SUB_OBJECT_PROPERTY, AxiomType.DATA_PROPERTY_ASSERTION, AxiomType.DISJOINT_OBJECT_PROPERTIES, AxiomType.EQUIVALENT_OBJECT_PROPERTIES, AxiomType.SUB_PROPERTY_CHAIN_OF, AxiomType.INVERSE_FUNCTIONAL_OBJECT_PROPERTY, AxiomType.ASYMMETRIC_OBJECT_PROPERTY, AxiomType.REFLEXIVE_OBJECT_PROPERTY, AxiomType.IRREFLEXIVE_OBJECT_PROPERTY, AxiomType.DISJOINT_DATA_PROPERTIES, AxiomType.SUB_DATA_PROPERTY, AxiomType.EQUIVALENT_DATA_PROPERTIES, AxiomType.FUNCTIONAL_DATA_PROPERTY, AxiomType.DATATYPE_DEFINITION, AxiomType.DISJOINT_UNION, AxiomType.SAME_INDIVIDUAL, AxiomType.HAS_KEY, AxiomType.NEGATIVE_OBJECT_PROPERTY_ASSERTION, AxiomType.NEGATIVE_DATA_PROPERTY_ASSERTION, AxiomType.SUB_ANNOTATION_PROPERTY_OF, AxiomType.ANNOTATION_PROPERTY_DOMAIN, AxiomType.ANNOTATION_ASSERTION, AxiomType.ANNOTATION_PROPERTY_RANGE, AxiomType.SWRL_RULE, AxiomType.CLASS_ASSERTION, AxiomType.OBJECT_PROPERTY_ASSERTION);
    @Nonnull
    private final OWLOntology root;
    @Nonnull
    private final BufferingMode bufferingMode;
    @Nonnull
    private final List<OWLOntologyChange> rawChanges = new ArrayList<OWLOntologyChange>();
    @Nonnull
    private final List<OWLAxiom> axioms = new ArrayList<OWLAxiom>();
    @Original
    private final JFactReasonerConfiguration configuration;
    private final OWLDataFactory df;
    protected TranslationMachinery tr;
    private Boolean consistencyVerified = null;
    private final Set<OWLEntity> knownEntities = new HashSet<OWLEntity>();
    private final DatatypeFactory datatypeFactory;

    public JFactReasoner(OWLOntology o, OWLReasonerConfiguration c, BufferingMode b) {
        this(o, c instanceof JFactReasonerConfiguration ? (JFactReasonerConfiguration)c : new JFactReasonerConfiguration(c), b);
    }

    public JFactReasoner(OWLOntology rootOntology, Collection<OWLAxiom> axioms, JFactReasonerConfiguration config, BufferingMode bufferingMode) {
        this.configuration = config;
        this.root = rootOntology;
        this.df = this.root.getOWLOntologyManager().getOWLDataFactory();
        this.datatypeFactory = DatatypeFactory.getInstance();
        this.kernel = new ReasoningKernel(this.configuration, this.datatypeFactory, this.df);
        this.em = this.kernel.getExpressionManager();
        this.bufferingMode = bufferingMode;
        this.knownEntities.add((OWLEntity)this.df.getOWLThing());
        this.knownEntities.add((OWLEntity)this.df.getOWLNothing());
        OWLAPIStreamUtils.add(this.knownEntities, this.root.importsClosure().flatMap(o -> o.signature()));
        this.kernel.setInterruptedSwitch(this.interrupted);
        this.kernel.clearKB();
        this.configuration.getProgressMonitor().reasonerTaskStarted("Loading");
        this.configuration.getProgressMonitor().reasonerTaskBusy();
        this.tr = new TranslationMachinery(this.kernel, this.df, this.datatypeFactory);
        this.axioms.addAll(axioms);
        this.tr.loadAxioms(axioms.stream());
        this.configuration.getProgressMonitor().reasonerTaskStopped();
    }

    public JFactReasoner(OWLOntology rootOntology, JFactReasonerConfiguration config, BufferingMode bufferingMode) {
        this(rootOntology, JFactReasoner.importsIncluded(rootOntology), config, bufferingMode);
    }

    public static List<OWLAxiom> importsIncluded(OWLOntology ont) {
        ArrayList<OWLAxiom> list = new ArrayList<OWLAxiom>();
        ont.importsClosure().forEach(o -> types.forEach(t -> {
            boolean bl = OWLAPIStreamUtils.add((Collection)list, (Stream)o.axioms(t));
        }));
        return list;
    }

    public JFactReasonerConfiguration getConfiguration() {
        return this.configuration;
    }

    public Ontology getOntology() {
        return this.kernel.getOntology();
    }

    public synchronized Node<OWLClass> getEquivalentClasses(OWLClassExpression ce) {
        if (this.isFreshName(ce)) {
            return this.tr.getClassExpressionTranslator().node(Stream.empty());
        }
        this.checkConsistency();
        Stream<ConceptExpression> stream = this.kernel.getEquivalentConcepts(this.tr.pointer(ce), this.classActor()).getSynonyms().stream();
        return this.tr.getClassExpressionTranslator().node((Stream)stream);
    }

    private boolean isFreshName(OWLClassExpression ce) {
        if (ce.isAnonymous()) {
            return false;
        }
        return !this.knownEntities.contains(ce.asOWLClass());
    }

    public void ontologiesChanged(List<? extends OWLOntologyChange> changes) {
        this.rawChanges.addAll(changes);
        if (this.bufferingMode.equals((Object)BufferingMode.NON_BUFFERING)) {
            this.flush();
        }
    }

    public BufferingMode getBufferingMode() {
        return this.bufferingMode;
    }

    public long getTimeOut() {
        return this.configuration.getTimeOut();
    }

    public OWLOntology getRootOntology() {
        return this.root;
    }

    public synchronized List<OWLOntologyChange> getPendingChanges() {
        return new ArrayList<OWLOntologyChange>(this.rawChanges);
    }

    public synchronized Set<OWLAxiom> getPendingAxiomAdditions() {
        if (!this.rawChanges.isEmpty()) {
            return OWLAPIStreamUtils.asSet(this.rawChanges.stream().filter(OWLOntologyChange::isAddAxiom).map(c -> c.getAxiom()));
        }
        return Collections.emptySet();
    }

    public synchronized Set<OWLAxiom> getPendingAxiomRemovals() {
        if (!this.rawChanges.isEmpty()) {
            return OWLAPIStreamUtils.asSet(this.rawChanges.stream().filter(OWLOntologyChange::isRemoveAxiom).map(c -> c.getAxiom()));
        }
        return Collections.emptySet();
    }

    public synchronized void flush() {
        if (!this.rawChanges.isEmpty()) {
            HashSet<OWLAxiom> added = new HashSet<OWLAxiom>();
            HashSet<OWLAxiom> removed = new HashSet<OWLAxiom>();
            HashSet<OWLAxiom> reasonerAxioms = new HashSet<OWLAxiom>(this.axioms);
            for (OWLOntologyChange change : this.rawChanges) {
                OWLAxiom ax2 = change.getAxiom();
                if (change.isAddAxiom()) {
                    if (reasonerAxioms.contains(ax2) || reasonerAxioms.contains(ax2.getAxiomWithoutAnnotations())) continue;
                    added.add(ax2);
                    continue;
                }
                if (!change.isRemoveAxiom() || !reasonerAxioms.contains(ax2) && !reasonerAxioms.contains(ax2.getAxiomWithoutAnnotations())) continue;
                removed.add(change.getAxiom());
            }
            added.removeAll(removed);
            this.rawChanges.clear();
            if (!added.isEmpty() || !removed.isEmpty()) {
                reasonerAxioms.removeAll(removed);
                reasonerAxioms.addAll(added);
                this.axioms.clear();
                this.axioms.addAll(reasonerAxioms);
                this.knownEntities.clear();
                this.axioms.forEach(ax -> {
                    boolean bl = OWLAPIStreamUtils.add(this.knownEntities, (Stream)ax.signature());
                });
                this.consistencyVerified = null;
                this.handleChanges(added.stream(), removed.stream());
            }
        }
    }

    public FreshEntityPolicy getFreshEntityPolicy() {
        return this.configuration.getFreshEntityPolicy();
    }

    public IndividualNodeSetPolicy getIndividualNodeSetPolicy() {
        return this.configuration.getIndividualNodeSetPolicy();
    }

    private synchronized void handleChanges(Stream<OWLAxiom> addAxioms, Stream<OWLAxiom> removeAxioms) {
        this.tr.loadAxioms(addAxioms);
        removeAxioms.forEach(this.tr::retractAxiom);
    }

    public String getReasonerName() {
        return "JFact";
    }

    public Version getReasonerVersion() {
        return new Version(5, 0, 3, 0);
    }

    public void interrupt() {
        this.interrupted.set(true);
    }

    public synchronized void precomputeInferences(InferenceType ... inferenceTypes) {
        if (!this.kernel.isKBRealised() && Stream.of(inferenceTypes).anyMatch(supportedInferenceTypes::contains)) {
            this.kernel.realiseKB();
        }
    }

    public boolean isPrecomputed(InferenceType inferenceType) {
        if (supportedInferenceTypes.contains(inferenceType)) {
            return this.kernel.isKBRealised();
        }
        return true;
    }

    public Set<InferenceType> getPrecomputableInferenceTypes() {
        return supportedInferenceTypes;
    }

    public synchronized boolean isConsistent() {
        if (this.consistencyVerified == null) {
            try {
                this.consistencyVerified = this.kernel.isKBConsistent();
            }
            catch (InconsistentOntologyException e) {
                this.consistencyVerified = Boolean.FALSE;
            }
        }
        return this.consistencyVerified;
    }

    private void checkConsistency() {
        if (this.interrupted.get()) {
            throw new ReasonerInterruptedException();
        }
        if (!this.isConsistent()) {
            throw new InconsistentOntologyException();
        }
    }

    public synchronized boolean isSatisfiable(OWLClassExpression classExpression) {
        this.checkConsistency();
        return this.kernel.isSatisfiable(this.tr.pointer(classExpression));
    }

    public Node<OWLClass> getUnsatisfiableClasses() {
        return this.getBottomClassNode();
    }

    public synchronized boolean isEntailed(OWLAxiom axiom) {
        this.checkConsistency();
        if (this.root.containsAxiom(axiom, Imports.INCLUDED, AxiomAnnotations.IGNORE_AXIOM_ANNOTATIONS)) {
            return true;
        }
        try {
            return (Boolean)axiom.accept((OWLAxiomVisitorEx)this.tr.getEntailmentChecker());
        }
        catch (ReasonerFreshEntityException e) {
            IRI iri = e.getIri();
            if (this.getFreshEntityPolicy() == FreshEntityPolicy.DISALLOW) {
                Optional<OWLEntity> fresh = axiom.signature().filter(ent -> ent.getIRI().equals((Object)iri)).findAny();
                if (fresh.isPresent()) {
                    throw new FreshEntitiesException(fresh.get(), (Throwable)((Object)e));
                }
                throw new FreshEntitiesException((Collection)OWLAPIStreamUtils.asList((Stream)axiom.signature()), (Throwable)((Object)e));
            }
            LOGGER.warn("Fresh entity exception in the reasoner for entity: '{}'; defaulting to axiom not entailed", (Object)iri);
            return false;
        }
    }

    public synchronized boolean isEntailed(Set<? extends OWLAxiom> axioms) {
        return axioms.stream().allMatch(ax -> this.isEntailed((OWLAxiom)OWLAPIPreconditions.checkNotNull((Object)ax)));
    }

    public boolean isEntailmentCheckingSupported(AxiomType<?> axiomType) {
        return !axiomType.equals((Object)AxiomType.SWRL_RULE);
    }

    public synchronized Set<OWLAxiom> getTrace(OWLAxiom axiom) {
        this.kernel.needTracing();
        if (this.isEntailed(axiom)) {
            return OWLAPIStreamUtils.asSet(this.kernel.getTrace().map(AxiomWrapper::getAxiom).filter(ax -> ax != null));
        }
        return Collections.emptySet();
    }

    public Node<OWLClass> getTopClassNode() {
        return this.getEquivalentClasses((OWLClassExpression)this.df.getOWLThing());
    }

    public Node<OWLClass> getBottomClassNode() {
        return this.getEquivalentClasses((OWLClassExpression)this.df.getOWLNothing());
    }

    public synchronized NodeSet<OWLClass> getSubClasses(OWLClassExpression ce, boolean direct) {
        if (this.isFreshName(ce)) {
            if (this.configuration.getFreshEntityPolicy() == FreshEntityPolicy.DISALLOW) {
                throw new FreshEntitiesException((Collection)OWLAPIStreamUtils.asList((Stream)ce.signature()));
            }
            return new OWLClassNodeSet(this.getBottomClassNode());
        }
        this.checkConsistency();
        List<Collection<ConceptExpression>> pointers = this.kernel.getConcepts(this.tr.pointer(ce), direct, this.classActor(), false).getElements();
        Optional<Collection> empty = pointers.stream().filter(c -> c.isEmpty()).findAny();
        if (empty.isPresent()) {
            empty.get().addAll(this.bottomNode());
        } else if (pointers.isEmpty()) {
            pointers.add(this.bottomNode());
        }
        return this.tr.getClassExpressionTranslator().nodeSet(pointers.stream());
    }

    private Collection<ConceptExpression> bottomNode() {
        return this.kernel.getEquivalentConcepts(this.tr.pointer((OWLClassExpression)this.df.getOWLNothing()), this.classActor()).getSynonyms();
    }

    public synchronized NodeSet<OWLClass> getSuperClasses(OWLClassExpression ce, boolean direct) {
        if (this.isFreshName(ce)) {
            return new OWLClassNodeSet(this.getTopClassNode());
        }
        this.checkConsistency();
        Stream<Collection<ConceptExpression>> stream = this.askSuperClasses(this.tr.pointer(ce), direct).stream();
        return this.tr.getClassExpressionTranslator().nodeSet(stream);
    }

    public synchronized NodeSet<OWLClass> getDisjointClasses(OWLClassExpression ce) {
        ConceptExpression p = this.tr.pointer(ce);
        Stream stream = this.kernel.getDisjointConcepts(p, this.classActor()).getElements().stream();
        return this.tr.getClassExpressionTranslator().nodeSet(stream);
    }

    public Node<OWLObjectPropertyExpression> getTopObjectPropertyNode() {
        return this.getEquivalentObjectProperties((OWLObjectPropertyExpression)this.df.getOWLTopObjectProperty());
    }

    public Node<OWLObjectPropertyExpression> getBottomObjectPropertyNode() {
        return this.getEquivalentObjectProperties((OWLObjectPropertyExpression)this.df.getOWLBottomObjectProperty());
    }

    public synchronized NodeSet<OWLObjectPropertyExpression> getSubObjectProperties(OWLObjectPropertyExpression pe, boolean direct) {
        this.checkConsistency();
        Stream stream = this.kernel.getRoles(this.tr.pointer(pe), direct, this.objectActor(), false).getElements().stream();
        return this.tr.getObjectPropertyTranslator().nodeSet(stream);
    }

    public synchronized NodeSet<OWLObjectPropertyExpression> getSuperObjectProperties(OWLObjectPropertyExpression pe, boolean direct) {
        this.checkConsistency();
        List<Collection<ObjectRoleExpression>> elements = this.kernel.getRoles(this.tr.pointer(pe), direct, this.objectActor(), true).getElements();
        if (elements.isEmpty() || elements.get(0).isEmpty()) {
            elements.add(this.kernel.getEquivalentRoles(this.tr.pointer((OWLObjectPropertyExpression)this.df.getOWLTopObjectProperty()), this.objectActor()).getSynonyms());
        }
        return this.tr.getObjectPropertyTranslator().nodeSet(elements.stream());
    }

    public synchronized Node<OWLObjectPropertyExpression> getEquivalentObjectProperties(OWLObjectPropertyExpression pe) {
        this.checkConsistency();
        Stream<ObjectRoleExpression> stream = this.kernel.getEquivalentRoles(this.tr.pointer(pe), this.objectActor()).getSynonyms().stream();
        return this.tr.getObjectPropertyTranslator().node((Stream)stream);
    }

    public synchronized NodeSet<OWLObjectPropertyExpression> getDisjointObjectProperties(OWLObjectPropertyExpression pe) {
        this.checkConsistency();
        return new OWLObjectPropertyNodeSet(this.getBottomObjectPropertyNode());
    }

    public Node<OWLObjectPropertyExpression> getInverseObjectProperties(OWLObjectPropertyExpression pe) {
        return this.getEquivalentObjectProperties(pe.getInverseProperty());
    }

    public synchronized NodeSet<OWLClass> getObjectPropertyDomains(OWLObjectPropertyExpression pe, boolean direct) {
        this.checkConsistency();
        Stream stream = this.kernel.getORoleDomain(this.tr.pointer(pe), direct, this.classActor()).getElements().stream();
        return this.tr.getClassExpressionTranslator().nodeSet(stream);
    }

    public NodeSet<OWLClass> getObjectPropertyRanges(OWLObjectPropertyExpression pe, boolean direct) {
        return this.getObjectPropertyDomains(pe.getInverseProperty(), direct);
    }

    public Node<OWLDataProperty> getTopDataPropertyNode() {
        return new OWLDataPropertyNode(this.df.getOWLTopDataProperty());
    }

    public Node<OWLDataProperty> getBottomDataPropertyNode() {
        OWLDataPropertyNode toReturn = new OWLDataPropertyNode();
        toReturn.add((OWLObject)this.df.getOWLBottomDataProperty());
        return toReturn;
    }

    public synchronized NodeSet<OWLDataProperty> getSubDataProperties(OWLDataProperty pe, boolean direct) {
        this.checkConsistency();
        Stream stream = this.kernel.getRoles(this.tr.pointer((OWLDataPropertyExpression)pe), direct, this.dataActor(), false).getElements().stream();
        return this.tr.getDataPropertyTranslator().nodeSet(stream);
    }

    public synchronized NodeSet<OWLDataProperty> getSuperDataProperties(OWLDataProperty pe, boolean direct) {
        this.checkConsistency();
        List<Collection<DataRoleExpression>> elements = this.kernel.getRoles(this.tr.pointer((OWLDataPropertyExpression)pe), direct, this.dataActor(), true).getElements();
        if (elements.isEmpty() || elements.get(0).isEmpty()) {
            elements.add(this.kernel.getEquivalentRoles(this.tr.pointer((OWLDataPropertyExpression)this.df.getOWLTopDataProperty()), this.dataActor()).getSynonyms());
        }
        return this.tr.getDataPropertyTranslator().nodeSet(elements.stream());
    }

    public synchronized Node<OWLDataProperty> getEquivalentDataProperties(OWLDataProperty pe) {
        this.checkConsistency();
        DataRoleExpression p = this.tr.pointer((OWLDataPropertyExpression)pe);
        Stream<DataRoleExpression> dataPropertySynonyms = this.kernel.getEquivalentRoles(p, this.dataActor()).getSynonyms().stream();
        return this.tr.getDataPropertyTranslator().node((Stream)dataPropertySynonyms);
    }

    public synchronized NodeSet<OWLDataProperty> getDisjointDataProperties(OWLDataPropertyExpression pe) {
        this.checkConsistency();
        return new OWLDataPropertyNodeSet(this.getBottomDataPropertyNode());
    }

    public NodeSet<OWLClass> getDataPropertyDomains(OWLDataProperty pe, boolean direct) {
        Stream stream = this.kernel.getDRoleDomain(this.tr.pointer((OWLDataPropertyExpression)pe), direct, this.classActor()).getElements().stream();
        return this.tr.getClassExpressionTranslator().nodeSet(stream);
    }

    public synchronized NodeSet<OWLClass> getTypes(OWLNamedIndividual ind, boolean direct) {
        this.checkConsistency();
        Stream classElements = this.kernel.getTypes(this.tr.pointer((OWLIndividual)ind), direct, this.classActor()).getElements().stream();
        return this.tr.getClassExpressionTranslator().nodeSet(classElements);
    }

    private TaxonomyActor<ConceptExpression> classActor() {
        return new TaxonomyActor<ConceptExpression>(this.em, new ClassPolicy());
    }

    private TaxonomyActor<ObjectRoleExpression> objectActor() {
        return new TaxonomyActor<ObjectRoleExpression>(this.em, new ObjectPropertyPolicy());
    }

    private TaxonomyActor<DataRoleExpression> dataActor() {
        return new TaxonomyActor<DataRoleExpression>(this.em, new DataPropertyPolicy());
    }

    private <T extends Expression> TaxonomyActor<T> individualActor(Class<T> t) {
        return new TaxonomyActor(this.em, new IndividualPolicy(true));
    }

    public synchronized NodeSet<OWLNamedIndividual> getInstances(OWLClassExpression ce, boolean direct) {
        this.checkConsistency();
        TaxonomyActor<IndividualExpression> actor = this.kernel.getInstances(this.tr.pointer(ce), this.individualActor(IndividualExpression.class), direct);
        return this.tr.translateNodeSet(actor.getElements().iterator().next().stream());
    }

    public synchronized NodeSet<OWLNamedIndividual> getObjectPropertyValues(OWLNamedIndividual ind, OWLObjectPropertyExpression pe) {
        this.checkConsistency();
        List<Individual> fillers = this.kernel.getRoleFillers(this.tr.pointer((OWLIndividual)ind), this.tr.pointer(pe));
        return this.tr.translateNodeSet(fillers.stream().map(p -> this.em.individual(p.getEntity().getEntity())));
    }

    public synchronized Set<OWLLiteral> getDataPropertyValues(OWLNamedIndividual ind, OWLDataProperty pe) {
        this.checkConsistency();
        return Collections.emptySet();
    }

    public synchronized Node<OWLNamedIndividual> getSameIndividuals(OWLNamedIndividual ind) {
        this.checkConsistency();
        Stream<IndividualName> stream = this.kernel.getSameAs(this.tr.pointer((OWLIndividual)ind), this.individualActor(IndividualName.class)).getSynonyms().stream();
        return this.tr.getIndividualTranslator().node((Stream)stream);
    }

    public NodeSet<OWLNamedIndividual> getDifferentIndividuals(OWLNamedIndividual ind) {
        OWLClassExpression ce = this.df.getOWLObjectOneOf(new OWLIndividual[]{ind}).getObjectComplementOf();
        return this.getInstances(ce, false);
    }

    public synchronized void dispose() {
        this.root.getOWLOntologyManager().removeOntologyChangeListener((OWLOntologyChangeListener)this);
        this.tr = null;
        this.kernel = null;
    }

    public void dumpClassHierarchy(LogAdapter pw, boolean includeBottomNode) {
        this.dumpSubClasses(this.getTopClassNode(), pw, 0, includeBottomNode);
    }

    private void dumpSubClasses(Node<OWLClass> node, LogAdapter pw, int depth, boolean includeBottomNode) {
        if (includeBottomNode || !node.isBottomNode()) {
            IntStream.range(0, depth).forEach(n -> {
                LogAdapter logAdapter2 = pw.print("    ");
            });
            pw.print((Object)node).println();
            this.getSubClasses((OWLClassExpression)node.getRepresentativeElement(), true).forEach(sub -> this.dumpSubClasses((Node<OWLClass>)sub, pw, depth + 1, includeBottomNode));
        }
    }

    private Collection<Collection<ConceptExpression>> askSuperClasses(ConceptExpression arg, boolean direct) {
        return this.kernel.getConcepts(arg, direct, this.classActor(), true).getElements();
    }

    public synchronized void writeReasoningResult(long time) {
        this.kernel.writeReasoningResult(time);
    }

    public OWLKnowledgeExplorerReasoner.RootNode getRoot(OWLClassExpression expression) {
        return new RootNodeImpl(this.kernel.buildCompletionTree(this.tr.pointer(expression)));
    }

    public Node<? extends OWLObjectPropertyExpression> getObjectNeighbours(OWLKnowledgeExplorerReasoner.RootNode object, boolean deterministicOnly) {
        Stream stream = this.kernel.getObjectRoles(this.tree(object), deterministicOnly, false).stream();
        return this.tr.getObjectPropertyTranslator().node(stream);
    }

    public Node<OWLDataProperty> getDataNeighbours(OWLKnowledgeExplorerReasoner.RootNode object, boolean deterministicOnly) {
        Stream stream = this.kernel.getDataRoles(this.tree(object), deterministicOnly).stream();
        return this.tr.getDataPropertyTranslator().node(stream);
    }

    public Collection<OWLKnowledgeExplorerReasoner.RootNode> getObjectNeighbours(OWLKnowledgeExplorerReasoner.RootNode n, OWLObjectProperty property) {
        Stream stream = this.kernel.getNeighbours(this.tree(n), this.tr.pointer((OWLObjectPropertyExpression)property)).stream();
        return OWLAPIStreamUtils.asList(stream.map(t -> new RootNodeImpl((DlCompletionTree)OWLAPIPreconditions.checkNotNull((Object)t))));
    }

    public Collection<OWLKnowledgeExplorerReasoner.RootNode> getDataNeighbours(OWLKnowledgeExplorerReasoner.RootNode n, OWLDataProperty property) {
        return OWLAPIStreamUtils.asList(this.kernel.getNeighbours(this.tree(n), this.tr.pointer((OWLDataPropertyExpression)property)).stream().map(t -> new RootNodeImpl((DlCompletionTree)OWLAPIPreconditions.checkNotNull((Object)t))));
    }

    protected DlCompletionTree tree(OWLKnowledgeExplorerReasoner.RootNode n) {
        return (DlCompletionTree)n.getNode();
    }

    public Node<? extends OWLClassExpression> getObjectLabel(OWLKnowledgeExplorerReasoner.RootNode object, boolean deterministicOnly) {
        Stream stream = this.kernel.getObjectLabel(this.tree(object), deterministicOnly).stream();
        return this.tr.getClassExpressionTranslator().node(stream);
    }

    public Node<? extends OWLDataRange> getDataLabel(OWLKnowledgeExplorerReasoner.RootNode object, boolean deterministicOnly) {
        Stream stream = this.kernel.getDataLabel(this.tree(object), deterministicOnly).stream();
        return this.tr.getDataRangeTranslator().node(stream);
    }

    public OWLKnowledgeExplorerReasoner.RootNode getBlocker(OWLKnowledgeExplorerReasoner.RootNode object) {
        return new RootNodeImpl(this.kernel.getBlocker(this.tree(object)));
    }

    public int getAtomicDecompositionSize(boolean useSemantics, ModuleType type) {
        return this.kernel.getAtomicDecompositionSize(this.root, useSemantics, type);
    }

    public Set<OWLAxiom> getTautologies() {
        return OWLAPIStreamUtils.asSet(this.kernel.getTautologies().stream());
    }

    public Set<OWLAxiom> getAtomAxioms(int index) {
        return JFactReasoner.axiomsToSet(this.kernel.getAtomAxioms(index).stream());
    }

    private static Set<OWLAxiom> axiomsToSet(Stream<AxiomWrapper> index) {
        return OWLAPIStreamUtils.asSet(index.map(ax -> ax.getAxiom()));
    }

    public Set<OWLAxiom> getAtomModule(int index) {
        return JFactReasoner.axiomsToSet(this.kernel.getAtomModule(index).stream());
    }

    public Set<OntologyAtom> getAtomDependents(int index) {
        return this.kernel.getAtomDependents(index);
    }

    public Set<OWLAxiom> getModule(Set<OWLEntity> signature, boolean useSemantic, ModuleType moduletype) {
        List<Expression> list = this.tr.translateExpressions(signature.stream());
        Collection<AxiomWrapper> axioms = this.kernel.getModule(list, useSemantic, moduletype, this);
        return JFactReasoner.axiomsToSet(axioms.stream());
    }

    public Set<OWLAxiom> getNonLocal(Set<OWLEntity> signature, boolean useSemantic, ModuleType moduletype) {
        List<Expression> list = this.tr.translateExpressions(signature.stream());
        Set<AxiomWrapper> axioms = this.kernel.getNonLocal(list, useSemantic, moduletype, this);
        return JFactReasoner.axiomsToSet(axioms.stream());
    }

    public synchronized Node<OWLNamedIndividual> getDataRelatedIndividuals(Stream<OWLIndividual> individuals, OWLDataProperty r, OWLDataProperty s, int op) {
        this.checkConsistency();
        Stream<IndividualName> stream = this.kernel.getDataRelatedIndividuals(this.tr.pointer((OWLDataPropertyExpression)r), this.tr.pointer((OWLDataPropertyExpression)s), op, this.tr.translate(individuals)).stream();
        return this.tr.getIndividualTranslator().node((Stream)stream);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.root.getOWLOntologyManager().addOntologyChangeListener((OWLOntologyChangeListener)this);
    }

    private class RootNodeImpl
    implements OWLKnowledgeExplorerReasoner.RootNode,
    Serializable {
        @Nonnull
        private final DlCompletionTree pointer;

        public RootNodeImpl(DlCompletionTree p) {
            this.pointer = p;
        }

        public <T> T getNode() {
            return (T)this.pointer;
        }
    }
}

