/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.reasoner.Node;
import org.semanticweb.owlapi.reasoner.NodeSet;
import org.semanticweb.owlapi.reasoner.impl.DefaultNode;
import org.semanticweb.owlapi.reasoner.impl.DefaultNodeSet;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import uk.ac.manchester.cs.jfact.TranslationMachinery;
import uk.ac.manchester.cs.jfact.kernel.ExpressionCache;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.Entity;

abstract class OWLEntityTranslator<E extends OWLObject, T extends Entity>
implements Serializable {
    private final Map<E, T> entity2dlentity = new HashMap<E, T>();
    private final Map<T, E> dlentity2entity = new HashMap<T, E>();
    protected final ExpressionCache em;
    protected final OWLDataFactory df;
    protected final TranslationMachinery tr;

    protected OWLEntityTranslator(ExpressionCache em, OWLDataFactory df, TranslationMachinery tr) {
        this.em = em;
        this.df = df;
        this.tr = tr;
        this.fillTopAndBottomEntities();
    }

    protected void fillMaps(E entity, T dlentity) {
        this.entity2dlentity.put(entity, dlentity);
        this.dlentity2entity.put(dlentity, entity);
    }

    protected void fillTopAndBottomEntities() {
        E bottomEntity;
        E topEntity = this.getTopEntity();
        if (topEntity != null) {
            this.fillMaps(topEntity, this.getTopEntityPointer());
        }
        if ((bottomEntity = this.getBottomEntity()) != null) {
            this.fillMaps(bottomEntity, this.getBottomEntityPointer());
        }
    }

    protected T registerNewEntity(E entity) {
        T pointer = this.createPointerForEntity(entity);
        this.fillMaps(entity, pointer);
        return pointer;
    }

    public E getEntityFromPointer(T pointer) {
        return (E)((OWLObject)OWLAPIPreconditions.verifyNotNull((Object)((OWLObject)this.dlentity2entity.get(pointer)), (String)(pointer + " does not have a correct reverse mapping")));
    }

    public T getPointerFromEntity(E entity) {
        Entity pointer = (Entity)this.entity2dlentity.get(entity);
        if (pointer == null) {
            pointer = this.registerNewEntity(entity);
        }
        return (T)pointer;
    }

    public Node<E> node(Stream<T> pointers) {
        return this.createDefaultNode(pointers.map(this::getEntityFromPointer));
    }

    public NodeSet<E> nodeSet(Stream<Collection<T>> pointers) {
        return this.createDefaultNodeSet(pointers.map(p -> this.node(p.stream())));
    }

    protected abstract DefaultNode<E> createDefaultNode(Stream<E> var1);

    protected abstract DefaultNodeSet<E> createDefaultNodeSet(Stream<Node<E>> var1);

    @Nullable
    protected abstract T getTopEntityPointer();

    @Nullable
    protected abstract T getBottomEntityPointer();

    protected abstract T createPointerForEntity(E var1);

    @Nullable
    protected abstract E getTopEntity();

    @Nullable
    protected abstract E getBottomEntity();
}

