/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomVisitorEx;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLClassExpressionVisitorEx;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDataRangeVisitorEx;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEntityVisitorEx;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectInverseOf;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.reasoner.NodeSet;
import org.semanticweb.owlapi.reasoner.impl.OWLNamedIndividualNodeSet;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;
import org.semanticweb.owlapitools.decomposition.AxiomWrapper;
import uk.ac.manchester.cs.jfact.AxiomTranslator;
import uk.ac.manchester.cs.jfact.ClassExpressionTranslator;
import uk.ac.manchester.cs.jfact.DataPropertyTranslator;
import uk.ac.manchester.cs.jfact.DataRangeTranslator;
import uk.ac.manchester.cs.jfact.EntailmentChecker;
import uk.ac.manchester.cs.jfact.EntityVisitorEx;
import uk.ac.manchester.cs.jfact.IndividualTranslator;
import uk.ac.manchester.cs.jfact.ObjectPropertyTranslator;
import uk.ac.manchester.cs.jfact.datatypes.Datatype;
import uk.ac.manchester.cs.jfact.datatypes.DatatypeFactory;
import uk.ac.manchester.cs.jfact.datatypes.Literal;
import uk.ac.manchester.cs.jfact.kernel.ExpressionCache;
import uk.ac.manchester.cs.jfact.kernel.ReasoningKernel;
import uk.ac.manchester.cs.jfact.kernel.dl.IndividualName;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.Axioms;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.ConceptExpression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.DataExpression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.DataRoleExpression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.Expression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.IndividualExpression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.ObjectRoleExpression;

public class TranslationMachinery
implements Serializable {
    @Nonnull
    private final AxiomTranslator axiomTranslator;
    @Nonnull
    private final ClassExpressionTranslator classExpressionTranslator;
    @Nonnull
    private final DataRangeTranslator dataRangeTranslator;
    @Nonnull
    private final ObjectPropertyTranslator objectPropertyTranslator;
    @Nonnull
    private final DataPropertyTranslator dataPropertyTranslator;
    @Nonnull
    private final IndividualTranslator individualTranslator;
    @Nonnull
    private final EntailmentChecker entailmentChecker;
    @Nonnull
    private final Map<OWLAxiom, AxiomWrapper> axiom2PtrMap = new HashMap<OWLAxiom, AxiomWrapper>();
    protected final ReasoningKernel kernel;
    protected final ExpressionCache em;
    protected final OWLDataFactory df;
    protected final DatatypeFactory datatypefactory;
    protected final EntityVisitorEx entityVisitor;

    public TranslationMachinery(ReasoningKernel kernel, OWLDataFactory df, DatatypeFactory factory) {
        this.kernel = kernel;
        this.datatypefactory = factory;
        this.em = kernel.getExpressionManager();
        this.df = df;
        this.axiomTranslator = new AxiomTranslator(kernel.getOntology(), df, this);
        this.classExpressionTranslator = new ClassExpressionTranslator(this.em, df, this);
        this.dataRangeTranslator = new DataRangeTranslator(this.em, df, this, this.datatypefactory);
        this.objectPropertyTranslator = new ObjectPropertyTranslator(this.em, df, this);
        this.dataPropertyTranslator = new DataPropertyTranslator(this.em, df, this);
        this.individualTranslator = new IndividualTranslator(this.em, df, this);
        this.entailmentChecker = new EntailmentChecker(kernel, df, this);
        this.entityVisitor = new EntityVisitorEx(this);
    }

    public List<Expression> translateExpressions(Stream<OWLEntity> signature) {
        return OWLAPIStreamUtils.asList(signature.map(e -> (Expression)e.accept((OWLEntityVisitorEx)this.entityVisitor)).filter(e -> e != Axioms.dummyExpression()));
    }

    public void loadAxioms(Stream<OWLAxiom> axioms) {
        axioms.map(ax -> (AxiomWrapper)ax.accept((OWLAxiomVisitorEx)this.axiomTranslator)).filter(ax -> Axioms.dummy() != ax).forEach(ax -> {
            AxiomWrapper axiomWrapper = this.axiom2PtrMap.put(ax.getAxiom(), (AxiomWrapper)ax);
        });
    }

    public void retractAxiom(OWLAxiom axiom) {
        AxiomWrapper ptr = this.axiom2PtrMap.get(axiom);
        if (ptr != null) {
            this.kernel.getOntology().retract(ptr);
            this.axiom2PtrMap.remove(axiom);
        }
    }

    protected ConceptExpression pointer(OWLClassExpression classExpression) {
        return (ConceptExpression)classExpression.accept((OWLClassExpressionVisitorEx)this.classExpressionTranslator);
    }

    protected DataExpression pointer(OWLDataRange dataRange) {
        return (DataExpression)dataRange.accept((OWLDataRangeVisitorEx)this.dataRangeTranslator);
    }

    protected ObjectRoleExpression pointer(OWLObjectPropertyExpression propertyExpression) {
        OWLObjectPropertyExpression simp = propertyExpression.getSimplified();
        if (simp.isAnonymous()) {
            OWLObjectInverseOf inv = (OWLObjectInverseOf)simp;
            return this.em.inverse((ObjectRoleExpression)this.objectPropertyTranslator.getPointerFromEntity((OWLObject)inv.getInverse().asOWLObjectProperty()));
        }
        return (ObjectRoleExpression)this.objectPropertyTranslator.getPointerFromEntity((OWLObject)simp.asOWLObjectProperty());
    }

    protected DataRoleExpression pointer(OWLDataPropertyExpression propertyExpression) {
        return (DataRoleExpression)this.dataPropertyTranslator.getPointerFromEntity((OWLObject)propertyExpression.asOWLDataProperty());
    }

    protected synchronized IndividualName pointer(OWLIndividual individual) {
        if (!individual.isAnonymous()) {
            return (IndividualName)this.individualTranslator.getPointerFromEntity((OWLObject)individual.asOWLNamedIndividual());
        }
        return this.em.individual((OWLEntity)this.df.getOWLNamedIndividual(IRI.create((String)individual.toStringID())));
    }

    protected synchronized Datatype<?> pointer(OWLDatatype datatype) {
        OWLAPIPreconditions.checkNotNull((Object)datatype, (String)"datatype cannot be null");
        return this.datatypefactory.getKnownDatatype(datatype.getIRI());
    }

    protected synchronized Literal<?> pointer(OWLLiteral literal) {
        String value = literal.getLiteral();
        if (literal.isRDFPlainLiteral()) {
            value = String.valueOf(value) + '@' + literal.getLang();
        }
        IRI string = literal.getDatatype().getIRI();
        Datatype knownDatatype = this.datatypefactory.getKnownDatatype(string);
        return knownDatatype.buildLiteral(value);
    }

    protected NodeSet<OWLNamedIndividual> translateNodeSet(Stream<IndividualExpression> pointers) {
        OWLNamedIndividualNodeSet ns = new OWLNamedIndividualNodeSet();
        pointers.filter(p -> p instanceof IndividualName).forEach(p -> ns.addEntity((OWLObject)((OWLNamedIndividual)this.individualTranslator.getEntityFromPointer((IndividualName)p))));
        return ns;
    }

    public List<IndividualExpression> translate(Stream<? extends OWLIndividual> inds) {
        return OWLAPIStreamUtils.asList(inds.map(this::pointer));
    }

    public ClassExpressionTranslator getClassExpressionTranslator() {
        return this.classExpressionTranslator;
    }

    public DataRangeTranslator getDataRangeTranslator() {
        return this.dataRangeTranslator;
    }

    public ObjectPropertyTranslator getObjectPropertyTranslator() {
        return this.objectPropertyTranslator;
    }

    public DataPropertyTranslator getDataPropertyTranslator() {
        return this.dataPropertyTranslator;
    }

    public IndividualTranslator getIndividualTranslator() {
        return this.individualTranslator;
    }

    public EntailmentChecker getEntailmentChecker() {
        return this.entailmentChecker;
    }
}

