/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.datatypes;

import java.util.Set;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.HasIRI;
import uk.ac.manchester.cs.jfact.datatypes.AbstractDatatype;
import uk.ac.manchester.cs.jfact.datatypes.Datatype;
import uk.ac.manchester.cs.jfact.datatypes.DatatypeFactory;
import uk.ac.manchester.cs.jfact.datatypes.Facet;
import uk.ac.manchester.cs.jfact.datatypes.Facets;
import uk.ac.manchester.cs.jfact.datatypes.NumericDatatype;
import uk.ac.manchester.cs.jfact.datatypes.NumericDatatypeWrapper;
import uk.ac.manchester.cs.jfact.datatypes.OrderedDatatype;
import uk.ac.manchester.cs.jfact.datatypes.ordered;

abstract class AbstractNumericDatatype<R extends Comparable<R>>
extends AbstractDatatype<R>
implements NumericDatatype<R> {
    public AbstractNumericDatatype(HasIRI uri, Set<Facet> f, Set<Datatype<?>> ancestors) {
        super(uri, f, ancestors);
    }

    @Override
    public boolean getNumeric() {
        return true;
    }

    @Override
    public boolean isNumericDatatype() {
        return true;
    }

    @Override
    public NumericDatatype<R> asNumericDatatype() {
        return this;
    }

    @Override
    public boolean isOrderedDatatype() {
        return true;
    }

    @Override
    public OrderedDatatype<R> asOrderedDatatype() {
        return this;
    }

    @Override
    public ordered getOrdered() {
        return ordered.PARTIAL;
    }

    @Override
    public boolean isInValueSpace(R lit) {
        R l;
        if (this.hasMinExclusive() && (l = Facets.minExclusive.parseNumber(lit)).compareTo(this.getMin()) <= 0) {
            return false;
        }
        if (this.hasMinInclusive() && (l = Facets.minExclusive.parseNumber(lit)).compareTo(this.getMin()) < 0) {
            return false;
        }
        if (this.hasMaxExclusive() && (l = Facets.minExclusive.parseNumber(lit)).compareTo(this.getMax()) >= 0) {
            return false;
        }
        return !this.hasMaxInclusive() || (l = Facets.minExclusive.parseNumber(lit)).compareTo(this.getMax()) <= 0;
    }

    @Override
    public boolean isCompatible(Datatype<?> type) {
        if (type.equals(DatatypeFactory.LITERAL)) {
            return true;
        }
        if (type.getNumeric()) {
            if (type.equals(DatatypeFactory.FLOAT) || type.equals(DatatypeFactory.DOUBLE)) {
                return super.isCompatible(type);
            }
            NumericDatatype<?> wrapper = type instanceof NumericDatatype ? (NumericDatatype<?>)type : AbstractNumericDatatype.wrap(type);
            if (!this.hasMax() && !this.hasMin()) {
                return true;
            }
            if (!wrapper.hasMax() && !wrapper.hasMin()) {
                return true;
            }
            if (!this.hasMax() && !wrapper.hasMax()) {
                return true;
            }
            if (!this.hasMin() && !wrapper.hasMin()) {
                return true;
            }
            if (!this.hasMin()) {
                return this.overlapping(this, wrapper);
            }
            if (!this.hasMax()) {
                return this.overlapping(wrapper, this);
            }
            if (!wrapper.hasMin()) {
                return this.overlapping(wrapper, this);
            }
            if (!wrapper.hasMax()) {
                return this.overlapping(this, wrapper);
            }
            return this.overlapping(this, wrapper) || this.overlapping(wrapper, this);
        }
        return false;
    }

    @Override
    public boolean emptyValueSpace() {
        if (!this.hasMin() || !this.hasMax()) {
            return false;
        }
        if (this.hasMaxExclusive() && this.hasMinExclusive()) {
            return this.getMax().compareTo((Comparable)DatatypeFactory.increase((Number)this.getMin())) < 0;
        }
        return this.getMax().compareTo(this.getMin()) < 0;
    }

    private static <O extends Comparable<O>> NumericDatatype<O> wrap(Datatype<O> d) {
        return new NumericDatatypeWrapper<O>(d);
    }

    @Override
    public boolean hasMinExclusive() {
        return this.knownNumericFacetValues.containsKey(Facets.minExclusive);
    }

    @Override
    public boolean hasMinInclusive() {
        return this.knownNumericFacetValues.containsKey(Facets.minInclusive);
    }

    @Override
    public boolean hasMaxExclusive() {
        return this.knownNumericFacetValues.containsKey(Facets.maxExclusive);
    }

    @Override
    public boolean hasMaxInclusive() {
        return this.knownNumericFacetValues.containsKey(Facets.maxInclusive);
    }

    @Override
    public boolean hasMin() {
        return this.hasMinInclusive() || this.hasMinExclusive();
    }

    @Override
    public boolean hasMax() {
        return this.hasMaxInclusive() || this.hasMaxExclusive();
    }

    @Override
    @Nullable
    public R getMin() {
        if (this.hasMinExclusive()) {
            return (R)((Comparable)this.knownNumericFacetValues.get(Facets.minExclusive));
        }
        if (this.hasMinInclusive()) {
            return (R)((Comparable)this.knownNumericFacetValues.get(Facets.minInclusive));
        }
        return null;
    }

    @Override
    @Nullable
    public R getMax() {
        if (this.hasMaxExclusive()) {
            return (R)((Comparable)this.knownNumericFacetValues.get(Facets.maxExclusive));
        }
        if (this.hasMaxInclusive()) {
            return (R)((Comparable)this.knownNumericFacetValues.get(Facets.maxInclusive));
        }
        return null;
    }
}

