/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.datatypes;

import org.semanticweb.owlapi.model.HasIRI;
import org.semanticweb.owlapi.vocab.XSDVocabulary;
import uk.ac.manchester.cs.jfact.datatypes.AbstractDatatype;
import uk.ac.manchester.cs.jfact.datatypes.DatatypeFactory;
import uk.ac.manchester.cs.jfact.datatypes.Facets;
import uk.ac.manchester.cs.jfact.datatypes.Utils;

class BASE64BINARYDatatype
extends AbstractDatatype<String> {
    BASE64BINARYDatatype() {
        super((HasIRI)XSDVocabulary.BASE_64_BINARY, DatatypeFactory.STRINGFACETS, Utils.generateAncestors(DatatypeFactory.LITERAL));
        this.knownNonNumericFacetValues.putAll(DatatypeFactory.LITERAL.getKnownNonNumericFacetValues());
        this.knownNumericFacetValues.putAll(DatatypeFactory.LITERAL.getKnownNumericFacetValues());
        this.knownNonNumericFacetValues.put(Facets.whiteSpace, Facets.whitespace.COLLAPSE);
    }

    @Override
    public String parseValue(String s) {
        return Facets.whitespace.COLLAPSE.normalize(s);
    }

    @Override
    public boolean isInValueSpace(String s) {
        return s.chars().allMatch(c -> Character.isLetterOrDigit((char)c) || "+/=".indexOf(c) > -1);
    }
}

