/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.datatypes;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Set;
import org.semanticweb.owlapi.model.HasIRI;
import org.semanticweb.owlapi.vocab.XSDVocabulary;
import uk.ac.manchester.cs.jfact.datatypes.Datatype;
import uk.ac.manchester.cs.jfact.datatypes.DatatypeFactory;
import uk.ac.manchester.cs.jfact.datatypes.Facets;
import uk.ac.manchester.cs.jfact.datatypes.INTEGERDatatype;
import uk.ac.manchester.cs.jfact.datatypes.Utils;

class NONNEGATIVEINTEGERDatatype<R extends Comparable<R>>
extends INTEGERDatatype<R> {
    protected NONNEGATIVEINTEGERDatatype() {
        this((HasIRI)XSDVocabulary.NON_NEGATIVE_INTEGER, Utils.generateAncestors(DatatypeFactory.INTEGER));
    }

    protected NONNEGATIVEINTEGERDatatype(HasIRI uri, Set<Datatype<?>> ancestors) {
        super(uri, ancestors);
        this.knownNonNumericFacetValues.putAll(super.getKnownNonNumericFacetValues());
        this.knownNumericFacetValues.putAll(super.getKnownNumericFacetValues());
        this.knownNonNumericFacetValues.put(Facets.whiteSpace, DatatypeFactory.WHITESPACE);
        this.knownNonNumericFacetValues.put(Facets.pattern, DatatypeFactory.NUMBER_EXPRESSION);
        this.knownNumericFacetValues.put(Facets.minInclusive, new BigDecimal(0L));
    }

    @Override
    public R parseValue(String s) {
        BigInteger parseValue = new BigInteger(s);
        if (parseValue.compareTo(BigInteger.ZERO) < 0) {
            throw new ArithmeticException("Non negative integer required, but found: " + s);
        }
        return (R)parseValue;
    }
}

