/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.datatypes;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Set;
import org.semanticweb.owlapi.model.HasIRI;
import org.semanticweb.owlapi.vocab.XSDVocabulary;
import uk.ac.manchester.cs.jfact.datatypes.Datatype;
import uk.ac.manchester.cs.jfact.datatypes.DatatypeFactory;
import uk.ac.manchester.cs.jfact.datatypes.Facets;
import uk.ac.manchester.cs.jfact.datatypes.NONNEGATIVEINTEGERDatatype;
import uk.ac.manchester.cs.jfact.datatypes.Utils;
import uk.ac.manchester.cs.jfact.datatypes.cardinality;

class UNSIGNEDLONGDatatype<R extends Comparable<R>>
extends NONNEGATIVEINTEGERDatatype<R> {
    protected UNSIGNEDLONGDatatype() {
        this((HasIRI)XSDVocabulary.UNSIGNED_LONG, Utils.generateAncestors(DatatypeFactory.NONNEGATIVEINTEGER));
    }

    protected UNSIGNEDLONGDatatype(HasIRI uri, Set<Datatype<?>> ancestors) {
        super(uri, ancestors);
        this.knownNonNumericFacetValues.putAll(super.getKnownNonNumericFacetValues());
        this.knownNumericFacetValues.putAll(super.getKnownNumericFacetValues());
        this.knownNonNumericFacetValues.put(Facets.whiteSpace, DatatypeFactory.WHITESPACE);
        this.knownNonNumericFacetValues.put(Facets.pattern, DatatypeFactory.NUMBER_EXPRESSION);
        this.knownNumericFacetValues.put(Facets.minInclusive, BigDecimal.ZERO);
        this.knownNumericFacetValues.put(Facets.maxInclusive, new BigDecimal("18446744073709551615"));
    }

    @Override
    public R parseValue(String s) {
        BigInteger b = new BigInteger(s);
        if (b.compareTo(BigInteger.ZERO) < 0) {
            throw new ArithmeticException("Unsigned long required, but found: " + s);
        }
        return (R)b;
    }

    @Override
    public boolean getBounded() {
        return true;
    }

    @Override
    public cardinality getCardinality() {
        return cardinality.FINITE;
    }
}

