/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.datatypes;

import java.math.BigDecimal;
import java.util.Set;
import org.semanticweb.owlapi.model.HasIRI;
import org.semanticweb.owlapi.vocab.XSDVocabulary;
import uk.ac.manchester.cs.jfact.datatypes.Datatype;
import uk.ac.manchester.cs.jfact.datatypes.DatatypeFactory;
import uk.ac.manchester.cs.jfact.datatypes.Facets;
import uk.ac.manchester.cs.jfact.datatypes.UNSIGNEDINTDatatype;
import uk.ac.manchester.cs.jfact.datatypes.Utils;

class UNSIGNEDSHORTDatatype<R extends Comparable<R>>
extends UNSIGNEDINTDatatype<R> {
    protected UNSIGNEDSHORTDatatype() {
        this((HasIRI)XSDVocabulary.UNSIGNED_SHORT, Utils.generateAncestors(DatatypeFactory.UNSIGNEDINT));
    }

    protected UNSIGNEDSHORTDatatype(HasIRI uri, Set<Datatype<?>> ancestors) {
        super(uri, ancestors);
        this.knownNonNumericFacetValues.putAll(super.getKnownNonNumericFacetValues());
        this.knownNumericFacetValues.putAll(super.getKnownNumericFacetValues());
        this.knownNonNumericFacetValues.put(Facets.whiteSpace, DatatypeFactory.WHITESPACE);
        this.knownNonNumericFacetValues.put(Facets.pattern, DatatypeFactory.NUMBER_EXPRESSION);
        this.knownNumericFacetValues.put(Facets.minInclusive, BigDecimal.ZERO);
        this.knownNumericFacetValues.put(Facets.maxInclusive, new BigDecimal(65535));
    }

    @Override
    public R parseValue(String s) {
        Integer parseShort = Integer.valueOf(s);
        if (parseShort < 0) {
            throw new ArithmeticException("Unsigned short required, but found: " + s);
        }
        return (R)parseShort;
    }
}

