/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.kernel;

import conformance.PortedFrom;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import uk.ac.manchester.cs.jfact.helpers.DLTree;
import uk.ac.manchester.cs.jfact.kernel.Concept;
import uk.ac.manchester.cs.jfact.kernel.Role;
import uk.ac.manchester.cs.jfact.kernel.Token;

@PortedFrom(file="tAxiom.h", name="InAx")
public class InAx
implements Serializable {
    public static final String S_ABS_N_ATTEMPT = "SAbsNAttempt";
    public static final String S_ABS_N_APPLY = "SAbsNApply";
    public static final String S_ABS_ACTION = "SAbsAction";
    public static final String S_ABS_INPUT = "SAbsInput";
    public static final String S_ABS_R_ATTEMPT = "SAbsRAttempt";
    public static final String S_ABS_R_APPLY = "SAbsRApply";
    public static final String S_ABS_C_ATTEMPT = "SAbsCAttempt";
    public static final String S_ABS_C_APPLY = "SAbsCApply";
    public static final String S_ABS_T_APPLY = "SAbsTApply";
    public static final String S_ABS_SPLIT = "SAbsSplit";
    public static final String S_ABS_B_APPLY = "SAbsBApply";
    public static final String S_ABS_REP_FORALL = "SAbsRepForall";
    public static final String S_ABS_REP_CN = "SAbsRepCN";
    private static final AtomicInteger ZERO = new AtomicInteger(0);
    private final Map<String, AtomicInteger> created = new HashMap<String, AtomicInteger>();

    public static Concept getConcept(DLTree p) {
        return (Concept)p.elem().getNE();
    }

    @PortedFrom(file="tAxiom.cpp", name="isNP")
    public static boolean isNP(Concept c) {
        return c.isNonPrimitive() && !InAx.hasDefCycle(c);
    }

    @PortedFrom(file="tAxiom.cpp", name="hasDefCycle")
    static boolean hasDefCycle(Concept c) {
        if (c.isPrimitive()) {
            return false;
        }
        return InAx.hasDefCycle(c, new HashSet<Concept>());
    }

    @PortedFrom(file="tAxiom.cpp", name="hasDefCycle")
    static boolean hasDefCycle(Concept c, Set<Concept> visited) {
        if (c.isPrimitive()) {
            return false;
        }
        if (visited.contains(c)) {
            return true;
        }
        DLTree p = c.getDescription();
        if (!p.isNOT()) {
            return false;
        }
        if ((p = p.getChild()).token() != Token.FORALL) {
            return false;
        }
        if (!(p = p.getRight()).isNOT()) {
            return false;
        }
        if (!(p = p.getChild()).isName()) {
            return false;
        }
        visited.add(c);
        return InAx.hasDefCycle(InAx.getConcept(p), visited);
    }

    public static boolean isTop(DLTree p) {
        return p.isBOTTOM();
    }

    public static boolean isBot(DLTree p) {
        return p.isTOP();
    }

    public static boolean isPosCN(DLTree p) {
        return p.isNOT() && p.getChild().isName();
    }

    public static boolean isPosNP(DLTree p) {
        return InAx.isPosCN(p) && InAx.isNP(InAx.getConcept(p.getChild()));
    }

    public static boolean isPosPC(DLTree p) {
        return InAx.isPosCN(p) && InAx.getConcept(p.getChild()).isPrimitive();
    }

    public static boolean isNegCN(DLTree p) {
        return p.isName();
    }

    public static boolean isNegNP(DLTree p) {
        return InAx.isNegCN(p) && InAx.isNP(InAx.getConcept(p));
    }

    public static boolean isNegPC(DLTree p) {
        return InAx.isNegCN(p) && InAx.getConcept(p).isPrimitive();
    }

    public static boolean isAnd(DLTree p) {
        return p.isNOT() && p.getChild().isAND();
    }

    public static boolean isOr(DLTree p) {
        return p.isAND();
    }

    public static boolean isForall(DLTree p) {
        return p.isNOT() && p.getChild().token() == Token.FORALL;
    }

    public static boolean isOForall(DLTree p) {
        return InAx.isForall(p) && !Role.resolveRole(p.getChild().getLeft()).isDataRole();
    }

    public static boolean isAbsForall(DLTree p) {
        if (!InAx.isOForall(p)) {
            return false;
        }
        DLTree c = p.getChild().getRight();
        if (InAx.isTop(c)) {
            return false;
        }
        return !c.isName() || !InAx.getConcept(c).isSystem();
    }

    private void add(String s) {
        this.created.computeIfAbsent(s, x -> new AtomicInteger()).incrementAndGet();
    }

    private int get(String s) {
        return this.created.getOrDefault(s, ZERO).intValue();
    }

    public void sAbsRepCN() {
        this.add(S_ABS_REP_CN);
    }

    public void sAbsRepForall() {
        this.add(S_ABS_REP_FORALL);
    }

    public void sAbsBApply() {
        this.add(S_ABS_B_APPLY);
    }

    public void sAbsSplit() {
        this.add(S_ABS_SPLIT);
    }

    public void sAbsTApply() {
        this.add(S_ABS_T_APPLY);
    }

    public void sAbsCApply() {
        this.add(S_ABS_C_APPLY);
    }

    public void sAbsCAttempt() {
        this.add(S_ABS_C_ATTEMPT);
    }

    public void sAbsRApply() {
        this.add(S_ABS_R_APPLY);
    }

    public void sAbsRAttempt() {
        this.add(S_ABS_R_ATTEMPT);
    }

    public void sAbsInput() {
        this.add(S_ABS_INPUT);
    }

    public void sAbsAction() {
        this.add(S_ABS_ACTION);
    }

    public void sAbsNApply() {
        this.add(S_ABS_N_APPLY);
    }

    public void sAbsNAttempt() {
        this.add(S_ABS_N_ATTEMPT);
    }

    public boolean containsSAbsRepCN() {
        return this.created.containsKey(S_ABS_REP_CN);
    }

    public boolean containsSAbsRepForall() {
        return this.created.containsKey(S_ABS_REP_FORALL);
    }

    public boolean containsSAbsBApply() {
        return this.created.containsKey(S_ABS_B_APPLY);
    }

    public boolean containsSAbsSplit() {
        return this.created.containsKey(S_ABS_SPLIT);
    }

    public boolean containsSAbsTApply() {
        return this.created.containsKey(S_ABS_T_APPLY);
    }

    public boolean containsSAbsCApply() {
        return this.created.containsKey(S_ABS_C_APPLY);
    }

    public boolean containsSAbsCAttempt() {
        return this.created.containsKey(S_ABS_C_ATTEMPT);
    }

    public boolean containsSAbsRApply() {
        return this.created.containsKey(S_ABS_R_APPLY);
    }

    public boolean containsSAbsRAttempt() {
        return this.created.containsKey(S_ABS_R_ATTEMPT);
    }

    public boolean containsSAbsInput() {
        return this.created.containsKey(S_ABS_INPUT);
    }

    public boolean containsSAbsAction() {
        return this.created.containsKey(S_ABS_ACTION);
    }

    public boolean containsSAbsNApply() {
        return this.created.containsKey(S_ABS_N_APPLY);
    }

    public boolean containsSAbsNAttempt() {
        return this.created.containsKey(S_ABS_N_ATTEMPT);
    }

    public int getSAbsRepCN() {
        return this.get(S_ABS_REP_CN);
    }

    public int getSAbsRepForall() {
        return this.get(S_ABS_REP_FORALL);
    }

    public int getSAbsBApply() {
        return this.get(S_ABS_B_APPLY);
    }

    public int getSAbsSplit() {
        return this.get(S_ABS_SPLIT);
    }

    public int getSAbsTApply() {
        return this.get(S_ABS_T_APPLY);
    }

    public int getSAbsCApply() {
        return this.get(S_ABS_C_APPLY);
    }

    public int getSAbsCAttempt() {
        return this.get(S_ABS_C_ATTEMPT);
    }

    public int getSAbsRApply() {
        return this.get(S_ABS_R_APPLY);
    }

    public int getSAbsRAttempt() {
        return this.get(S_ABS_R_ATTEMPT);
    }

    public int getSAbsInput() {
        return this.get(S_ABS_INPUT);
    }

    public int getSAbsAction() {
        return this.get(S_ABS_ACTION);
    }

    public int getSAbsNApply() {
        return this.get(S_ABS_N_APPLY);
    }

    public int getSAbsNAttempt() {
        return this.get(S_ABS_N_ATTEMPT);
    }

    @PortedFrom(file="tAxiom.h", name="isSimpleForall")
    public static boolean isSimpleForall(DLTree p) {
        if (!InAx.isAbsForall(p)) {
            return false;
        }
        DLTree c = p.getChild().getRight();
        return c.isName() && InAx.getConcept(c).getDescription() == null;
    }
}

