/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.kernel;

import conformance.Original;
import conformance.PortedFrom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import uk.ac.manchester.cs.jfact.kernel.Concept;
import uk.ac.manchester.cs.jfact.kernel.DlCompletionTree;
import uk.ac.manchester.cs.jfact.kernel.Related;
import uk.ac.manchester.cs.jfact.kernel.Role;

@PortedFrom(file="tIndividual.h", name="TIndividual")
public class Individual
extends Concept {
    @PortedFrom(file="tIndividual.h", name="node")
    private DlCompletionTree node = null;
    @PortedFrom(file="tIndividual.h", name="RelatedIndex")
    private final List<Related> relatedIndex = new ArrayList<Related>();
    @PortedFrom(file="tIndividual.h", name="pRelatedMap")
    private final Map<Role, List<Individual>> pRelatedMap = new HashMap<Role, List<Individual>>();

    public Individual(IRI name) {
        super(name);
        this.setSingleton(true);
    }

    @Override
    @PortedFrom(file="tIndividual.h", name="initToldSubsumers")
    public void initToldSubsumers() {
        boolean cd;
        this.toldSubsumers = null;
        this.setHasSP(false);
        if (this.isRelated()) {
            this.updateToldFromRelated();
        }
        if (this.isPrimitive() && this.description != null && this.description.isTOP()) {
            this.removeDescription();
        }
        boolean bl = cd = !this.hasExtraRules() && this.isPrimitive() && !this.isRelated();
        if (this.description != null || this.hasToldSubsumers()) {
            cd &= super.initToldSubsumers(this.description, new HashSet<Role>());
        }
        this.setCompletelyDefined(cd);
    }

    @PortedFrom(file="tIndividual.h", name="updateTold")
    private <T extends Related> void updateTold(List<T> begin, Set<Role> rolesProcessed) {
        begin.forEach(t -> this.searchTSbyRoleAndSupers(t.getRole(), rolesProcessed));
    }

    @PortedFrom(file="tIndividual.h", name="isRelated")
    private boolean isRelated() {
        return !this.relatedIndex.isEmpty();
    }

    @PortedFrom(file="tIndividual.h", name="addRelated")
    public void addRelated(Related p) {
        this.relatedIndex.add(p);
    }

    @PortedFrom(file="tIndividual.h", name="addRelated")
    public void addRelated(Individual p) {
        this.relatedIndex.addAll(p.relatedIndex);
    }

    @PortedFrom(file="tIndividual.h", name="hasRelatedCache")
    public boolean hasRelatedCache(Role r) {
        return this.pRelatedMap.containsKey(r);
    }

    @PortedFrom(file="tIndividual.h", name="getRelatedCache")
    public List<Individual> getRelatedCache(Role r) {
        assert (this.pRelatedMap.containsKey(r));
        return this.pRelatedMap.get(r);
    }

    @PortedFrom(file="tIndividual.h", name="setRelatedCache")
    public void setRelatedCache(Role r, List<Individual> v) {
        assert (!this.pRelatedMap.containsKey(r));
        this.pRelatedMap.put(r, v);
    }

    @PortedFrom(file="tIndividual.h", name="updateToldFromRelated")
    private void updateToldFromRelated() {
        HashSet<Role> rolesProcessed = new HashSet<Role>();
        this.updateTold(this.relatedIndex, rolesProcessed);
    }

    @Original
    public DlCompletionTree getNode() {
        return (DlCompletionTree)OWLAPIPreconditions.verifyNotNull((Object)this.node, (String)"individual not initialized");
    }

    @Original
    public boolean isFresh() {
        return this.node == null;
    }

    @Original
    public void setNode(DlCompletionTree node) {
        this.node = node;
    }

    @Original
    public List<Related> getRelatedIndex() {
        return this.relatedIndex;
    }
}

