/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.kernel;

import conformance.Original;
import conformance.PortedFrom;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import uk.ac.manchester.cs.jfact.helpers.LogAdapter;
import uk.ac.manchester.cs.jfact.kernel.RATransition;
import uk.ac.manchester.cs.jfact.kernel.Role;

@PortedFrom(file="RAutomaton.h", name="RAStateTransitions")
public class RAStateTransitions
implements Serializable {
    @PortedFrom(file="RAutomaton.h", name="Base")
    protected final List<RATransition> base = new ArrayList<RATransition>();
    @PortedFrom(file="RAutomaton.h", name="EmptyTransition")
    protected boolean emptyTransition = false;
    @PortedFrom(file="RAutomaton.h", name="ApplicableRoles")
    private final BitSet applicableRoles = new BitSet();
    @PortedFrom(file="RAutomaton.h", name="from")
    private int from;
    @PortedFrom(file="RAutomaton.h", name="DataRole")
    private boolean dataRole;
    @Original
    private int size = 0;
    @PortedFrom(file="RAutomaton.h", name="TopTransition")
    private boolean topTransition;

    @PortedFrom(file="RAutomaton.h", name="begin")
    public List<RATransition> begin() {
        return this.base;
    }

    @PortedFrom(file="RAutomaton.h", name="begin")
    public Stream<RATransition> stream() {
        return this.base.stream();
    }

    @PortedFrom(file="RAutomaton.h", name="add")
    public void add(RATransition trans) {
        this.base.add(trans);
        ++this.size;
        if (trans.isEmpty()) {
            this.emptyTransition = true;
        }
        if (trans.isTop()) {
            this.topTransition = true;
        }
    }

    @PortedFrom(file="RAutomaton.h", name="hasTopTransition")
    public boolean hasTopTransition() {
        return this.topTransition;
    }

    @PortedFrom(file="RAutomaton.h", name="empty")
    public boolean empty() {
        return this.size == 0;
    }

    @PortedFrom(file="RAutomaton.h", name="hasEmptyTransition")
    public boolean hasEmptyTransition() {
        return this.emptyTransition;
    }

    @PortedFrom(file="RAutomaton.h", name="print")
    public void print(LogAdapter o) {
        this.base.forEach(p -> p.print(o, this.from));
    }

    @PortedFrom(file="RAutomaton.h", name="setup")
    public void setup(int state, int nRoles, boolean data) {
        this.from = state;
        this.dataRole = data;
        this.base.stream().flatMap(p -> p.begin().stream()).forEach(p -> this.applicableRoles.set(p.getAbsoluteIndex()));
    }

    @PortedFrom(file="RAutomaton.h", name="addToExisting")
    public boolean addToExisting(RATransition trans) {
        int to = trans.finalState();
        boolean tEmpty = trans.isEmpty();
        Optional<RATransition> findAny = this.base.stream().filter(p -> p.finalState() == to && p.isEmpty() == tEmpty).findAny();
        if (findAny.isPresent()) {
            findAny.get().addIfNew(trans);
            return true;
        }
        return false;
    }

    @PortedFrom(file="RAutomaton.h", name="recognise")
    public boolean recognise(@Nullable Role r) {
        if (r == null) {
            return false;
        }
        return r.isDataRole() == this.dataRole && this.applicableRoles.get(r.getAbsoluteIndex());
    }

    @PortedFrom(file="RAutomaton.h", name="isSingleton")
    public boolean isSingleton() {
        return this.size == 1;
    }

    @PortedFrom(file="RAutomaton.h", name="getTransitionEnd")
    public int getTransitionEnd() {
        return this.base.get(0).finalState();
    }
}

