/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.kernel.todolist;

import conformance.PortedFrom;
import java.io.Serializable;
import uk.ac.manchester.cs.jfact.helpers.Helper;
import uk.ac.manchester.cs.jfact.kernel.ConceptWDep;
import uk.ac.manchester.cs.jfact.kernel.DlCompletionTree;
import uk.ac.manchester.cs.jfact.kernel.SaveStackRare;
import uk.ac.manchester.cs.jfact.kernel.todolist.ArrayQueue;
import uk.ac.manchester.cs.jfact.kernel.todolist.TODOListSaveState;
import uk.ac.manchester.cs.jfact.kernel.todolist.ToDoEntry;

public class QueueQueue
extends ArrayQueue {
    SaveStackRare stack;
    private int size = 0;

    public QueueQueue(SaveStackRare rare) {
        this.stack = rare;
    }

    @Override
    public void add(DlCompletionTree node, ConceptWDep offset) {
        ToDoEntry e = new ToDoEntry(node, offset);
        if (this.isEmpty() || ((ToDoEntry)this.wait.get(this.size - 1)).getNode().getNominalLevel() <= node.getNominalLevel()) {
            this.wait.add(e);
            ++this.size;
            return;
        }
        this.stack.push(new ArrayQueue.QueueRestorer(this));
        int n = this.size;
        while (n > this.sPointer && ((ToDoEntry)this.wait.get(n - 1)).getNode().getNominalLevel() > node.getNominalLevel()) {
            --n;
        }
        this.wait.add(n, e);
        ++this.size;
    }

    @Override
    @PortedFrom(file="ToDoList.h", name="clear")
    public void clear() {
        super.clear();
        this.size = 0;
    }

    @Override
    public boolean isEmpty() {
        return this.sPointer == this.size;
    }

    @PortedFrom(file="ToDoList.h", name="save")
    protected void save(TODOListSaveState tss) {
        tss.sp = this.sPointer;
        tss.ep = this.size;
    }

    @PortedFrom(file="ToDoList.h", name="restore")
    protected void restore(TODOListSaveState tss) {
        this.sPointer = tss.sp;
        Helper.resize(this.wait, tss.ep, null);
        this.size = tss.ep;
    }

    @Override
    public String toString() {
        return "{" + (!this.isEmpty() ? (Serializable)this.wait.get(this.sPointer) : "empty") + " sPointer: " + this.sPointer + " size: " + this.size + " Wait: " + this.wait + '}';
    }
}

