/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk;

import java.util.Objects;
import java.util.function.Supplier;

public interface RevertibleAction {
    public boolean apply();

    public void revert();

    public static RevertibleAction create(final Supplier<Boolean> applyAction, final Runnable revertAction) {
        Objects.requireNonNull(applyAction);
        Objects.requireNonNull(revertAction);
        return new RevertibleAction(){

            @Override
            public boolean apply() {
                return (Boolean)applyAction.get();
            }

            @Override
            public void revert() {
                revertAction.run();
            }
        };
    }

    public static RevertibleAction create(final Supplier<Boolean> precondition, final Supplier<Boolean> postApplyAction, final Runnable postRevertAction) {
        Objects.requireNonNull(precondition);
        Objects.requireNonNull(postApplyAction);
        Objects.requireNonNull(postRevertAction);
        return new RevertibleAction(){

            @Override
            public boolean apply() {
                return (Boolean)precondition.get() == false || (Boolean)postApplyAction.get() != false;
            }

            @Override
            public void revert() {
                if (((Boolean)precondition.get()).booleanValue()) {
                    postRevertAction.run();
                }
            }
        };
    }

    default public RevertibleAction then(final RevertibleAction other) {
        Objects.requireNonNull(other);
        return new RevertibleAction(){

            @Override
            public boolean apply() {
                if (!RevertibleAction.this.apply()) {
                    return false;
                }
                if (!other.apply()) {
                    RevertibleAction.this.revert();
                    return false;
                }
                return true;
            }

            @Override
            public void revert() {
                other.revert();
                RevertibleAction.this.revert();
            }
        };
    }
}

