/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner;

import java.util.Collection;
import java.util.Iterator;
import org.semanticweb.elk.exceptions.ElkRuntimeException;
import org.semanticweb.elk.reasoner.BatchListener;
import org.semanticweb.elk.reasoner.DummyBatchListener;
import org.semanticweb.elk.reasoner.ProgressMonitor;
import org.semanticweb.elk.util.collections.Counter;
import org.semanticweb.elk.util.collections.Operations;
import org.semanticweb.elk.util.concurrent.computation.ConcurrentComputationWithInputs;
import org.semanticweb.elk.util.concurrent.computation.ConcurrentExecutor;
import org.semanticweb.elk.util.concurrent.computation.InputProcessorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReasonerComputationWithInputs<I, F extends InputProcessorFactory<I, ?>>
extends ConcurrentComputationWithInputs<I, F> {
    private static final Logger LOGGER_ = LoggerFactory.getLogger(ReasonerComputationWithInputs.class);
    private final ProgressMonitor progressMonitor_;
    private final Iterator<? extends I> todo_;
    private final int maxProgress_;
    private int progress_;
    private I nextInput_;
    private final Counter batchCounter_;
    private final BatchListener batchListener_;

    private ReasonerComputationWithInputs(Iterator<? extends I> todo, int maxProgress, F inputProcessorFactory, ConcurrentExecutor executor, int maxWorkers, ProgressMonitor progressMonitor, BatchListener batchListener, Counter batchCounter) {
        super(inputProcessorFactory, executor, maxWorkers);
        this.progressMonitor_ = progressMonitor;
        this.todo_ = todo;
        this.maxProgress_ = maxProgress;
        this.progress_ = 0;
        this.nextInput_ = null;
        this.batchListener_ = batchListener;
        this.batchCounter_ = batchCounter;
    }

    private ReasonerComputationWithInputs(Iterator<? extends I> todo, int maxProgress, F inputProcessorFactory, ConcurrentExecutor executor, int maxWorkers, ProgressMonitor progressMonitor, int batchSize, BatchListener batchListener, Counter batchCounter) {
        this(batchSize < maxProgress ? Operations.synchronize((Iterator)batchCounter, todo) : todo, maxProgress, inputProcessorFactory, executor, maxWorkers, progressMonitor, batchListener, batchCounter);
    }

    private ReasonerComputationWithInputs(Iterator<? extends I> todo, int maxProgress, F inputProcessorFactory, ConcurrentExecutor executor, int maxWorkers, ProgressMonitor progressMonitor, int batchSize, BatchListener batchHandler) {
        this(todo, maxProgress, inputProcessorFactory, executor, maxWorkers, progressMonitor, batchSize, batchHandler, new Counter(batchSize));
    }

    public ReasonerComputationWithInputs(Collection<? extends I> inputs, F inputProcessorFactory, ConcurrentExecutor executor, int maxWorkers, ProgressMonitor progressMonitor, int batchSize, BatchListener batchListener) {
        this(inputs.iterator(), inputs.size(), inputProcessorFactory, executor, maxWorkers, progressMonitor, batchSize, batchListener);
    }

    public ReasonerComputationWithInputs(Collection<? extends I> inputs, F inputProcessorFactory, ConcurrentExecutor executor, int maxWorkers, ProgressMonitor progressMonitor) {
        this(inputs, inputProcessorFactory, executor, maxWorkers, progressMonitor, inputs.size() + 1, new DummyBatchListener());
    }

    public void process() {
        do {
            this.processBatch();
            if (this.isInterrupted()) {
                return;
            }
            this.batchListener_.batchProcessed();
            this.batchCounter_.reset();
        } while (this.todo_.hasNext());
    }

    private void processBatch() {
        if (!this.start()) {
            String message = "Could not start workers required for reasoner computation!";
            LOGGER_.error(message);
            throw new ElkRuntimeException(message);
        }
        try {
            if (this.nextInput_ != null && !this.processNextInput()) {
                return;
            }
            while (this.todo_.hasNext()) {
                this.nextInput_ = this.todo_.next();
                if (this.processNextInput()) continue;
                return;
            }
            this.finish();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ElkRuntimeException("Reasoner computation interrupted externally!");
        }
    }

    private boolean processNextInput() throws InterruptedException {
        if (!this.submit(this.nextInput_)) {
            this.waitWorkers();
            return false;
        }
        this.nextInput_ = null;
        if (this.isInterrupted()) {
            this.waitWorkers();
            return false;
        }
        this.progressMonitor_.report(++this.progress_, this.maxProgress_);
        return true;
    }
}

